!-------------------------------------------------------
!----------Labes & Separators & Fields Creation---------
!-------------------------------------------------------
!
!
!-------------------------------------------------------
!---------------------- PAGE #1 ------------------------
!-------------------------------------------------------
!
! page_1.cont_met --------------------------------------
!
interface separator create &
 separator_name = .gui.tc_wizard.page_1.cont_met.sep_met &
 location = 12.0, 80.0 &
 height = 2.0 &
 width = 630.0 &
 units = pixel 
! 
interface label create &
 label_name = .gui.tc_wizard.page_1.cont_met.l_method &
 location = 55.0, 24.0 &
 height = 25.0 &
 width = 97.0 &
 units = pixel &
 text = 'Method' &
 justified = left
!
interface label create &
 label_name = .gui.tc_wizard.page_1.cont_met.l_rigid &
 location = 12.0, 100.0 &
 height = 100.0 &
 width = 100.0 &
 units = pixel &
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\rigid_shaft.xpm' &
 justified = left
! 
interface label create &
 label_name = .gui.tc_wizard.page_1.cont_met.l_rigid_desc &
 location = 120.0, 100.0 &
 height = 100.0 &
 width = 510.0 &
 units = pixel &
 text = 'Turbocharger shaft is defined as a rigid body with inertia.' &
 justified = left 
!
interface label create &
 label_name = .gui.tc_wizard.page_1.cont_met.fig_beam &
 location = 12.0, 100.0 &
 height = 100.0 &
 width = 100.0 &
 units = pixel &
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\beam_shaft.xpm' &
 justified = left
! 
interface label create &
 label_name = .gui.tc_wizard.page_1.cont_met.l_beam_desc &
 location = 120.0, 100.0 &
 height = 100.0 &
 width = 510.0 &
 units = pixel &
 text = 'Turbocharger shaft is defined as a beam according to the Timoshenko beam theory.' &
 justified = left 
! 
interface label create &
 label_name = .gui.tc_wizard.page_1.cont_met.fig_fe_part &
 location = 12.0, 100.0 &
 height = 100.0 &
 width = 100.0 &
 units = pixel &
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\fe_part_shaft.xpm' &
 justified = left
! 
interface label create &
 label_name = .gui.tc_wizard.page_1.cont_met.l_fe_part_desc &
 location = 120.0, 100.0 &
 height = 100.0 &
 width = 510.0 &
 units = pixel &
 text = 'Turbocharger shaft is defined as flexible body via modal neutral file.' &
 justified = left 
!
interface label create &
 label_name = .gui.tc_wizard.page_1.cont_met.l_beam &
 location = 230.0, 24.0 &
 width = 150.0 &
 height = 25.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 text = 'Number of Segments' &
 justified = right
! 
interface field create &
 field_name = .gui.tc_wizard.page_1.cont_met.f_beam &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 400.0, 24.0 &
 height = 25.0 &
 width = 50.0 &
 lower_check = gt &
 lower_limit = 2.0 &
 scrollable = no &
 required = yes &
 preload_strings = '9' &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = ($_value)', &
 'var set var = $_topgui.page_2.cont_beam.required_rows int = (RTOI($_value))' , &
 'if condition = ((eval($_topgui.page_2.cont_beam.displayed_rows)) < (eval($_topgui.page_2.cont_beam.required_rows)))', &
 '   int data_t ins row  &', &
 '    data_t = .gui.tc_wizard.page_2.cont_beam.table_specs &', & 
 '    row_number = (eval($_topgui.page_2.cont_beam.displayed_rows)) &', &
 '    number_to_insert = (eval($_topgui.page_2.cont_beam.required_rows - $_topgui.page_2.cont_beam.displayed_rows)) &', &
 '    insert_action = after', &
 'end', &
 'if condition = ((eval($_topgui.page_2.cont_beam.displayed_rows)) > (eval($_topgui.page_2.cont_beam.required_rows)))', &
 '   interface data_table remove row &', &
 '   data_table_name = .gui.tc_wizard.page_2.cont_beam.table_specs &', &
 '   range = (eval($_topgui.page_2.cont_beam.required_rows+1)), (eval($_topgui.page_2.cont_beam.displayed_rows))', &
 'end', &
 'var set var=.gui.tc_wizard.page_2.cont_beam.displayed_rows int = (eval($_topgui.page_2.cont_beam.required_rows))'!, &
!
! Default value
variable set variable_name = .gui.tc_wizard.page_1.cont_met.f_beam.value &
 real_value = 9.0
variable set variable_name = .gui.tc_wizard.page_2.cont_beam.displayed_rows &
 integer_value = (eval(RTOI(.gui.tc_wizard.page_1.cont_met.f_beam.value)))
!
interface label create &
 label_name = .gui.tc_wizard.page_1.cont_met.l_fe_part &
 location = 230.0, 24.0 &
 width = 150.0 &
 height = 25.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 text = 'Shaft FE Part' &
 justified = right
! 
interface field create &
 field_name = .gui.tc_wizard.page_1.cont_met.f_fe_part &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 400.0, 24.0 &
 height = 25.0 &
 width = 200.0 &
 scrollable = no &
 required = yes &
 preload_strings = 'Pick Existing FE Part' &
 object_type = old &
 type_filter = Flexible_Body &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value_str string_value = ($_value)', &
 'variable set variable_name = $_self.value_real real_value = ($_value.adams_ID)'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_1.cont_met.f_fe_part.value_str &
 string_value = "Not specified" 
!
variable set variable_name = .gui.tc_wizard.page_1.cont_met.f_fe_part.value_real &
 real_value = -1.0 
!
!-------------------------------------------------------
!---------------------- PAGE #2 ------------------------
!-------------------------------------------------------
!
! page_2.cont_rigid_spec -------------------------------
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_rigid_spec.l_spec &
 location = 12.0, 8.0 &
 height = 25.0 &
 width = 200.0 &
 units = pixel &
 text = 'Specification' &
 justified = left
! 
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_rigid_spec.l_name_fig &
 location = 450.0, 40.0 &
 height = 100.0 &
 width = 200.0 &
 units = pixel &
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\shaft_specification.xpm' &
 justified = left
!
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_rigid_spec.l_length &
 location = 25.0, 48.0 &
 height = 25.0 &
 width = 150.0 &
 units = pixel &
 text = 'Shaft Length' &
 justified = right
!
interface field create &
 field_name = .gui.tc_wizard.page_2.cont_rigid_spec.f_length &
 enabled = yes &
 units = pixel &
 location = 200.0, 48.0 &
 height = 25.0 &
 width = 140.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(0.07452 m)" &
 lower_check = gt &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
! 'interface field modify field_name = $_topgui.page_2.cont_rigid_mat.c_mass.f_cm &', &
! '   upper_limit = (eval("$_value"))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_2.cont_rigid_spec.f_length.value &
 real_value = (0.07452 m) &
 units = "meter"
!
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_rigid_spec.l_dia &
 location = 25.0, 88.0 &
 height = 25.0 &
 width = 150.0 &
 units = pixel &
 text = 'Shaft Diameter' &
 justified = right
! 
interface field create &
 field_name = .gui.tc_wizard.page_2.cont_rigid_spec.f_dia &
 enabled = yes &
 units = pixel &
 location = 200.0, 88.0 &
 height = 25.0 &
 width = 140.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(0.009836 m)" &
 lower_check = gt &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_2.cont_rigid_spec.f_dia.value &
 real_value = (0.009836 m) &
 units = "meter"
!
file command read file="./_model/shaft_mat.cmd"
!
! page_2.cont_beam -------------------------------------
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_beam.l_density &
 location = 28.0, 8.0 &
 width = 100.0 &
 height = 25.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 text = 'Density' &
 justified = right
!
interface field create &
 field_name = .gui.tc_wizard.page_2.cont_beam.f_density &
 enabled = yes &
 units = pixel &
 location = 145.0, 8.0 &
 height = 25.0 &
 width = 200.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(7782.0(kg/meter**3))" &
 lower_check = ge &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_2.cont_beam.f_density.value &
 real_value = (7782.0(kg/meter**3)) & 
 units = "kg/meter**3"
!
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_beam.l_young &
 location = 28.0, 48.0 &
 width = 100.0 &
 height = 25.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 text = "Young's Modulus" &
 justified = right
!
interface field create &
 field_name = .gui.tc_wizard.page_2.cont_beam.f_young &
 enabled = yes &
 units = pixel &
 location = 145.0, 48.0 &
 height = 25.0 &
 width = 200.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(2.06E+05 (newton/mm**2))" &
 lower_check = ge &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_2.cont_beam.f_young.value &
 real_value = (2.06E+05 (newton/mm**2)) & 
 units = "newton/mm**2"
!
!
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_beam.l_poisson &
 location = 28.0, 88.0 &
 width = 100.0 &
 height = 25.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 text = "Poisson's Ratio" &
 justified = right
!
interface field create &
 field_name = .gui.tc_wizard.page_2.cont_beam.f_poisson &
 enabled = yes &
 units = pixel &
 location = 145.0, 88.0 &
 height = 25.0 &
 width = 200.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "0.3" &
 lower_check = ge &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_2.cont_beam.f_poisson.value &
 real_value = 0.3 
!
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_beam.l_damp &
 location = 28.0, 128.0 &
 width = 100.0 &
 height = 25.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 text = "Damping Ratio" &
 justified = right
!
interface field create &
 field_name = .gui.tc_wizard.page_2.cont_beam.f_damp &
 enabled = yes &
 units = pixel &
 location = 145.0, 128.0 &
 height = 25.0 &
 width = 200.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(0.000001 (sec))" &
 lower_check = ge &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_2.cont_beam.f_damp.value &
 real_value = (0.000001 (sec))
!
interface push_button create &
 push_button_name = .gui.tc_wizard.page_2.cont_beam.b_reset_table &
 enable = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 548.0, 42.0 &
 width = 115.0 &
 height = 25.0 & 
 label = "Reset Table" &
 commands = &
 'if condition = (DB_EXISTS(".gui.tc_wizard.page_2.cont_beam.table_specs"))', &
 '   interface data_table delete &', &
 '    data_table_name = .gui.tc_wizard.page_2.cont_beam.table_specs', & 
 'end', &
 'interface data_table create &', &
 ' data_table_name = .gui.tc_wizard.page_2.cont_beam.table_specs &', &
 ' units = pixel &', &
 ' horiz_resizing = attach_left &', &
 ' vert_resizing = attach_top &', &
 ' location = 10.0, 170.0 &', &
 ' width = 500 &', &
 ' height = 300 &', &
 ' editable = yes &', &
 ' auto_add_rows = yes', & 
 'int data_t ins col  &', &
 ' data_t = .gui.tc_wizard.page_2.cont_beam.table_specs &', &
 ' width = 10  &', &
 ' label = "Diameter" &', &                                              
 ' index = 1', &
 'int data_t ins col  &', &
 ' data_t = .gui.tc_wizard.page_2.cont_beam.table_specs &', &
 ' width = 10  &', &
 ' label = "Length" &', &
 ' index = 2', &
 'int data_t ins col  &', &
 ' data_t = .gui.tc_wizard.page_2.cont_beam.table_specs &', &
 ' width = 10  &', &
 ' label = "Divisions" &', &
 ' index = 3', &
 'int data_t ins row  &', &
 ' data_t = .gui.tc_wizard.page_2.cont_beam.table_specs &', &
 ' row_number = 2 &', &
 ' number_to_insert = (eval(RTOI(.gui.tc_wizard.page_1.cont_met.f_beam.value) - 1)) &', &
 ' insert_action = after'
! 
interface push_button execute &
 push_button_name = .gui.tc_wizard.page_2.cont_beam.b_reset_table 
!
! Default values
interface data_table set column &
 data_table_name = .gui.tc_wizard.page_2.cont_beam.table_specs &
 indices = 1 &
 reals = 10.969, 16.200, 21.260, 11.350, 21.260, 10.156, 9.836, 10.156, 18.250 & 
 enabled = yes &
 action = replace &
 value_type = real
!  
interface data_table set column &
 data_table_name = .gui.tc_wizard.page_2.cont_beam.table_specs &
 indices = 2 &
 reals = 10.938, 0.852, 1.557, 4.433, 1.510, 12.000, 20.000, 12.000, 11.220 &
 enabled = yes &
 action = replace &
 value_type = real
!  
interface data_table set column &
 data_table_name = .gui.tc_wizard.page_2.cont_beam.table_specs &
 indices = 3 &
 reals = 3, 1, 1, 2, 1, 3, 6, 3, 2  &
 enabled = yes &
 action = replace &
 value_type = real
!
interface push_button create &
 push_button_name = .gui.tc_wizard.page_2.cont_beam.b_ins_row &
 enable = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 548.0, 82.0 &
 width = 115.0 &
 height = 25.0 & 
 label = "Insert Row" &
 commands = &
 'int data_t ins row  &', &
 ' data_t = .gui.tc_wizard.page_2.cont_beam.table_specs &', & 
 ' row_number = (eval($_topgui.page_2.cont_beam.displayed_rows)) &', &
 ' number_to_insert = 1 &', &
 ' insert_action = after', &
 'var set var = .gui.tc_wizard.page_2.cont_beam.displayed_rows &', &
 ' integer_value = (eval($_topgui.page_2.cont_beam.displayed_rows + 1))', &
 'var set var = .gui.tc_wizard.page_2.cont_beam.required_rows &', &
 ' integer_value = (eval($_topgui.page_2.cont_beam.displayed_rows))', &
 'var set var = .gui.tc_wizard.page_1.cont_met.f_beam.value &', &
 ' real_value = (eval($_topgui.page_2.cont_beam.displayed_rows))', & 
 'interface field set &', &                                                           
 ' field_name = .gui.tc_wizard.page_1.cont_met.f_beam &', &
 ' strings = (eval($_topgui.page_2.cont_beam.displayed_rows))', &
 'interface field modify &', &
 ' field_name = .gui.tc_wizard.page_1.cont_met.f_beam &', &
 ' preload_strings = (eval($_topgui.page_2.cont_beam.displayed_rows))'  
!
interface push_button create &
 push_button_name = .gui.tc_wizard.page_2.cont_beam.b_rem_row &
 enable = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 548.0, 122.0 &
 width = 115.0 &
 height = 25.0 & 
 label = "Remowe Row" &
 commands = &
 'interface data_table remove row &', &
 ' data_table_name = .gui.tc_wizard.page_2.cont_beam.table_specs &', &
 ' range = (eval($_topgui.page_2.cont_beam.displayed_rows)), (eval($_topgui.page_2.cont_beam.displayed_rows))', & 
 'var set var = .gui.tc_wizard.page_2.cont_beam.displayed_rows &', &
 ' integer_value = (eval($_topgui.page_2.cont_beam.displayed_rows - 1))', &
 'var set var = .gui.tc_wizard.page_2.cont_beam.required_rows &', &
 ' integer_value = (eval($_topgui.page_2.cont_beam.displayed_rows))', &
 'var set var = .gui.tc_wizard.page_1.cont_met.f_beam.value &', &
 ' real_value = (eval($_topgui.page_2.cont_beam.displayed_rows))', & 
 'interface field set &', &                                                           
 ' field_name = .gui.tc_wizard.page_1.cont_met.f_beam &', &
 ' strings = (eval($_topgui.page_2.cont_beam.displayed_rows))', &
 'interface field modify &', &
 ' field_name = .gui.tc_wizard.page_1.cont_met.f_beam &', &
 ' preload_strings = (eval($_topgui.page_2.cont_beam.displayed_rows))' 



!
! page_2.cont_fe ---------------------------------------
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_fe.l_spec &
 location = 12.0, 8.0 &
 height = 25.0 &
 width = 200.0 &
 units = pixel &
 text = 'Specification' &
 justified = left
! 
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_fe.fig_spec &
 location = 400.0, 35.0 &
 height = 120.0 &
 width = 250.0 &
 units = pixel &
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\shaft_length.xpm' &
 justified = left
!
interface field create &
 field_name = .gui.tc_wizard.page_2.cont_fe.f_length &
 enabled = yes &
 units = pixel &
 location = 325.0, 128.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(0.07452 m)" &
 lower_check = gt &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = ($_value)'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_2.cont_fe.f_length.value &
 real_value = (0.07452 m) &
 units = "meter"
!
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_fe.l_cw_marker &
 location = 0.0, 48.0 &
 width = 240.0 &
 height = 25.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 text = 'Compressor Wheel Attachment Marker' &
 justified = right
! 
interface field create &
 field_name = .gui.tc_wizard.page_2.cont_fe.f_cw_marker &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 258.0, 48.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 preload_strings = 'Pick Marker' &
 object_type = old &
 type_filter = Marker &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value_str string_value = ($_value)', &
 'variable set variable_name = $_self.value_real real_value = ($_value.adams_ID)'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_2.cont_fe.f_cw_marker.value_str &
 string_value = "Not specified" 
!
variable set variable_name = .gui.tc_wizard.page_2.cont_fe.f_cw_marker.value_real &
 real_value = -1.0 
!
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_fe.l_tw_marker &
 location = 0.0, 88.0 &
 width = 240.0 &
 height = 25.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 text = 'Turbine Wheel Attachment Marker' &
 justified = right
! 
interface field create &
 field_name = .gui.tc_wizard.page_2.cont_fe.f_tw_marker &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 258.0, 88.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 preload_strings = 'Pick Marker' &
 object_type = old &
 type_filter = Marker &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value_str string_value = ($_value)', &
 'variable set variable_name = $_self.value_real real_value = ($_value.adams_ID)'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_2.cont_fe.f_tw_marker.value_str &
 string_value = "Not specified" 
!
variable set variable_name = .gui.tc_wizard.page_2.cont_fe.f_tw_marker.value_real &
 real_value = -1.0 
!
!
!-------------------------------------------------------
!---------------------- PAGE #3 ------------------------
!-------------------------------------------------------
!
! Contain is defined in './copy_entities.cmd' 
!
interface label create &
 label_name = .gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.c_unbalance.l_title &
 location = 12.0, 4.0 &
 height = 25.0 &
 width = 150.0 &
 units = pixel &
 text = 'Unbalance Definition'
!
interface label create &
 label_name = .gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.c_unbalance.fig_comp_unbalance &
 location = 250, 0.0 &
 height = 235.0 &
 width = 300.0 &
 units = pixel &
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\comp_unbalance.xpm' &
 justified = left
!
interface label create &
 label_name = .gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.c_unbalance.l_eddy &
 location = 115.0, 40.0 &
 height = 25.0 &
 width = 200.0 &
 units = pixel &
 text = 'Eddy-Current Sensors' &
 justified = right
!
interface field create &
 field_name = .gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.c_unbalance.f_eddy_pos &
 enabled = yes &
 units = pixel &
 location = 165.0, 15.0 &
 height = 25.0 &
 width = 150.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(35.12 mm)" &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = ($_value)'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.c_unbalance.f_eddy_pos.value &
 real_value = (35.12 mm) &
 units = "mm"
!
!
interface label create &
 label_name = .gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.c_unbalance.l_inter1 &
 location = 440.0, 65.0 &
 height = 25.0 &
 width = 100.0 &
 units = pixel &
 text = 'Wheel to Shaft' &
 justified = center
!
interface label create &
 label_name = .gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.c_unbalance.l_inter2 &
 location = 440.0, 81.0 &
 height = 25.0 &
 width = 100.0 &
 units = pixel &
 text = 'Interaction Point' &
 justified = center
!
interface field create &
 field_name = .gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.c_unbalance.f_un1_pos &
 enabled = yes &
 units = pixel &
 location = 170.0, 202.0 &
 height = 25.0 &
 width = 150.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(38.71 mm)" &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = ($_value)'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.c_unbalance.f_un1_pos.value &
 real_value = (38.71 mm) &
 units = "mm"
!
interface field create &
 field_name = .gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.c_unbalance.f_un2_pos &
 enabled = yes &
 units = pixel &
 location = 230.0, 170.0 &
 height = 25.0 &
 width = 150.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(8.29 mm)" &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = ($_value)'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.c_unbalance.f_un2_pos.value &
 real_value = (8.29 mm) &
 units = "mm"
!
interface field create &
 field_name = .gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.c_unbalance.f_un1_mass &
 enabled = yes &
 units = pixel &
 location = 170.0, 88.0 &
 height = 25.0 &
 width = 150.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 lower_check = ge &
 lower_limit = 0.0 & 
 preload_strings = "(1.3716 g)" &
 execute_cmds_on_exit = yes &
 help_text = 'Units of [MASS*mm]' &
 commands = &
 'variable set variable_name = $_self.value real_value = ($_value)'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.c_unbalance.f_un1_mass.value &
 real_value = (1.3716 g) &
 units = "gram-mm"
!
interface field create &
 field_name = .gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.c_unbalance.f_un2_mass &
 enabled = yes &
 units = pixel &
 location = 460.0, 153.0 &
 height = 25.0 &
 width = 150.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 lower_check = ge &
 lower_limit = 0.0 &
 preload_strings = "(1.3716E-3 g)" &
 execute_cmds_on_exit = yes &
 help_text = 'Units of [MASS*mm]' &
 commands = &
 'variable set variable_name = $_self.value real_value = ($_value)'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.c_unbalance.f_un2_mass.value &
 real_value = (1.3716E-3 g) &
 units = "gram"
!
interface label create &
 label_name = .gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.c_unbalance.l_title &
 location = 12.0, 4.0 &
 height = 25.0 &
 width = 150.0 &
 units = pixel &
 text = 'Unbalance Definition'
!
interface label create &
 label_name = .gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.c_unbalance.fig_comp_unbalance &
 location = 120, 0.0 &
 height = 235.0 &
 width = 500.0 &
 units = pixel &
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\turb_unbalance.xpm' &
 justified = left
!
interface label create &
 label_name = .gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.c_unbalance.l_inter1 &
 location = 315.0, 68.0 &
 height = 25.0 &
 width = 100.0 &
 units = pixel &
 text = 'Wheel to Shaft' &
 justified = center
!
interface label create &
 label_name = .gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.c_unbalance.l_inter2 &
 location = 315.0, 84.0 &
 height = 25.0 &
 width = 100.0 &
 units = pixel &
 text = 'Interaction Point' &
 justified = center
!
interface field create &
 field_name = .gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.c_unbalance.f_un1_pos &
 enabled = yes &
 units = pixel &
 location = 546.0, 202.0 &
 height = 25.0 &
 width = 150.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(31.78 mm)" &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = ($_value)'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.c_unbalance.f_un1_pos.value &
 real_value = (31.78 mm) &
 units = "mm"
!
interface field create &
 field_name = .gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.c_unbalance.f_un2_pos &
 enabled = yes &
 units = pixel &
 location = 478.0, 170.0 &
 height = 25.0 &
 width = 150.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(4.78 mm)" &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = ($_value)'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.c_unbalance.f_un2_pos.value &
 real_value = (4.78 mm) &
 units = "mm"
!
interface field create &
 field_name = .gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.c_unbalance.f_un1_mass &
 enabled = yes &
 units = pixel &
 location = 546.0, 90.0 &
 height = 25.0 &
 width = 150.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 lower_check = ge &
 lower_limit = 0.0 &
 preload_strings = "(1.2192 g)" &
 execute_cmds_on_exit = yes &
 help_text = 'Units of [MASS*mm]' &
 commands = &
 'variable set variable_name = $_self.value real_value = ($_value)'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.c_unbalance.f_un1_mass.value &
 real_value = (1.2192 g) &
 units = "gram"
!
interface field create &
 field_name = .gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.c_unbalance.f_un2_mass &
 enabled = yes &
 units = pixel &
 location = 270.0, 132.0 &
 height = 25.0 &
 width = 150.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 lower_check = ge &
 lower_limit = 0.0 &
 preload_strings = "(1.2192E-3 g)" &
 execute_cmds_on_exit = yes &
 help_text = 'Units of [MASS*mm]' &
 commands = &
 'variable set variable_name = $_self.value real_value = ($_value)'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.c_unbalance.f_un2_mass.value &
 real_value = (1.2192E-3 g) &
 units = "gram"
!
interface field create &
 field_name = .gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.c_unbalance.f_un_phase &
 enabled = yes &
 units = pixel &
 location = 223.0, 170.0 &
 height = 25.0 &
 width = 150.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(0.0 deg)" &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = ($_value)'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.c_unbalance.f_un_phase.value &
 real_value = (0.0 deg) &
 units = "degree"



!-------------------------------------------------------
!
!
!-------------------------------------------------------
!---------------------- PAGE #4 ------------------------
!-------------------------------------------------------
!
! page_4.cont_centr
interface label create &
 label_name = .gui.tc_wizard.page_4.cont_centr.l_att &
 location = 8.0, 8.0 &
 width = 140.0 &
 height = 25.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 text = 'Shaft is constrained to' &
 justified = right
!
interface label create &
 label_name = .gui.tc_wizard.page_4.cont_centr.l_part &
 location = 280.0, 8.0 &
 width = 50.0 &
 height = 25.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 text = 'Part' &
 justified = right
!
interface field create &
 field_name = .gui.tc_wizard.page_4.cont_centr.f_part &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 338.0, 8.0 &
 height = 25.0 &
 width = 200.0 &
 scrollable = no &
 required = yes &
 preload_strings = 'Pick Existing Part' &
 object_type = old &
 type_filter = Part &
 execute_cmds_on_exit = yes &
 commands = &
! 'interface field modify field_name = $_topgui.page_5.tab_bear.cont_bear_prop.f_part &', &
! ' name_filter = ".MODEL_1.PART_2"', &
! 'interface field modify field_name = $_topgui.page_5.tab_bear.cont_bear_prop_1.f_part &', &
! ' name_filter = "PART_2"', &
! 'interface field modify field_name = $_topgui.page_5.tab_bear.cont_bear_prop_2.f_part &', &
! ' name_filter = ".MODEL_1.PART_2"'
!
! 'interface field modify field_name = $_topgui.page_5.tab_bear.cont_bear_prop.f_part &', &
! ' name_filter = (eval($_value))', &
! 'interface field modify field_name = $_topgui.page_5.tab_bear.cont_bear_prop_1.f_part &', &
! ' name_filter = (eval($_value))', &
! 'interface field modify field_name = $_topgui.page_5.tab_bear.cont_bear_prop_2.f_part &', &
! ' name_filter = (eval($_value))' 
 'variable set variable_name = $_self.value_str string_value = ($_value)', &
 'variable set variable_name = $_self.value_real real_value = ($_value.adams_ID)'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_4.cont_centr.f_part.value_str &
 string_value = "Not specified" 
!
variable set variable_name = .gui.tc_wizard.page_4.cont_centr.f_part.value_real &
 real_value = -1.0 
!
interface field create &
 field_name = .gui.tc_wizard.page_4.cont_centr.f_fe_part &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 338.0, 8.0 &
 height = 25.0 &
 width = 200.0 &
 scrollable = no &
 required = yes &
 preload_strings = 'Pick Existing FE Part' &
 object_type = old &
 type_filter = Flexible_Body &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value_str string_value = ($_value)', &
 'variable set variable_name = $_self.value_real real_value = ($_value.adams_ID)'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_4.cont_centr.f_fe_part.value_str &
 string_value = "Not specified" 
!
variable set variable_name = .gui.tc_wizard.page_4.cont_centr.f_fe_part.value_real &
 real_value = -1.0 
!
!
!-------------------------------------------------------
!---------------------- PAGE #5 ------------------------
!-------------------------------------------------------
!
! page_5.cont_num
interface label create &
 label_name = .gui.tc_wizard.page_5.cont_num.l_num &
 location = 25.0, 8.0 &
 height = 25.0 &
 width = 120.0 &
 units = pixel &
 text = 'Number of Bearings' &
 justified = right
! 
interface field create &
 field_name = .gui.tc_wizard.page_5.cont_num.f_num &
 enabled = yes &
 units = pixel &
 location = 170.0, 8.0 &
 height = 25.0 &
 width = 40.0 &
 scrollable = no &
 required = yes &
 numeric_type = Integer &
 preload_strings = '2' &
 lower_check = ge &
 lower_limit = 2 &
 upper_check = le &
 upper_limit = 6 &
 execute_cmds_on_exit = yes &
 help_text = 'Minimum of 2, Maximum of 6.' &
 commands = &
 'var set var=$_topgui.page_5.required_tabs int=$_value', &
 'if condition = ((eval($_topgui.page_5.displayed_tabs)) < (eval($_topgui.page_5.required_tabs)))', &
 '   for variable_name = $_self.counter start_value = (eval(($_topgui.page_5.displayed_tabs)+1)) end_value = (eval($_topgui.page_5.required_tabs))', & 
 '       variable set variable_name = $_self.integer_count integer_value = (eval($_self.counter))', &
 '       entity copy entity_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop new_entity_name = (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//$_self.integer_count))', &            
 '       interface container display container_name = (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//$_self.integer_count))', & 
 '       interface container modify container_name = (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//$_self.integer_count)) tab_label = (eval($_self.integer_count))', &
 '   end', &
 'var set var=.gui.tc_wizard.page_5.displayed_tabs int=(eval($_self.integer_count))', &    
 'end', &
 'if condition = ((eval($_topgui.page_5.displayed_tabs)) > (eval($_topgui.page_5.required_tabs)))', &
 '   for variable_name = $_self.counter  start_value = (eval(($_topgui.page_5.required_tabs)+1)) end_value = (eval($_topgui.page_5.displayed_tabs))', &
 '       variable set variable_name = $_self.integer_count integer_value = (eval($_self.counter))', &
 '       interface container delete container_name = (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//$_self.integer_count))', & 
 '   end', &
 'var set var=.gui.tc_wizard.page_5.displayed_tabs int=(eval($_topgui.page_5.required_tabs))', &
 'end'
!
!
!-------------------------------------------------------
!---------------------- PAGE #6 ------------------------
!-------------------------------------------------------
!
! page_6.cont_num (nedari sa mi docielit, aby bola prva zobrazena hodnota tohto field ako '1')
interface field create &
 field_name = .gui.tc_wizard.page_6.cont_num.f_num &
 enabled = yes &
 units = pixel &
 location = 170.0, 8.0 &
 height = 25.0 &
 width = 40.0 &
 scrollable = no &
 required = yes &
 numeric_type = Integer &
 preload_strings = "1" &
 lower_check = ge &
 lower_limit = 1 &
 execute_cmds_on_exit = yes &
 commands = & 
 'var set var=$_topgui.page_6.required_tabs int=$_value', &
 'if condition = ((eval($_topgui.page_6.displayed_tabs)) < (eval($_topgui.page_6.required_tabs)))', &
 '   for variable_name = $_self.counter start_value = (eval(($_topgui.page_6.displayed_tabs)+1)) end_value = (eval($_topgui.page_6.required_tabs))', & 
 '       variable set variable_name = $_self.integer_count integer_value = (eval($_self.counter))', &
 '       entity copy entity_name = .gui.tc_wizard.page_6.tab_bear.cont_bear_prop new_entity_name = (eval(".gui.tc_wizard.page_6.tab_bear.cont_bear_prop_"//$_self.integer_count))', &            
 '       interface container display container_name = (eval(".gui.tc_wizard.page_6.tab_bear.cont_bear_prop_"//$_self.integer_count))', & 
 '       interface container modify container_name = (eval(".gui.tc_wizard.page_6.tab_bear.cont_bear_prop_"//$_self.integer_count)) tab_label = (eval($_self.integer_count))', &
 '   end', &
 'var set var=.gui.tc_wizard.page_6.displayed_tabs int=(eval($_self.integer_count))', &    
 'end' , &
 'if condition = ((eval($_topgui.page_5.displayed_tabs)) > (eval($_topgui.page_6.required_tabs)))', &
 '   for variable_name = $_self.counter  start_value = (eval(($_topgui.page_6.required_tabs)+1)) end_value = (eval($_topgui.page_6.displayed_tabs))', &
 '       variable set variable_name = $_self.integer_count integer_value = (eval($_self.counter))', &
 '       interface container delete container_name = (eval(".gui.tc_wizard.page_6.tab_bear.cont_bear_prop_"//$_self.integer_count))', & 
 '   end', &
 'var set var=.gui.tc_wizard.page_6.displayed_tabs int=(eval($_topgui.page_6.required_tabs))', &
 'end'
! 
!
!-------------------------------------------------------
!---------------------- PAGE #7 ------------------------
!-------------------------------------------------------
!
! page_7.cont_spec
interface label create &
 label_name = .gui.tc_wizard.page_7.cont_spec.fig_tc &
 location = 450.0, 8.0 &
 width = 200.0 &
 height = 100.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top & 
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\tc.xpm' &
 justified = left 
! 
interface label create &
 label_name = .gui.tc_wizard.page_7.cont_spec.l_dir &
 location = 25.0, 24.0 &
 height = 25.0 &
 width = 130.0 &
 units = pixel &
 text = 'Direction of Rotation' &
 justified = right
!
interface label create &
 label_name = .gui.tc_wizard.page_7.cont_spec.fig_dir_c &
 location = 400.0, 8.0 &
 width = 200.0 &
 height = 100.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top & 
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\arrow_r.xpm' &
 justified = left 
!
interface label create &
 label_name = .gui.tc_wizard.page_7.cont_spec.fig_dir_cc &
 location = 400.0, 8.0 &
 width = 200.0 &
 height = 100.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top & 
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\arrow_l.xpm' &
 justified = left 
!
interface label create &
 label_name = .gui.tc_wizard.page_7.cont_connect.l_num &
 location = 8.0, 8.0 &
 height = 25.0 &
 width = 130.0 &
 units = pixel &
 text = 'Number of Connectors' &
 justified = right
! 
interface field create &
 field_name = .gui.tc_wizard.page_7.cont_connect.f_num &
 enabled = yes &
 units = pixel &
 location = 170.0, 8.0 &
 height = 25.0 &
 width = 40.0 &
 scrollable = no &
 required = yes &
 numeric_type = Integer &
 preload_strings = "1" &
 lower_check = ge &
 lower_limit = 0 &
 upper_check = le &
 upper_limit = 5 &
 execute_cmds_on_exit = yes &
 commands = &
 'for variable_name = $_self.counter start_value = 1 end_value = 4', & 
 '    variable set variable_name = $_self.integer_count integer_value = (eval($_self.counter))', &
 '    interface label undisplay label_name = (eval("$_parent.c_scheme.fig_inertia_"//$_self.integer_count))', &
 '    interface field undisplay field_name = (eval("$_parent.c_inertia.f_inertia_"//$_self.integer_count))', &
 'end', &
! 
 'for variable_name = $_self.counter start_value = 1 end_value = 5', & 
 '    variable set variable_name = $_self.integer_count integer_value = (eval($_self.counter))', &
 '    interface label undisplay label_name = (eval("$_parent.c_scheme.fig_spr_damp_"//$_self.integer_count))', &
 '    interface field undisplay field_name = (eval("$_parent.c_stiff.f_stiff_"//$_self.integer_count))', &
 '    interface field undisplay field_name = (eval("$_parent.c_damp.f_damp_"//$_self.integer_count))', &
 'end', &
!
 'if condition = ((eval($_value)) == 0)', &
 '   interface label modify &', &
 '    label_name = $_topgui.page_7.cont_connect.c_scheme.fig_rot &', &
 '    location = 0.0, 37.0', &
 '   interface label modify &', &
 '    label_name = $_topgui.page_7.cont_connect.c_scheme.l_rot &', &
 '    location = 0.0, 37.0', &
 'else', &                                                                        
 '   interface label modify &', &
 '    label_name = $_topgui.page_7.cont_connect.c_scheme.fig_rot &', &
 '    location = 0.0, (eval(12.0+50.0*$_value))', &
 '   interface label modify &', &
 '    label_name = $_topgui.page_7.cont_connect.c_scheme.l_rot &', &
 '    location = 0.0, (eval(12.0+50.0*$_value))', &
 '   for variable_name = $_self.counter start_value = 1 end_value = (eval($_value))', &
 '       variable set variable_name = $_self.integer_count integer_value = (eval($_self.counter))', & 
 '       interface label display label_name = (eval("$_parent.c_scheme.fig_spr_damp_"//$_self.integer_count))', &       
 '       interface label display label_name = (eval("$_parent.c_scheme.fig_spr_damp_"//$_self.integer_count))', &
 '       interface field display field_name = (eval("$_parent.c_stiff.f_stiff_"//$_self.integer_count))', &
 '       interface field display field_name = (eval("$_parent.c_damp.f_damp_"//$_self.integer_count))', &
 '   end', &
 '   for variable_name = $_self.counter start_value = 1 end_value = (eval($_value-1))', &
 '       variable set variable_name = $_self.integer_count integer_value = (eval($_self.counter))', & 
 '       interface label display label_name = (eval("$_parent.c_scheme.fig_inertia_"//$_self.integer_count))', &       
 '       interface field display field_name = (eval("$_parent.c_inertia.f_inertia_"//$_self.integer_count))', &
 '   end', &
 'end', &
 'variable set variable_name = $_self.value integer_value = (eval($_value))'
! 
! Default value
variable set variable_name = .gui.tc_wizard.page_7.cont_connect.f_num.value &
 integer_value = 1  
!
! page_7.cont_connect
interface label create &
 label_name = .gui.tc_wizard.page_7.cont_connect.c_stiff.l_row &
 location = 0.0, 8.0 &
 height = 25.0 &
 width = 150.0 &
 units = pixel &
 text = 'Stiffness' &
 justified = center
!
interface label create &
 label_name = .gui.tc_wizard.page_7.cont_connect.c_damp.l_row &
 location = 0.0, 8.0 &
 height = 25.0 &
 width = 150.0 &
 units = pixel &
 text = 'Damping' &
 justified = center
!
interface label create &
 label_name = .gui.tc_wizard.page_7.cont_connect.c_inertia.l_row &
 location = 0.0, 8.0 &
 height = 25.0 &
 width = 150.0 &
 units = pixel &
 text = 'Inertia' &
 justified = center
!
interface field create &
 field_name = .gui.tc_wizard.page_7.cont_connect.c_stiff.f_stiff_1 &
 enabled = yes &
 units = pixel &
 location = 15.0, 37.0 &
 height = 25.0 &
 width = 120.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = '(1.0(N-mm/rad))' &
 lower_check = ge &
 lower_limit = 0.0 &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_7.cont_connect.c_stiff.f_stiff_1.value &
 real_value = (1.0(N-mm/rad)) &
 units = "Newton*mm/rad"   
!
interface field undisplay &
 field_name = .gui.tc_wizard.page_7.cont_connect.c_stiff.f_stiff_1  
! 
entity copy &
 entity_name = .gui.tc_wizard.page_7.cont_connect.c_stiff.f_stiff_1 &
 new_entity_name = .gui.tc_wizard.page_7.cont_connect.c_stiff.f_stiff_2
!
interface field modify &
 field_name = .gui.tc_wizard.page_7.cont_connect.c_stiff.f_stiff_2 &
 location = 15.0, 87.0
!
entity copy &
 entity_name = .gui.tc_wizard.page_7.cont_connect.c_stiff.f_stiff_1 &
 new_entity_name = .gui.tc_wizard.page_7.cont_connect.c_stiff.f_stiff_3
!
interface field modify &
 field_name = .gui.tc_wizard.page_7.cont_connect.c_stiff.f_stiff_3 &
 location = 15.0, 137.0
!
entity copy &
 entity_name = .gui.tc_wizard.page_7.cont_connect.c_stiff.f_stiff_1 &
 new_entity_name = .gui.tc_wizard.page_7.cont_connect.c_stiff.f_stiff_4
!
interface field modify &
 field_name = .gui.tc_wizard.page_7.cont_connect.c_stiff.f_stiff_4 &
 location = 15.0, 187.0
!
entity copy &
 entity_name = .gui.tc_wizard.page_7.cont_connect.c_stiff.f_stiff_1 &
 new_entity_name = .gui.tc_wizard.page_7.cont_connect.c_stiff.f_stiff_5
!
interface field modify &
 field_name = .gui.tc_wizard.page_7.cont_connect.c_stiff.f_stiff_5 &
 location = 15.0, 237.0
!
interface field display &
 field_name = .gui.tc_wizard.page_7.cont_connect.c_stiff.f_stiff_1  
!
interface field create &
 field_name = .gui.tc_wizard.page_7.cont_connect.c_damp.f_damp_1 &
 enabled = yes &
 units = pixel &
 location = 15.0, 37.0 &
 height = 25.0 &
 width = 120.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = '(1000.0(N-mm-sec/rad))' &
! preload_strings = '(50.0(N-m-sec/deg))' &
 lower_check = ge &
 lower_limit = 0.0 &
 horiz_resizing = attach_left &
 vert_resizing = attach_top & 
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_7.cont_connect.c_damp.f_damp_1.value &
 real_value = (1000.0(N-mm-sec/rad)) &
! real_value = (50.0(N-m-sec/deg)) &
 units = "newton*mm*second/rad"
! units = "newton*meter*second/degree"   
!
interface field undisplay &
 field_name = .gui.tc_wizard.page_7.cont_connect.c_damp.f_damp_1   
! 
entity copy &
 entity_name = .gui.tc_wizard.page_7.cont_connect.c_damp.f_damp_1 &
 new_entity_name = .gui.tc_wizard.page_7.cont_connect.c_damp.f_damp_2
!
interface field modify &
 field_name = .gui.tc_wizard.page_7.cont_connect.c_damp.f_damp_2 &
 location = 15.0, 87.0
!
entity copy &
 entity_name = .gui.tc_wizard.page_7.cont_connect.c_damp.f_damp_1 &
 new_entity_name = .gui.tc_wizard.page_7.cont_connect.c_damp.f_damp_3
!
interface field modify &
 field_name = .gui.tc_wizard.page_7.cont_connect.c_damp.f_damp_3 &
 location = 15.0, 137.0
!
entity copy &
 entity_name = .gui.tc_wizard.page_7.cont_connect.c_damp.f_damp_1 &
 new_entity_name = .gui.tc_wizard.page_7.cont_connect.c_damp.f_damp_4
!
interface field modify &
 field_name = .gui.tc_wizard.page_7.cont_connect.c_damp.f_damp_4 &
 location = 15.0, 187.0
!
entity copy &
 entity_name = .gui.tc_wizard.page_7.cont_connect.c_damp.f_damp_1 &
 new_entity_name = .gui.tc_wizard.page_7.cont_connect.c_damp.f_damp_5
!
interface field modify &
 field_name = .gui.tc_wizard.page_7.cont_connect.c_damp.f_damp_5 &
 location = 15.0, 237.0
!
interface field display &
 field_name = .gui.tc_wizard.page_7.cont_connect.c_damp.f_damp_1
! 
interface field create &
 field_name = .gui.tc_wizard.page_7.cont_connect.c_inertia.f_inertia_1 &
 enabled = yes &
 units = pixel &
 location = 15.0, 62.0 &
 height = 25.0 &
 width = 120.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = '(2E-004(kg-m**2))' &
 lower_check = ge &
 lower_limit = 0.0 &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &  
 execute_cmds_on_exit = yes & 
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_7.cont_connect.c_inertia.f_inertia_1.value &
 real_value = (2E-004(kg-m**2)) &
 units = "kilogram*meter**2"   
!
interface field undisplay &
 field_name = .gui.tc_wizard.page_7.cont_connect.c_inertia.f_inertia_1   
!
entity copy &
 entity_name = .gui.tc_wizard.page_7.cont_connect.c_inertia.f_inertia_1 &
 new_entity_name = .gui.tc_wizard.page_7.cont_connect.c_inertia.f_inertia_2
!
interface field modify &
 field_name = .gui.tc_wizard.page_7.cont_connect.c_inertia.f_inertia_2 &
 location = 15.0, 112.0
!
entity copy &
 entity_name = .gui.tc_wizard.page_7.cont_connect.c_inertia.f_inertia_1 &
 new_entity_name = .gui.tc_wizard.page_7.cont_connect.c_inertia.f_inertia_3
!
interface field modify &
 field_name = .gui.tc_wizard.page_7.cont_connect.c_inertia.f_inertia_3 &
 location = 15.0, 162.0
!
entity copy &
 entity_name = .gui.tc_wizard.page_7.cont_connect.c_inertia.f_inertia_1 &
 new_entity_name = .gui.tc_wizard.page_7.cont_connect.c_inertia.f_inertia_4
!
interface field modify &
 field_name = .gui.tc_wizard.page_7.cont_connect.c_inertia.f_inertia_4 &
 location = 15.0, 212.0
!
interface label create &
 label_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_tw &
 location = 0.0, 12.0 &
 height = 25.0 &
 width = 271.0 &
 units = pixel &
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\aengine\box1.xpm' &
 justified = center
!
interface label create &
 label_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.l_tw &
 location = 0.0, 12.0 &
 height = 25.0 &
 width = 271.0 &
 units = pixel &
 text = 'Turbine Wheel' &
 justified = center 
!
interface label create &
 label_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_rot &
 location = 0.0, 62.0 &
 height = 25.0 &
 width = 271.0 &
 units = pixel &
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\aengine\box1.xpm' &
 justified = center
!
interface label create &
 label_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.l_rot &
 location = 0.0, 62.0 &
 height = 25.0 &
 width = 271.0 &
 units = pixel &
 text = 'Applied Rotation' &
 justified = center 
!
interface label create &
 label_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_inertia_1 &
 location = 0.0, 62.0 &
 height = 25.0 &
 width = 271.0 &
 units = pixel &
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\aengine\mass.xpm' &
 justified = center
!
interface label undisplay &
 label_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_inertia_1   
!
entity copy &
 entity_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_inertia_1 &
 new_entity_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_inertia_2
!
interface label modify &
 label_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_inertia_2 &
 location = 0.0, 112.0
!
entity copy &
 entity_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_inertia_1 &
 new_entity_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_inertia_3
!
interface label modify &
 label_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_inertia_3 &
 location = 0.0, 162.0
!
entity copy &
 entity_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_inertia_1 &
 new_entity_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_inertia_4
!
interface label modify &
 label_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_inertia_4 &
 location = 0.0, 212.0
!
interface label create &
 label_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_spr_damp_1 &
 location = 0.0, 37.0 &
 height = 25.0 &
 width = 271.0 &
 units = pixel &
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\aengine\spring_damper.xpm' &
 justified = center
!
interface label undisplay &
 label_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_spr_damp_1   
!
entity copy &
 entity_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_spr_damp_1 &
 new_entity_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_spr_damp_2
!
interface label modify &
 label_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_spr_damp_2 &
 location = 0.0, 87.0
!
entity copy &
 entity_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_spr_damp_1 &
 new_entity_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_spr_damp_3
!
interface label modify &
 label_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_spr_damp_3 &
 location = 0.0, 137.0
!
entity copy &
 entity_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_spr_damp_1 &
 new_entity_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_spr_damp_4
!
interface label modify &
 label_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_spr_damp_4 &
 location = 0.0, 187.0
!
entity copy &
 entity_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_spr_damp_1 &
 new_entity_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_spr_damp_5
!
interface label modify &
 label_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_spr_damp_5 &
 location = 0.0, 237.0
!
interface label display &
 label_name = .gui.tc_wizard.page_7.cont_connect.c_scheme.fig_spr_damp_1   
!
!
!-------------------------------------------------------
!---------------------- PAGE #8 ------------------------
!-------------------------------------------------------
!
! page_8.cont_speed
interface label create &
 label_name = .gui.tc_wizard.page_8.cont_speed.l_method &
 location = 25.0, 8.0 &
 height = 25.0 &
 width = 120.0 &
 units = pixel &
 text = 'Speed defined as' &
 justified = right
! 
! page_8.cont_speed.c_const_speed
interface label create &
 label_name = .gui.tc_wizard.page_8.cont_speed.c_const_speed.l_speed &
 location = 25.0, 8.0 &
 height = 25.0 &
 width = 120.0 &
 units = pixel &
 text = 'Constant Speed' &
 justified = right
!
interface field create &
 field_name = .gui.tc_wizard.page_8.cont_speed.c_const_speed.f_speed &
 enabled = yes &
 units = pixel &
 location = 170.0, 8.0 &
 height = 25.0 &
 width = 70.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "40000.0" &
 lower_check = ge &
 lower_limit = 0 &
 help_text = 'Units of [rpm]' &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
! 
! Default value
variable set variable_name = .gui.tc_wizard.page_8.cont_speed.c_const_speed.f_speed.value &
 real_value = 40000.0  
!
! page_8.cont_speed.c_ramp
interface label create &
 label_name = .gui.tc_wizard.page_8.cont_speed.c_ramp.l_scheme &
 location = 150.0, 5.0 &                                        
 height = 400.0 &
 width = 500.0 &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 units = pixel &
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\ramp.xpm' &
 justified = left
!
interface label create &
 label_name = .gui.tc_wizard.page_8.cont_speed.c_ramp.l_axis_x &
 location = 565.0, 372.0 &
 height = 25.0 &
 width = 120.0 &
 units = pixel &
 text = 'Time' &
 justified = center  
!
interface label create &
 label_name = .gui.tc_wizard.page_8.cont_speed.c_ramp.l_axis_y &
 location = 30.0, 45.0 &
 height = 25.0 &
 width = 120.0 &
 units = pixel &
 text = 'Speed [rpm]' &
 justified = right 
!
interface label create &
 label_name = .gui.tc_wizard.page_8.cont_speed.c_ramp.l_axis_zero &
 location = 60.0, 372.0 &
 height = 25.0 &
 width = 120.0 &
 units = pixel &
 text = '0.0' &
 justified = right  
!
interface field create &
 field_name = .gui.tc_wizard.page_8.cont_speed.c_ramp.f_init_speed &
 enabled = yes &
 units = pixel &
 location = 80.0, 268.0 &
 height = 25.0 &
 width = 70.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "20000.0" &
 lower_check = ge &
 lower_limit = 0 &
 help_text = 'Units of [rpm]' &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
! 
! Default value
variable set variable_name = .gui.tc_wizard.page_8.cont_speed.c_ramp.f_init_speed.value &
 real_value = 20000.0  
!
interface field create &
 field_name = .gui.tc_wizard.page_8.cont_speed.c_ramp.f_end_speed &
 enabled = yes &
 units = pixel &
 location = 80.0, 105.0 &
 height = 25.0 &
 width = 70.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "40000.0" &
 lower_check = ge &
 lower_limit = 0 &
 help_text = 'Units of [rpm]' &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
! 
! Default value
variable set variable_name = .gui.tc_wizard.page_8.cont_speed.c_ramp.f_end_speed.value &
 real_value = 40000.0  
!
interface field create &
 field_name = .gui.tc_wizard.page_8.cont_speed.c_ramp.f_end_time &
 enabled = yes &
 units = pixel &
 location = 425.0, 372.0 &
 height = 25.0 &
 width = 70.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(1.0 sec)" &
 lower_check = ge &
 lower_limit = 0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
! 
! Default value
variable set variable_name = .gui.tc_wizard.page_8.cont_speed.c_ramp.f_end_time.value &
 real_value = (1.0 sec) &
 units = "second"  
!
! page_8.cont_speed.c_step
interface label create &
 label_name = .gui.tc_wizard.page_8.cont_speed.c_step.l_scheme &
 location = 150.0, 5.0 &                                       ! width x height 
 height = 400.0 &
 width = 500.0 &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 units = pixel &
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\step.xpm' &
 justified = left
!
interface label create &
 label_name = .gui.tc_wizard.page_8.cont_speed.c_step.l_axis_x &
 location = 565.0, 372.0 &
 height = 25.0 &
 width = 120.0 &
 units = pixel &
 text = 'Time' &
 justified = center  
!
interface label create &
 label_name = .gui.tc_wizard.page_8.cont_speed.c_step.l_axis_y &
 location = 30.0, 45.0 &
 height = 25.0 &
 width = 120.0 &
 units = pixel &
 text = 'Speed [rpm]' &
 justified = right 
!
interface label create &
 label_name = .gui.tc_wizard.page_8.cont_speed.c_step.l_axis_zero &
 location = 60.0, 372.0 &
 height = 25.0 &
 width = 120.0 &
 units = pixel &
 text = '0.0' &
 justified = right  
!
interface field create &
 field_name = .gui.tc_wizard.page_8.cont_speed.c_step.f_speed_0 &
 enabled = yes &
 units = pixel &
 location = 80.0, 268.0 &
 height = 25.0 &
 width = 70.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "25000.0" &
 lower_check = ge &
 lower_limit = 0 &
 help_text = 'Units of [rpm]' &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
! 
! Default value
variable set variable_name = .gui.tc_wizard.page_8.cont_speed.c_step.f_speed_0.value &
 real_value = 25000.0  
!
interface field create &
 field_name = .gui.tc_wizard.page_8.cont_speed.c_step.f_speed_1 &
 enabled = yes &
 units = pixel &
 location = 80.0, 105.0 &
 height = 25.0 &
 width = 70.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "120000.0" &
 lower_check = ge &
 lower_limit = 0 &
 help_text = 'Units of [rpm]' &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
! 
! Default value
variable set variable_name = .gui.tc_wizard.page_8.cont_speed.c_step.f_speed_1.value &
 real_value = 120000.0  
!
interface field create &
 field_name = .gui.tc_wizard.page_8.cont_speed.c_step.f_time_0 &
 enabled = yes &
 units = pixel &
 location = 215.0, 372.0 &
 height = 25.0 &
 width = 70.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(1.0 sec)" &
 lower_check = ge &
 lower_limit = 0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
! 
! Default value
variable set variable_name = .gui.tc_wizard.page_8.cont_speed.c_step.f_time_0.value &
 real_value = (1.0 sec) &
 units = "second" 
!
interface field create &
 field_name = .gui.tc_wizard.page_8.cont_speed.c_step.f_time_1 &
 enabled = yes &
 units = pixel &
 location = 380.0, 372.0 &
 height = 25.0 &
 width = 70.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(3.0 sec)" &
 lower_check = ge &
 lower_limit = 0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
! 
! Default value
variable set variable_name = .gui.tc_wizard.page_8.cont_speed.c_step.f_time_1.value &
 real_value = (3.0 sec) &
 units = "second" 
!
! page_8.cont_speed.c_spline
interface label create &
 label_name = .gui.tc_wizard.page_8.cont_speed.c_spline.l_spline &
 location = 25.0, 8.0 &
 height = 25.0 &
 width = 120.0 &
 units = pixel &
 text = 'Spline' &
 justified = right
!
interface field create &
 field_name = .gui.tc_wizard.page_8.cont_speed.c_spline.f_spline &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 170.0, 8.0 &
 height = 25.0 &
 width = 170.0 &
 scrollable = no &
 required = yes &
 preload_strings = 'Pick Existing Spline' &
 object_type = old &
 type_filter = Spline &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value_real real_value = ($_value.adams_ID)', & 
 'variable set variable_name = $_self.value_str string_value = (eval($_value))'     
! 'variable set variable_name = $_self.value_int integer_value = (eval($_value.adams_ID))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_8.cont_speed.c_spline.f_spline.value_str &
 string_value = "Not specified"
!variable set variable_name = .gui.tc_wizard.page_8.cont_speed.c_spline.f_spline.value_int &
! integer_value = -1
variable set variable_name = .gui.tc_wizard.page_8.cont_speed.c_spline.f_spline.value_real &
 real_value = -1.0
!
interface label create &
 label_name = .gui.tc_wizard.page_8.cont_speed.c_spline.l_init_speed &
 location = 380.0, 8.0 &
 height = 25.0 &
 width = 120.0 &
 units = pixel &
 text = 'Initial Speed' &
 justified = right
!
interface field create &
 field_name = .gui.tc_wizard.page_8.cont_speed.c_spline.f_init_speed &
 enabled = yes &
 units = pixel &
 location = 525.0, 8.0 &
 height = 25.0 &
 width = 70.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "25000.0" &
 lower_check = ge &
 lower_limit = 0 &
 help_text = 'Units of [rpm]' &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
! 
! Default value
variable set variable_name = .gui.tc_wizard.page_8.cont_speed.c_spline.f_init_speed.value &
 real_value = 25000.0  











!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
!---------------------- PAGE #9 ------------------------
!-------------------------------------------------------
!
! page_9.cont_spec
interface label create &
 label_name = .gui.tc_wizard.page_9.cont_spec.fig_tc &
 location = 450.0, 48.0 &
 width = 200.0 &
 height = 100.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top & 
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\tc.xpm' &
 justified = left 
! 
interface label create &
 label_name = .gui.tc_wizard.page_9.cont_spec.l_dir &
 location = 25.0, 64.0 &
 height = 25.0 &
 width = 130.0 &
 units = pixel &
 text = 'Force Direction' &
 justified = right
!
interface label create &
 label_name = .gui.tc_wizard.page_9.cont_spec.fig_dir_p &
 location = 400.0, 48.0 &
 width = 200.0 &
 height = 100.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top & 
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\arrow_l.xpm' &
 justified = left 
!
interface label create &
 label_name = .gui.tc_wizard.page_9.cont_spec.fig_dir_n &
 location = 400.0, 48.0 &
 width = 200.0 &
 height = 100.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top & 
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\arrow_r.xpm' &
 justified = left 
!
interface label create &
 label_name = .gui.tc_wizard.page_9.cont_spec.l_method &
 location = 25.0, 104.0 &
 height = 25.0 &
 width = 130.0 &
 units = pixel &
 text = 'Force defined as' &
 justified = right
!
! page_9.cont_def
interface field create &
 field_name = .gui.tc_wizard.page_9.cont_def.f_const &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 88.0, 8.0 &
 height = 25.0 &
 width = 200.0 &
 scrollable = no &
 required = yes &
 preload_strings = '10.0 N' &
 object_type = old &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value_str string_value = ($_value)'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_9.cont_def.f_const.value &
 real_value = (10.0 N) &
 units = Newton  
!
interface field create &
 field_name = .gui.tc_wizard.page_9.cont_def.f_spline &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 88.0, 48.0 &
 height = 25.0 &
 width = 200.0 &
 scrollable = no &
 required = yes &
 preload_strings = 'Pick Existing Spline' &
 object_type = old &
 type_filter = Spline &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value_str string_value = ($_value)', &
 'variable set variable_name = $_self.value_real real_value = ($_value.adams_ID)' &
 help_text = 'Spline Relative to Shaft Rotational Speed in RPM'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_9.cont_def.f_spline.value_str &
 string_value = "Not specified" 
!
variable set variable_name = .gui.tc_wizard.page_9.cont_def.f_spline.value_real &
 real_value = -1.0 


!-------------------------------------------------------
!
!-------------------------------------------------------
!--------------------- PAGE #10 ------------------------
!-------------------------------------------------------
!
! page_10.cont_completion
interface label create &
 label_name = .gui.tc_wizard.page_10.cont_completion.l_compl &
 location = 40.0, 100.0 &
 width = 650.0 &
 height = 45.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 text = 'This concludes the turbocharger specification.  Click the Finish button to create the turbocharger as specified<br>or click Back to make modifications.' &
 justified = left
!
return


   