!-------------------------------------------------------
!------------------Db Boxes Creation--------------------
!-------------------------------------------------------
!
interface dialog_box create dialog_box_name = .gui.oil_properties &
 units = pixel &
 location = 290.0, 300.0 &
 width = 500 &
 height = 450 &
 title = 'Oil Properties' &
 resizable = no !&
!
interface push_button create push_button_name = .gui.oil_properties.button_ok &
 units = pixel &
 location = 260.0, 421.0 &
 width = 76.0 &
 height = 25.0 &
 label = 'OK' &
 enabled = yes &
 commands = &
 'interface dialog execute dialog=$_parent undisp=yes'
!
interface push_button create push_button_name = .gui.oil_properties.button_apply &
 units = pixel &
 location = 340.0, 421.0 &
 width = 76.0 &
 height = 25.0 &
 label = 'Apply' &
 enabled = yes &
 commands = &
 'interface dialog execute dialog=$_parent undisp=no'
! 
interface push_button create push_button_name = .gui.oil_properties.button_cancel &
 units = pixel &
 location = 420.0, 421.0 &
 width = 76.0 &
 height = 25.0 &
 label = 'Cancel' &
 enabled = yes &
 commands = &
 'interface dialog undisplay dialog=$_parent'
!
interface separator create &
 separator_name = .gui.oil_properties.sep_vis &
 location = 12.0, 12.0 &
 height = 2.0 &
 width = 476.0 &
 units = pixel 
!
interface label create &
 label_name =  .gui.oil_properties.l_vis_hths &
 location = 12.0, 18.0 &
 height = 25.0 &
 width = 95.0 &
 units = pixel &
 text = 'Viscosity, HTHS' &
 justified = right 
!
interface field create &
 field_name = .gui.oil_properties.f_vis_hths &
 enabled = yes &
 units = pixel &
 location = 140.0, 18.0 &
 height = 25.0 &
 width = 170.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(0.0035 (N-sec/meter**2))" &
 lower_check = ge &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 help_text = 'High Temperature, High Shear Viscosity' &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.oil_properties.f_vis_hths.value &
 real_value = (0.0035 (N-sec/meter**2))
!
interface label create &
 label_name =  .gui.oil_properties.l_vogel_vis &
 location = 12.0, 47.0 &
 height = 25.0 &
 width = 200.0 &
 units = pixel &
 text = 'Viscosity = a * exp(b / (t - c))' &
 justified = left 
!
interface label create &
 label_name =  .gui.oil_properties.l_vogel_a &
 location = 12.0, 76.0 &
 height = 25.0 &
 width = 20.0 &
 units = pixel &
 text = 'a' &
 justified = right 
!
interface field create &
 field_name = .gui.oil_properties.f_vogel_a &
 enabled = yes &
 units = pixel &
 location = 50.0, 76.0 &
 height = 25.0 &
 width = 200.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(0.00009735 (N-sec/meter**2))" &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.oil_properties.f_vogel_a.value &
 real_value = (0.00009735 (N-sec/meter**2)) 
!
interface label create &
 label_name =  .gui.oil_properties.l_vogel_b &
 location = 12.0, 103.0 &
 height = 25.0 &
 width = 20.0 &
 units = pixel &
 text = 'b' &
 justified = right 
!
interface field create &
 field_name = .gui.oil_properties.f_vogel_b &
 enabled = yes &
 units = pixel &
 location = 50.0, 103.0 &
 height = 25.0 &
 width = 200.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "1041" &
 execute_cmds_on_exit = yes &
 help_text = 'Constant [C]' &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.oil_properties.f_vogel_b.value &
 real_value = (1041)
!
interface label create &
 label_name =  .gui.oil_properties.l_vogel_c &
 location = 12.0, 130.0 &
 height = 25.0 &
 width = 20.0 &
 units = pixel &
 text = 'c' &
 justified = right 
!
interface field create &
 field_name = .gui.oil_properties.f_vogel_c &
 enabled = yes &
 units = pixel &
 location = 50.0, 130.0 &
 height = 25.0 &
 width = 200.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "-123.6" &
 execute_cmds_on_exit = yes &
 help_text = 'Constant [C]' &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.oil_properties.f_vogel_c.value &
 real_value = (-123.6)
!
interface separator create &
 separator_name = .gui.oil_properties.sep_dens &
 location = 12.0, 167.0 &
 height = 2.0 &
 width = 476.0 &
 units = pixel 
!
interface label create &
 label_name =  .gui.oil_properties.l_dens &
 location = 12.0, 173.0 &
 height = 25.0 &
 width = 300.0 &
 units = pixel &
 text = 'Density = Rho / (1 + Alpha * Deltat)' &
 justified = left 
!
interface label create &
 label_name =  .gui.oil_properties.l_dens_ref &
 location = 12.0, 202.0 &
 height = 25.0 &
 width = 60.0 &
 units = pixel &
 text = 'Rho' &
 justified = right 
!
interface field create &
 field_name = .gui.oil_properties.f_dens_0 &
 enabled = yes &
 units = pixel &
 location = 100.0, 202.0 &
 height = 25.0 &
 width = 150.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(843 (kg/meter**3))" &
 lower_check = ge &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.oil_properties.f_dens_0.value &
 real_value = (843 (kg/meter**3)) &
 units = density   
!              
interface label create &
 label_name =  .gui.oil_properties.l_temp_0 &
 location = 260.0, 202.0 &
 height = 25.0 &
 width = 90.0 &
 units = pixel &
 text = 'at Temperature' &
 justified = left 
!
interface field create &
 field_name = .gui.oil_properties.f_temp_0 &
 enabled = yes &
 units = pixel &
 location = 360.0, 202.0 &
 height = 25.0 &
 width = 50.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "20.0" &
 execute_cmds_on_exit = yes &
 help_text = '[C]' &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.oil_properties.f_temp_0.value &
 real_value = (20.0)
!              
interface label create &
 label_name =  .gui.oil_properties.l_alpha &
 location = 12.0, 229.0 &
 height = 25.0 &
 width = 60.0 &
 units = pixel &
 text = 'Alpha' &
 justified = right 
!
interface field create &
 field_name = .gui.oil_properties.f_alpha &
 enabled = yes &
 units = pixel &
 location = 100.0, 229.0 &
 height = 25.0 &
 width = 150.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "0.0007" &
 lower_check = ge &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 help_text = 'Thermal Expansion Coefficient [C-1]' &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.oil_properties.f_alpha.value &
 real_value = (0.0007) 
!
interface separator create &
 separator_name = .gui.oil_properties.sep_flow &
 location = 12.0, 266.0 &
 height = 2.0 &
 width = 476.0 &
 units = pixel 
!
interface label create &
 label_name =  .gui.oil_properties.l_temp &
 location = 12.0, 273.0 &
 height = 25.0 &
 width = 120.0 &
 units = pixel &
 text = 'Inlet Oil Temperature' &
 justified = right 
!
interface field create &
 field_name = .gui.oil_properties.f_temp &
 enabled = yes &
 units = pixel &
 location = 140.0, 273.0 &
 height = 25.0 &
 width = 50.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "80.0" &
 execute_cmds_on_exit = yes &
 help_text = '[C]' &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.oil_properties.f_temp.value &
 real_value = (80.0) 
! 
interface label create &
 label_name =  .gui.oil_properties.l_vol_flow &
 location = 12.0, 300.0 &
 height = 25.0 &
 width = 120.0 &
 units = pixel &
 text = 'Oil Volumetric Flow' &
 justified = right 
!
interface field create &
 field_name = .gui.oil_properties.f_vol_flow &
 enabled = yes &
 units = pixel &
 location = 140.0, 300.0 &
 height = 25.0 &
 width = 200.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(20.0E-6 (meter**3/minute))" &
 lower_check = ge &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.oil_properties.f_vol_flow.value &
 real_value = (20.0E-6 (meter**3/minute)) &
 units = "meter**3/minute"
! 
interface label create &
 label_name =  .gui.oil_properties.l_heat_cap &
 location = 12.0, 327.0 &
 height = 25.0 &
 width = 140.0 &
 units = pixel &
 text = 'Specific Heat Capacity' &
 justified = right 
! 
interface field create &
 field_name = .gui.oil_properties.f_heat_cap &
 enabled = yes &
 units = pixel &
 location = 160.0, 327.0 &
 height = 25.0 &
 width = 50.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "2240" &
 lower_check = ge &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 help_text = 'Specific Heat Capacity at Constant Pressure [J.kg-1.C-1]' &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.oil_properties.f_heat_cap.value &
 real_value = (2240)
!
interface toggle_button create &
 toggle_button_name = .gui.oil_properties.flag_shear_heat &
 enabled = yes &
 location = 12.0, 354.0 &
 height = 25.0 &
 width = 488.0 &
 units = pixel &
 label = 'Shear Heating Effects' &
 on_value = on &
 off_value = off &
 state = off &
 commands = &
 'variable set variable_name = $_self.value real_value = 0.0', &
 'interface field modify field = .gui.oil_properties.f_dens_0 enabled = no', &
 'interface field modify field = .gui.oil_properties.f_temp_0 enabled = no', &
 'interface field modify field = .gui.oil_properties.f_alpha enabled = no', &
 'interface field modify field = .gui.oil_properties.f_vol_flow enabled = no', &
 'interface field modify field = .gui.oil_properties.f_heat_cap enabled = no', &
 'if condition= ("$_value" == "on")', &
 '   variable set variable_name = $_self.value real_value = 1.0', &
 '   interface field modify field = .gui.oil_properties.f_dens_0 enabled = yes', &
 '   interface field modify field = .gui.oil_properties.f_temp_0 enabled = yes', &
 '   interface field modify field = .gui.oil_properties.f_alpha enabled = yes', &
 '   interface field modify field = .gui.oil_properties.f_vol_flow enabled = yes', &
 '   interface field modify field = .gui.oil_properties.f_heat_cap enabled = yes', &
 'end'
!
interface toggle_button execute &
 toggle_button_name = .gui.oil_properties.flag_shear_heat
!
!interface dialog_box display dialog_box_name = .gui.oil_properties
!
!-------------------------------------------------------
return