!-------------------------------------------------------
! Creates material option menu inside interface 
! container named 
! .gui.tc_wizard.page_2.cont_rigid_mat
!-------------------------------------------------------

!------------------------------------------------------- 
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_rigid_mat.mass_option_label &
 location = 12.0, 8.0 &
 height = 25.0 &
 width = 113.0 &
 enabled = yes &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 units = pixel &
 text = 'Define Mass by' &
 justified = left
!
! c_density --------------------------------------------
interface field create &
 field_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_density.f_density &
 enabled = yes &
 units = pixel &
 location = 125.0, 8.0 &
 height = 25.0 &
 width = 488.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(7800.0(kg/meter**3))" &
 lower_check = ge &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_density.f_density.value &
 real_value = (7800.0(kg/meter**3)) & 
 units = "kg/meter**3"
!
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_density.l_density &
 location = 4.0, 8.0 &
 height = 25.0 &
 width = 113.0 &
 units = pixel &
 text = 'Density' &
 justified = right
!
! c_material_type --------------------------------------
interface field create &
 field_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_material_type.f_material &
 enabled = yes &
 units = pixel &
 location = 125.0, 8.0 &
 height = 25.0 &
 width = 488.0 &
 scrollable = no &
 required = yes &
 preload_strings = ".materials.steel" &
 object_type = old &
 type_filter = Material &
 execute_cmds_on_exit = yes &
 commands = &
 'if condition=(!str_is_space("$_value"))', &
 '   interface label modify label = $_parent.l_val_density &', &
 '   text=(eval(db_exists("$_value") ? $_value.density // " " //units_string("$_value.density") : " "))', &
 '   interface label modify label = $_parent.l_val_youngs &', &
 '   text=(eval(db_exists("$_value") ? $_value.youngs_modulus // " " //units_string("$_value.youngs_modulus") : " "))', &
 '   interface label modify label = $_parent.l_val_poisson &', &
 '   text=(eval(db_exists("$_value") ? user_string($_value.poissons_ratio) : " "))', &
 '   variable set variable_name = $_self.value string_value = (eval("$_value"))', &
 'end'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_material_type.f_material.value &
 string_value = ".materials.steel"  
!
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_material_type.l_val_density &
 location = 125.0, 35.0 &
 height = 25.0 &
 width = 150.0 &
 units = pixel &
 text = '7.801E-06 kg/mm**3' &
 justified = left
!
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_material_type.l_val_youngs &
 location = 125.0, 62.0 &
 height = 25.0 &
 width = 150.0 &
 units = pixel &
 text = '2.07E+05 newton/mm**2' &
 justified = left
! 
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_material_type.l_val_poisson &
 location = 125.0, 89.0 &
 height = 25.0 &
 width = 150.0 &
 units = pixel &
 text = '0.29' &
 justified = left
!
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_material_type.l_material &
 location = 4.0, 8.0 &
 height = 25.0 &
 width = 113.0 &
 units = pixel &
 text = 'Material Type' &
 justified = right
!  
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_material_type.l_density &
 location = 4.0, 35.0 &
 height = 25.0 &
 width = 113.0 &
 units = pixel &
 text = 'Density' &
 justified = right
!
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_material_type.l_youngs &
 location = 4.0, 62.0 &
 height = 25.0 &
 width = 113.0 &
 units = pixel &
 text = "Young's Modulus" &
 justified = right
!
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_material_type.l_poisson &
 location = 4.0, 89.0 &
 height = 25.0 &
 width = 113.0 &
 units = pixel &
 text = "Poisson's Ratio" &
 justified = right 
!
! c_user -----------------------------------------------
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.l_mass &
 location = 4.0, 8.0 &
 height = 25.0 &
 width = 160.0 &
 units = pixel &
 text = 'Mass' &
 justified = right
!
interface field create &
 field_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_mass &
 enabled = yes &
 units = pixel &
 location = 172.0, 8.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(0.08307 kg)" &
 lower_check = ge &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_mass.value &
 real_value = (0.08307 kg) & 
 units = "kg"
!
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.l_cm &
 location = 4.0, 35.0 &
 height = 25.0 &
 width = 160.0 &
 units = pixel &
 text = "Center of Gravity Position" &
 justified = right
!
interface field create &
 field_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_cm &
 enabled = yes &
 units = pixel &
 location = 172.0, 35.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(0.0413 m)" & 
 execute_cmds_on_exit = yes &   
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_cm.value &
 real_value = (0.0413 m) & 
 units = "meter"
!
interface separator create &
 separator_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.sep &
 location = 12.0, 64.0 &
 height = 2.0 &
 width = 686.0 &
 units = pixel 
!
interface field create &
 field_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_ixx &
 enabled = yes &
 units = pixel &
 location = 172.0, 68.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(5.77E-005(kg-m**2))" &
 lower_check = ge &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_ixx.value &
 real_value = (5.77E-005(kg-m**2)) & 
 units = "kg-meter**2"
!
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.l_ixx &
 location = 4.0, 68.0 &
 height = 25.0 &
 width = 160.0 &
 units = pixel &
 text = "Ixx" &
 justified = right 
!
interface field create &
 field_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_ixy &
 enabled = yes &
 units = pixel &
 location = 172.0, 95.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(0.0(kg-m**2))" &
 lower_check = ge &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_ixy.value &
 real_value = (0.0(kg-meter**2)) & 
 units = "kg-meter**2" 
!
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.l_ixy &
 location = 4.0, 95.0 &
 height = 25.0 &
 width = 160.0 &
 units = pixel &
 text = "Ixy" &
 justified = right
!
interface field create &
 field_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_ixz &
 enabled = yes &
 units = pixel &
 location = 172.0, 122.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(0.0(kg-m**2))" &
 lower_check = ge &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_ixz.value &
 real_value = (0.0(kg-meter**2)) & 
 units = "kg-meter**2" 
!
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.l_ixz &
 location = 4.0, 122.0 &
 height = 25.0 &
 width = 160.0 &
 units = pixel &
 text = "Ixz" &
 justified = right
!
interface field create &
 field_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_iyy &
 enabled = yes &
 units = pixel &
 location = 350.0, 95.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(5.77E-005(kg-m**2))" &
 lower_check = ge &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_iyy.value &
 real_value = (5.77E-005(kg-m**2)) & 
 units = "kg-meter**2" 
!
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.l_iyy &
 location = 302.0, 95.0 &
 height = 25.0 &
 width = 40.0 &
 units = pixel &
 text = "Iyy" &
 justified = right
!
interface field create &
 field_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_iyz &
 enabled = yes &
 units = pixel &
 location = 350.0, 122.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(0.0(kg-m**2))" &
 lower_check = ge &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_iyz.value &
 real_value = (0.0(kg-meter**2)) & 
 units = "kg-meter**2" 
!
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.l_iyz &
 location = 302.0, 122.0 &
 height = 25.0 &
 width = 40.0 &
 units = pixel &
 text = "Iyz" &
 justified = right
!
interface field create &
 field_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_izz &
 enabled = yes &
 units = pixel &
 location = 528.0, 122.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(3.02E-006(kg-m**2))" &
 lower_check = ge &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_izz.value &
 real_value = (3.02E-006(kg-m**2)) & 
 units = "kg-meter**2"
!
interface label create &
 label_name = .gui.tc_wizard.page_2.cont_rigid_mat.c_user.l_izz &
 location = 480.0, 122.0 &
 height = 25.0 &
 width = 40.0 &
 units = pixel &
 text = "Izz" &
 justified = right
!
return