!-------------------------------------------------------
! Creates labels, fields etc. for Radial Bearing Specs
!-------------------------------------------------------
!
!
! Containers -------------------------------------------
!
interface container create &
 container_name = .gui.tc_wizard.page_5.cont_bear_prop.c_ideal &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 4.0, 163.0 &
 height = 216.0 &
 width = 710.0 &
 position_of_sash = 0.5
!
interface container create &
 container_name = .gui.tc_wizard.page_5.cont_bear_prop.c_stiff &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 4.0, 163.0 &
 height = 216.0 &
 width = 710.0 &
 position_of_sash = 0.5
!
interface container create &
 container_name = .gui.tc_wizard.page_5.cont_bear_prop.c_ocvirk &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 4.0, 163.0 &
 height = 216.0 &
 width = 710.0 &
 position_of_sash = 0.5  
!
! ------------------------------------------------------
!
!
! Labels & Fields --------------------------------------
!
! page_5.tab_bear.cont_bear_prop
interface label create &
 label_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.l_met &
 location = 4.0, 140.0 &
 width = 120.0 &
 height = 25.0 &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 units = pixel &
 text = 'Method' &
 justified = right
! 
interface label create &
 label_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ideal.fig_ideal &
 location = 12.0, 15.0 &
 width = 100.0 &
 height = 100.0 &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &  
 units = pixel &
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\Ideal_cylindrical_joint.xpm' &
 justified = left
!
interface label create &
 label_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ideal.l_desc &
 location = 120.0, 15.0 &
 width = 510.0 &
 height = 100.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &  
 text = 'Bearing is modelled as Cylindrical Joint.' &
 justified = left 
! 
interface label create &
 label_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_stiff.fig_stiff &
 location = 300.0, 0.0 &
 width = 200.0 &
 height = 200.0 &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &  
 units = pixel &
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\stiff_bear.xpm' &
 justified = left
!
interface field create &
 field_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_stiff.l_stiff_1 &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 180.0, 120.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(1.1 (N/mm))" &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_stiff.l_stiff_1.value &
 real_value = (1.1 (N/mm)) & 
 units = "N/mm" 
!
interface field create &
 field_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_stiff.l_damp_1 &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 365.0, 120.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(1.2 (N-sec/mm))" &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_stiff.l_damp_1.value &
 real_value = (1.2 (N-sec/mm)) & 
 units = "N-sec/mm"  
!
interface field create &
 field_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_stiff.l_stiff_2 &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 390.0, 90.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(2.1 (N/mm))" &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_stiff.l_stiff_2.value &
 real_value = (2.1 (N/mm)) & 
 units = "N/mm"  
!
interface field create &
 field_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_stiff.l_damp_2 &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 390.0, 10.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(2.2 (N-sec/mm))" &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_stiff.l_damp_2.value &
 real_value = (2.2 (N-sec/mm)) & 
 units = "N-sec/mm"                                                                        
!
interface label create &
 label_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.fig_ground &
 location = 265.0, 8.0 &
 width = 250.0 &
 height = 120.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top & 
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\radial_bearing2.xpm' &                                                                                                                     
 justified = left 
!
interface label create &
 label_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.l_inner_bear &
 location = 166.0, 12.0 &
 width = 130.0 &
 height = 25.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &  
 text = 'Inner Bearing' &
 justified = center 
!
interface label create &
 label_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.l_radius_i &
 location = 8.0, 35.0 &
 width = 150.0 &
 height = 25.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &  
 text = 'Journal Radius' &
 justified = right 
!
interface field create &
 field_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.f_radius_i &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 166.0, 35.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(5.10275 mm)" &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.f_radius_i.value &
 real_value = (5.10275 mm) & 
 units = "mm"                                                                        
!
interface label create &
 label_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.l_width_i &
 location = 8.0, 62.0 &
 width = 150.0 &
 height = 25.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &  
 text = 'Bearing Width' &
 justified = right
!
interface field create &
 field_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.f_width_i &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 166.0, 62.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(5.0 mm)" &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.f_width_i.value &
 real_value = (5.0 mm) & 
 units = "mm"                                                                        
!
interface label create &
 label_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.l_clear_i &
 location = 8.0, 89.0 &
 width = 150.0 &
 height = 25.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &  
 text = 'Radial Clearance' &
 justified = right
!
interface field create &
 field_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.f_clear_i &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 166.0, 89.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(23.5 microm)" &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.f_clear_i.value &
 real_value = (23.5 microm) & 
 units = "microm"                                                                        
!
interface label create &
 label_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.l_outer_bear &
 location = 300.0, 12.0 &
 width = 130.0 &
 height = 25.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &  
 text = 'Outer Bearing' &
 justified = center 
!
interface field create &
 field_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.f_radius_o &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 300.0, 35.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(7.904 mm)" &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.f_radius_o.value &
 real_value = (7.904 mm) & 
 units = "mm"                                                                        
!
interface field create &
 field_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.f_width_o &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 300.0, 62.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(12.4 mm)" &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.f_width_o.value &
 real_value = (12.4 mm) & 
 units = "mm"                                                                        
!
interface field create &
 field_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.f_clear_o &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 300.0, 89.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(72.6 microm)" &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.f_clear_o.value &
 real_value = (72.6 microm) & 
 units = "microm"                                                                        
!
interface field create &
 field_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.f_ground &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 182.0, 100.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(0.05654 m)" &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.f_ground.value &
 real_value = (0.05654 m) & 
 units = "meter" 
!
interface label create &
 label_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.l_bear_ring &
 location = 500.0, 12.0 &
 width = 130.0 &
 height = 25.0 &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &  
 text = 'Bearing Ring' &
 justified = center 
!
interface toggle_button create &
 toggle_button_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.flag_rotating_ring &
 enabled = yes &
 location = 480.0, 35.0 &
 height = 25.0 &
 width = 488.0 &
 units = pixel &
 label = 'Rotating' &
 on_value = on &
 off_value = off &
 state = on &
 commands = &
 'variable set variable_name = $_self.value real_value = 0.0', &
 'if condition= ("$_value" == "on")', &
 '   variable set variable_name = $_self.value real_value = 1.0', &
 'end'
!
interface toggle_button execute &
 toggle_button_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.flag_rotating_ring
! 
! Default value
variable set variable_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.flag_rotating_ring.value &
 real_value = 1.0 &
 comments = '0.0 - Off, 1.0 - On' 
!
interface label create &
 label_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.l_mass &
 location = 360.0, 62.0 &
 height = 25.0 &
 width = 160.0 &
 units = pixel &
 text = 'Mass' &
 justified = right
!
interface field create &
 field_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.f_mass &
 enabled = yes &
 units = pixel &
 location = 540.0, 62.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(9.02 g)" &
 lower_check = ge &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.f_mass.value &
 real_value = (9.02 g) & 
 units = "g"
!
interface label create &
 label_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.l_ixx &
 location = 360.0, 89.0 &
 height = 25.0 &
 width = 160.0 &
 units = pixel &
 text = 'Ixx' &
 justified = right
! 
interface field create &
 field_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.f_ixx &
 enabled = yes &
 units = pixel &
 location = 540.0, 89.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(3.29E-005(kg-m**2))" &
 lower_check = ge &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.f_ixx.value &
 real_value = (3.29E-005(kg-m**2)) & 
 units = "kg-meter**2"
!
interface label create &
 label_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.l_iyy &
 location = 360.0, 116.0 &
 height = 25.0 &
 width = 160.0 &
 units = pixel &
 text = 'Iyy' &
 justified = right
! 
interface field create &
 field_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.f_iyy &
 enabled = yes &
 units = pixel &
 location = 540.0, 116.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(3.29E-005(kg-m**2))" &
 lower_check = ge &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.f_iyy.value &
 real_value = (3.29E-005(kg-m**2)) & 
 units = "kg-meter**2"
!
interface label create &
 label_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.l_izz &
 location = 360.0, 143.0 &
 height = 25.0 &
 width = 160.0 &
 units = pixel &
 text = 'Izz' &
 justified = right
! 
interface field create &
 field_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.f_izz &
 enabled = yes &
 units = pixel &
 location = 540.0, 143.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 numeric_type = Real &
 preload_strings = "(4.27E-005(kg-m**2))" &
 lower_check = ge &
 lower_limit = 0.0 &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value real_value = (eval($_value))'
!
! Default value
variable set variable_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.f_izz.value &
 real_value = (4.27E-005(kg-m**2)) & 
 units = "kg-meter**2"
!
 interface push_button create push_button_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.c_ocvirk.push_oil_props &
 units = pixel &
 location = 166.0, 143.0 &
 width = 76.0 &
 height = 25.0 &
 icon_file = 'C:\MSC.Software\TC_wizzard\My_figures\oil_props.xpm' &
 help_text = 'Oil Specification' &
 commands = &
 'interface dialog display dialog = .gui.oil_properties'
!
interface label create &
 label_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.l_shaft_part &
 location = 4.0, 20.0 &
 width = 120.0 &
 height = 25.0 &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 units = pixel &
 text = 'Shaft Marker' &
 justified = right
!
interface field create &
 field_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.f_shaft_part &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 132.0, 20.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 preload_strings = 'Pick Marker' & 
 object_type = old &
 type_filter = Marker &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value_real real_value = ($_value.adams_ID)', &        
 'variable set variable_name = $_self.value_str string_value = ($_value)'
 !
! Default value
variable set variable_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.f_shaft_part.value_real &
 real_value = -1.0  
variable set variable_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.f_shaft_part.value_str &
 string_value = "Not specified" 
!
interface label create &
 label_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.l_hsg_part &
 location = 4.0, 60.0 &
 width = 120.0 &
 height = 25.0 &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 units = pixel &
 text = 'Housing Marker' &
 justified = right
!
interface field create &
 field_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.f_hsg_part &
 enabled = yes &
 units = pixel &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 location = 132.0, 60.0 &
 height = 25.0 &
 width = 130.0 &
 scrollable = no &
 required = yes &
 preload_strings = 'Pick Marker' & 
 object_type = old &
 type_filter = Marker &
 execute_cmds_on_exit = yes &
 commands = &
 'variable set variable_name = $_self.value_real real_value = ($_value.adams_ID)', &         ! integer tu nefunguje
 'variable set variable_name = $_self.value_str string_value = ($_value)'
 !
! Default value
variable set variable_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.f_hsg_part.value_real &
 real_value = -1.0  
variable set variable_name = .gui.tc_wizard.page_5.tab_bear.cont_bear_prop.f_hsg_part.value_str &
 string_value = "Not specified" 
!
! ------------------------------------------------------
!
!
! Option Menus -----------------------------------------
!
interface option_menu create &
 option_menu_name = .gui.tc_wizard.page_5.cont_bear_prop.o_method &
 units = pixel &
 location = 132.0, 140.0 &
 width = 150.0 &
 height = 25.0 &
 horiz_resizing = attach_left &
 vert_resizing = attach_top &
 choices = 'Ideal Joint', 'Stiffness & Damping', 'Ocvirk' & 
 values = joint, stiffness, ocvirk &
 commands = &
 'interface container undisplay container = $_parent.c_ideal', &
 'interface container undisplay container = $_parent.c_stiff', &
 'interface container undisplay container = $_parent.c_ocvirk', &
 'if condition=("$o_method" == "stiffness" )', &
 '   interface container display container = $_parent.c_stiff', &
 '   interface wizard page modify wizard_page_name = $_topgui.page_5 enable_next = yes', &
 '   variable set variable_name = $_self.value real_value = 2.0', &
 'elseif condition = ("$o_method" == "ocvirk" )', &  
 '   interface container display container = $_parent.c_ocvirk', &
 '   interface wizard page modify wizard_page_name = $_topgui.page_5 enable_next = yes', &
 '   variable set variable_name = $_self.value real_value = 3.0', &
 'else', & 
 '   interface container display container = $_parent.c_ideal', &
 '   interface wizard page modify wizard_page_name = $_topgui.page_5 enable_next = yes', &
 '   variable set variable_name = $_self.value real_value = 1.0', &  
 'end'
!
interface option_menu execute &
 option_menu_name = .gui.tc_wizard.page_5.cont_bear_prop.o_method
!
! Default value
variable set variable_name = .gui.tc_wizard.page_5.cont_bear_prop.o_method.value real_value = 1.0 &
 comments = '1.0 - Ideal Joint, 2.0 - Stiffness & Damping, 3.0 - Ocvirk Solution'
!
!
return