!-------------------------------------------------------
!----------------- Turbine Wheel Build -----------------
! Data stored in array called ".turb_wheel_properties"
!-------------------------------------------------------
!
if condition = ((eval(.MODEL_1.turb_wheel_properties.values[1])) == 1.0)        ! Mass Method: User Input
   !
   part create rigid_body name_and_position part_name = (eval(model_name//".turb_wheel")) 
   !
   var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("second")/(60*UNITS_CONVERSION_FACTOR("revolutions"))))
   !
   part create rigid_body initial_velocity  &
    part_name = (eval(model_name//".turb_wheel"))  &
    wz = (evaL(-1.0*.MODEL_1.test_rig_properties.values[2]*.MODEL_1.test_rig_properties.values[28]*tmp)) &
    wm = (eval(model_name//".ground.LBRF"))    
   !
   var del var = tmp
   !
   part attributes part_name = (eval(model_name//".turb_wheel")) color = RED name_vis = off
   !
   marker create marker = (eval(model_name//".turb_wheel.marker_tw_shaft")) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_tw")))) &
    orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_tw"))))
   ! 
   entity attributes &
    entity_name = (eval(model_name//".turb_wheel.marker_tw_shaft")) &
    visibility = off &
    name_visibility = off 
   ! 
   marker create marker = (eval(model_name//".turb_wheel.marker_cm")) &
    location=(LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.turb_wheel_cm")))) &
    orientation=(ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.turb_wheel_cm"))))  
   !
   entity attributes &
    entity_name = (eval(model_name//".turb_wheel.marker_cm")) &
    visibility = off &
    name_visibility = off
   !  
   file stereo read  &
    file_name = "C:\MSC.Software\TC_wizzard\models\turb_wheel_model.stl"  &
    part_name = (eval(model_name//".turb_wheel")) &
    scale = (eval(.MODEL_1.turb_wheel_properties.values[17]/100.0)) &
    location=(LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_tw")))) &
    orientation=(ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_tw")))) !&
   ! 
!   geometry modify shape shell &
!    shell_name = (eval(model_name//".turb_wheel.default_pshell_property")) &
!    reference_marker = (eval(model_name//".turb_wheel.marker_tw_shaft"))     
   !
!   entity attributes &
!    entity_name     = (eval(model_name//".turb_wheel.default_pshell_property")) &
!    type_filter     = Shell &
!    color           = .colors.RED
   !
   part modify rigid_body mass_properties part_name=(eval(model_name//".turb_wheel")) &
    mass = (.MODEL_1.turb_wheel_properties.values[2]) & 
    center_of_mass_marker = (eval(model_name//".turb_wheel.marker_cm")) &
    inertia_marker = (eval(model_name//".turb_wheel.marker_cm")) &
    ixx = (.MODEL_1.turb_wheel_properties.values[4]) & 
    iyy = (.MODEL_1.turb_wheel_properties.values[5]) & 
    izz = (.MODEL_1.turb_wheel_properties.values[6]) 
   !
   if condition = ((eval(.MODEL_1.turb_wheel_properties.values[11])) == 1.0)    ! Off Diagonal Terms
      part modify rigid_body mass_properties part_name=(eval(model_name//".turb_wheel")) &
       ixy = (.MODEL_1.turb_wheel_properties.values[7]) & 
       iyz = (.MODEL_1.turb_wheel_properties.values[8]) &
       izx = (.MODEL_1.turb_wheel_properties.values[9])  
   end
   
   
   !
elseif condition = ((eval(.MODEL_1.turb_wheel_properties.values[1])) == 2.0)    ! Mass Method: Geometry and Density   
   ! N/A yet
elseif condition = ((eval(.MODEL_1.turb_wheel_properties.values[1])) == 3.0)    ! Mass Method: Geometry and Material Type     
   ! N/A yet
end
!
! Nose Unbalance
!
part create point_mass name_and_position  &
   point_mass_name = (eval(model_name//".UN_TW_nose"))  &
   location = (LOC_RELATIVE_TO({0.0, 0.0,0}, (eval(model_name//".ground.unbalance_TW_nose")))) &
   orientation = (ORI_RELATIVE_TO({0.0d, 0.0d, 0.0d}, (eval(model_name//".ground.unbalance_TW_nose"))))
!
marker create  &
   marker_name = (eval(model_name//".UN_TW_nose.cm")) &
   location = (LOC_RELATIVE_TO({0.0, 0.0,0}, (eval(model_name//".ground.unbalance_TW_nose")))) &
   orientation = (ORI_RELATIVE_TO({0.0d, 0.0d, 0.0d}, (eval(model_name//".ground.unbalance_TW_nose"))))
!
entity attributes entity_name = (eval(model_name//".UN_TW_nose.cm")) visibility = off
!
part create point_mass mass_properties  &
   point_mass_name = (eval(model_name//".UN_TW_nose"))  &
   mass = (.MODEL_1.turb_wheel_properties.values[13])  &
   center_of_mass_marker = (eval(model_name//".UN_TW_nose.cm"))
!
entity attributes &
 entity_name = (eval(model_name//".UN_TW_nose")) &
 size = 1
!
! Backplate Unbalance
!
part create point_mass name_and_position  &
   point_mass_name = (eval(model_name//".UN_TW_back"))  &
   location = (LOC_RELATIVE_TO({0.0, 0.0,0}, (eval(model_name//".ground.unbalance_TW_back")))) &
   orientation = (ORI_RELATIVE_TO({0.0d, 0.0d, 0.0d}, (eval(model_name//".ground.unbalance_TW_back"))))
!
marker create  &
   marker_name = (eval(model_name//".UN_TW_back.cm")) &
   location = (LOC_RELATIVE_TO({0.0, 0.0,0}, (eval(model_name//".ground.unbalance_TW_back")))) &
   orientation = (ORI_RELATIVE_TO({0.0d, 0.0d, 0.0d}, (eval(model_name//".ground.unbalance_TW_back"))))
!   
entity attributes entity_name = (eval(model_name//".UN_TW_back.cm")) visibility = off
!
part create point_mass mass_properties  &
   point_mass_name = (eval(model_name//".UN_TW_back"))  &
   mass = (.MODEL_1.turb_wheel_properties.values[15])  &
   center_of_mass_marker = (eval(model_name//".UN_TW_back.cm"))
!
entity attributes &
 entity_name = (eval(model_name//".UN_TW_back")) &
 size = 1
!
!-------------------------------------------------------
return