!-------------------------------------------------------
!-------- Analytical Solution of Thrust Bearing --------
!-------------------------------------------------------
!
var set var = scale_meter real = (UNITS_CONVERSION_FACTOR('meter'))
var set var = scale_second real = (UNITS_CONVERSION_FACTOR('second')) 
!
! Asymptotic Eccentricity Parameters
var set var = hstart_axi real = 0.90
var set var = hend_axi real = 0.95
!
!-------------------------------------------------------
! Oil Properties
!-------------------------------------------------------
!  
! VISKOSITA OLEJE -> (VOGEL coef. a,b,c)
!
if condition = ((eval(DB_EXISTS("vis_hths"))) == 0.0)
   !
   var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("newton")*UNITS_CONVERSION_FACTOR("second")/UNITS_CONVERSION_FACTOR("meter")**2))
   !
   variable set  &                                                                 
    variable_name = vis_hths  &                                                    ! [Pa.s]
    units = "no_units"  &
    real_value = (eval(tmp*(eval(STOO(model_name//".axi_bear_properties")).values[26,(eval(id))]))) &
    comments = "Pa.s" 
   !
end
!
if condition = ((eval(DB_EXISTS("voga"))) == 0.0)
   !
   var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("newton")*UNITS_CONVERSION_FACTOR("second")/UNITS_CONVERSION_FACTOR("meter")**2))
   !
   variable set  &                                                                 
    variable_name = voga  &                                                        ! [Pa.s]
    units = "no_units"  &
    real_value = (eval(tmp*(eval(STOO(model_name//".axi_bear_properties")).values[21,(eval(id))]))) &
    comments = "Pa.s"
   !
end
!
if condition = ((eval(DB_EXISTS("vogb"))) == 0.0)
   !
   variable set  &                                                                 
    variable_name = vogb  &                                                        ! [degC]
    units = "no_units"  &
    real_value = (eval(eval(STOO(model_name//".axi_bear_properties")).values[22,(eval(id))])) &
    comments = "degC"
   !
end
!
if condition = ((eval(DB_EXISTS("vogc"))) == 0.0)
   !
   variable set  &                                                                 
    variable_name = vogc  &                                                        ! [degC]
    units = "no_units"  &
    real_value = (eval(eval(STOO(model_name//".axi_bear_properties")).values[23,(eval(id))])) &
    comments = "degC" 
   !
end
!
! MERNA TEPELNA KAPACITA  
!
if condition = ((eval(DB_EXISTS("cap"))) == 0.0)
   !
   variable set  &
    variable_name = cap  &                                                         ! [J/(kg*K)] 
    units = "no_units"  &
    real_value = (eval(eval(STOO(model_name//".axi_bear_properties")).values[25,(eval(id))])) &
    comments = "J/(kg*K)"
   !
end
!
! VSTUPNI TEPLOTA 
! 
if condition = ((eval(DB_EXISTS("T0"))) == 0.0)
   !
   variable set  &
    variable_name = T0  &                                                          ! [C]
    units = "no_units"  &
    real_value = (eval(eval(STOO(model_name//".axi_bear_properties")).values[24,(eval(id))])) & 
    comments = "degC"
   ! 
end
!
! Korekce shear velocity on viscositu
!
if condition = ((eval(DB_EXISTS("shvelcor"))) == 0.0)
   !
   variable set  &
    variable_name = shvelcor  &                                                    ! [-]
    units = "no_units"  &
    real_value = (eval((vis_hths/voga)*EXP(vogb/(vogc-150.0))))
   !
end
!
for variable_name = j start_value = 1 end_value = (eval(.MODEL_1.axi_bear_properties.values[11,(eval(id))]))
   !
   ! VISKOSITA OLEJE - ZALOZENI PROMENNE
   !
   data_element create variable  &
    variable_name = (eval("vis_axi_"//RTOI(i)//"_pad_"//RTOI(j)))  &                       ! [Pa.s]
    function = "" &
    comments = "Pa.s"
   !
   ! OTEPLENI OLEJE V LOZISKU - ZALOZENI PROMENNE
   !
   data_element create variable  &
    variable_name = (eval("dT_axi_"//RTOI(id)//"_pad_"//RTOI(j)))  &                        ! [degC]
    function = "" &
    initial_condition = 0.0 &
    comments = "degC"
   !
   ! TEPLOTA OLEJA
   !
   data_element create variable &
    variable_name = (eval("T_axi_"//RTOI(id)//"_pad_"//RTOI(j)))  &                       ! [degC]
    function = (eval("T0 + VARVAL(dT_axi_"//RTOI(id)//"_pad_"//RTOI(j)//")")) &
    initial_condition = (T0)  
   ! 
   ! VISKOSITA OLEJE
   !
   data_element modify variable  &
    variable_name = (eval("vis_axi_"//RTOI(id)//"_pad_"//RTOI(j)))  &                       ! [Pa.s]
    function = (eval("shvelcor*voga*EXP(vogb/(VARVAL(T_axi_"//RTOI(id)//"_pad_"//RTOI(j)//") - vogc))")) &
    comments = "Pa.s"
   !  
end    
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Geometrical Dimensions
!-------------------------------------------------------
!
var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("meter")))
!   
! MALA MEDZERA LOZISKA
!
variable create  &
 variable_name = (eval("axi_h0_"//RTOI(id))) &                                  ! [meter]
 units = "no_units"  &
 real_value = (eval(scale_meter*(eval(STOO(model_name//".axi_bear_properties")).values[15,(eval(id))]))) &
 comments = "meter"
!
! VELKE MEDZERA LOZISKA
!
variable create  &
 variable_name = (eval("axi_h1_"//RTOI(id))) &                                  ! [meter]
 units = "no_units"  &
 real_value = (eval(scale_meter*(eval(STOO(model_name//".axi_bear_properties")).values[16,(eval(id))]))) &
 comments = "meter"
!
! STREDNY RADIUS LOZISKA
!
variable create  &
 variable_name = (eval("axi_rad_m_"//RTOI(id))) &                               ! [meter]
 units = "no_units"  &
 real_value = (eval(scale_meter*0.25*((.MODEL_1.axi_bear_properties.values[12,(eval(id))]) + (.MODEL_1.axi_bear_properties.values[13,(eval(id))])))) &
 comments = "meter"
!       
! PAD WIDTH
!
variable create  &
 variable_name = (eval("axi_pad_width_"//RTOI(id))) &                           ! [meter]
 units = "no_units"  &
 real_value = (eval(scale_meter*0.5*((.MODEL_1.axi_bear_properties.values[12,(eval(id))]) - (.MODEL_1.axi_bear_properties.values[13,(eval(id))])))) &
 comments = "meter"
!   
! PAD LENGTH
!
variable create  &
 variable_name = (eval("axi_pad_length_"//RTOI(id))) &                          ! [meter]
 units = "no_units"  &
 real_value = (eval(scale_meter*(.MODEL_1.axi_bear_properties.values[14,(eval(id))]))) &
 comments = "meter"
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Kinematic Variables
!-------------------------------------------------------
!
for variable_name = j start_value = 1 end_value = (eval(.MODEL_1.axi_bear_properties.values[11,(eval(id))]))
   !
   ! EXCENTRICITA
   !    
   data_element create variable  &                                              ! [meter]
    variable_name = (eval("ecc_axi_"//RTOI(id)//"_pad_"//RTOI(j)))  &
    function = (eval("scale_meter*DZ("//model_name//".thrust_bearing_"//RTOI(id)//".marker_gforce_"//RTOI(j)//", "//model_name//".dummy_shaft_axi_"//RTOI(id)//".marker_axi_bear_"//RTOI(id)//"_Z, "//model_name//".dummy_shaft_axi_"//RTOI(id)//".marker_axi_bear_"//RTOI(id)//"_Z)")) &
    comments = "meter"
   !
   ! EXCENTRICITA ASYMPTOTICKA
   !
   data_element create variable  &
    variable_name = (eval("asy_z_axi_"//RTOI(id)//"_pad_"//RTOI(j)))  &
    function = (eval("(ABS(VARVAL(ecc_axi_"//RTOI(id)//"_pad_"//RTOI(j)//")) / axi_h0_"//RTOI(id)//" - hstart_axi)/(hstart_axi-hend_axi)")) 
   !
   data_element create variable  &
    variable_name = (eval("asy_w_axi_"//RTOI(id)//"_pad_"//RTOI(j)))  &
    function = (eval("1.0/(1.0 - VARVAL(asy_z_axi_"//RTOI(id)//"_pad_"//RTOI(j)//") + VARVAL(asy_z_axi_"//RTOI(id)//"_pad_"//RTOI(j)//")**2)"))
   !   
   data_element create variable  &                                              ! [meter], + medzera sa zvecsuje, - medzera sa zmensuje
    variable_name = (eval("ecc_asy_axi_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW"))  &
    function = (eval("IF(VARVAL(ecc_axi_"//RTOI(id)//"_pad_"//RTOI(j)//") - hstart_axi*axi_h0_"//RTOI(id)//": -1.0*(VARVAL(ecc_axi_"//RTOI(id)//"_pad_"//RTOI(j)//")), -1.0*(hstart_axi*axi_h0_"//RTOI(id)//"), -1.0*(hend_axi*axi_h0_"//RTOI(id)//" + axi_h0_"//RTOI(id)//"*(hstart_axi - hend_axi)*VARVAL(asy_w_axi_"//RTOI(id)//"_pad_"//RTOI(j)//")))"))
   !
   data_element create variable  &                                              ! [meter], + medzera sa zvecsuje, - medzera sa zmensuje
    variable_name = (eval("ecc_asy_axi_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW"))  &
    function = (eval("IF(-1.0*VARVAL(ecc_axi_"//RTOI(id)//"_pad_"//RTOI(j)//") - hstart_axi*axi_h0_"//RTOI(id)//": (VARVAL(ecc_axi_"//RTOI(id)//"_pad_"//RTOI(j)//")), -1.0*(hstart_axi*axi_h0_"//RTOI(id)//"), -1.0*(hend_axi*axi_h0_"//RTOI(id)//" + axi_h0_"//RTOI(id)//"*(hstart_axi - hend_axi)*VARVAL(asy_w_axi_"//RTOI(id)//"_pad_"//RTOI(j)//")))"))
   !
   ! RYCHLOST
   !
   data_element create variable  &                                              ! [meter/second]
    variable_name = (eval("vel_axi_"//RTOI(id)//"_pad_"//RTOI(j)))  &
    function = (eval("(scale_meter/scale_second)*VZ("//model_name//".thrust_bearing_"//RTOI(id)//".marker_gforce_"//RTOI(j)//", "//model_name//".dummy_shaft_axi_"//RTOI(id)//".marker_axi_bear_"//RTOI(id)//"_Z, "//model_name//".dummy_shaft_axi_"//RTOI(id)//".marker_axi_bear_"//RTOI(id)//"_Z)"))
   !
   data_element create variable  &
    variable_name = (eval("scale_vel_axi_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW"))  &
    function = (eval("IF(VARVAL(ecc_axi_"//RTOI(id)//"_pad_"//RTOI(j)//") - hstart_axi*axi_h0_"//RTOI(id)//": 1.0, 1.0, ((1.0 - 2.0*VARVAL(asy_z_axi_"//RTOI(id)//"_pad_"//RTOI(j)//"))*VARVAL(asy_w_axi_"//RTOI(id)//"_pad_"//RTOI(j)//")**2))"))
   !
   data_element create variable  &
    variable_name = (eval("scale_vel_axi_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW"))  &
    function = (eval("IF(-1.0*VARVAL(ecc_axi_"//RTOI(id)//"_pad_"//RTOI(j)//") - hstart_axi*axi_h0_"//RTOI(id)//": 1.0, 1.0, ((1.0 - 2.0*VARVAL(asy_z_axi_"//RTOI(id)//"_pad_"//RTOI(j)//"))*VARVAL(asy_w_axi_"//RTOI(id)//"_pad_"//RTOI(j)//")**2))"))
   !
   data_element create variable  &                                              ! [meter/second], + medzera sa zvecsuje, - medzera sa zmensuje
    variable_name = (eval("vel_asy_axi_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW"))  &
    function = (eval("-1.0*VARVAL(scale_vel_axi_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW) * VARVAL(vel_axi_"//RTOI(id)//"_pad_"//RTOI(j)//")"))
   !
   data_element create variable  &                                              ! [meter/second], + medzera sa zvecsuje, - medzera sa zmensuje
    variable_name = (eval("vel_asy_axi_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW"))  &
    function = (eval("1.0*VARVAL(scale_vel_axi_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW) * VARVAL(vel_axi_"//RTOI(id)//"_pad_"//RTOI(j)//")"))
   !
   
   
   
   
   
   ! CONVERGENCE RATIO
   !
   data_element create variable &                                                           ! [-]
    variable_name = (eval("axi_K_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW")) &                         
    function = (eval("(axi_h1_"//RTOI(i)//" - axi_h0_"//RTOI(i)//") / (axi_h0_"//RTOI(i)//" + VARVAL(ecc_asy_axi_"//RTOI(i)//"_pad_"//RTOI(j)//"_CW))"))
   !
   data_element create variable &                                                           ! [-]
    variable_name = (eval("axi_K_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW")) &                         
    function = (eval("(axi_h1_"//RTOI(i)//" - axi_h0_"//RTOI(i)//") / (axi_h0_"//RTOI(i)//" + VARVAL(ecc_asy_axi_"//RTOI(i)//"_pad_"//RTOI(j)//"_TW))"))
   !
   data_element create variable &
    variable_name = (eval("axi_K_conw_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW")) &                         
    function = (eval("(-1.0*LOG(VARVAL(axi_K_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW) + 1.0) + 2.0*VARVAL(axi_K_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW) / (VARVAL(axi_K_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW) + 2.0))/(VARVAL(axi_K_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW)**2)"))
   !
   data_element create variable &
    variable_name = (eval("axi_K_conw_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW")) &                         
    function = (eval("(-1.0*LOG(VARVAL(axi_K_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW) + 1.0) + 2.0*VARVAL(axi_K_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW) / (VARVAL(axi_K_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW) + 2.0))/(VARVAL(axi_K_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW)**2)"))
   !
   data_element create variable &
    variable_name = (eval("axi_K_conf_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW")) &                         
    function = (eval("6.0/(VARVAL(axi_K_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW) + 2.0) + 4.0*LOG(VARVAL(axi_K_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW) + 1.0)/VARVAL(axi_K_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW)"))
   !
   data_element create variable &
    variable_name = (eval("axi_K_conf_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW")) &                         
    function = (eval("6.0/(VARVAL(axi_K_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW) + 2.0) + 4.0*LOG(VARVAL(axi_K_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW) + 1.0)/VARVAL(axi_K_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW)"))
   !   
end
!
! VELOCITY
!
data_element create variable &                                                  ! [meter/s]
 variable_name = (eval("axi_U_"//RTOI(id))) &        
 function = (eval("axi_rad_m_"//RTOI(id)//" * VARVAL(omega_axi_"//RTOI(id)//") / scale_second"))
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! FORCES
!-------------------------------------------------------
!
for variable_name = j start_value = 1 end_value = (eval(.MODEL_1.axi_bear_properties.values[11,(eval(id))]))
   !
   ! LOAD FORCE
   !
   data_element create variable &                                                           ! [N]
    variable_name = (eval("axi_force_normal_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW")) &                         
    ! bez tlmenia
    !function = (eval("VARVAL(axi_K_conw_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW) * axi_pad_width_"//RTOI(id)//" * 6.0 * VARVAL(axi_U_"//RTOI(id)//") * VARVAL(vis_axi_"//RTOI(id)//"_pad_"//RTOI(j)//") * axi_pad_length_"//RTOI(id)//"**2 / ((axi_h0_"//RTOI(i)//" + VARVAL(ecc_asy_axi_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW))**2)"))
    ! s tlmenim
    function = (eval("VARVAL(axi_K_conw_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW) * axi_pad_width_"//RTOI(id)//" * (6.0 * VARVAL(axi_U_"//RTOI(id)//") + 12.0 * VARVAL(vel_asy_axi_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW) * axi_pad_length_"//RTOI(id)//" / (axi_K_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW * (axi_h0_"//RTOI(i)//" + VARVAL(ecc_asy_axi_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW)))) * VARVAL(vis_axi_"//RTOI(id)//"_pad_"//RTOI(j)//") * axi_pad_length_"//RTOI(id)//"**2 / ((axi_h0_"//RTOI(i)//" + VARVAL(ecc_asy_axi_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW))**2)"))
   !
   data_element create variable &                                                           ! [N]
    variable_name = (eval("axi_force_normal_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW")) &                         
    ! bez tlmenia
    !function = (eval("VARVAL(axi_K_conw_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW) * axi_pad_width_"//RTOI(id)//" * 6.0 * VARVAL(axi_U_"//RTOI(id)//") * VARVAL(vis_axi_"//RTOI(id)//"_pad_"//RTOI(j)//") * axi_pad_length_"//RTOI(id)//"**2 / ((axi_h0_"//RTOI(i)//" + VARVAL(ecc_asy_axi_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW))**2)"))
    ! s tlmenim
    function = (eval("VARVAL(axi_K_conw_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW) * axi_pad_width_"//RTOI(id)//" * (6.0 * VARVAL(axi_U_"//RTOI(id)//") + 12.0 * VARVAL(vel_asy_axi_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW) * axi_pad_length_"//RTOI(id)//" / (axi_K_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW * (axi_h0_"//RTOI(i)//" + VARVAL(ecc_asy_axi_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW)))) * VARVAL(vis_axi_"//RTOI(id)//"_pad_"//RTOI(j)//") * axi_pad_length_"//RTOI(id)//"**2 / ((axi_h0_"//RTOI(i)//" + VARVAL(ecc_asy_axi_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW))**2)"))
   !
   data_element create variable &                                               ! [N], + otvara CW gap, - otvara TW gap 
    variable_name = (eval("axi_force_normal_"//RTOI(id)//"_pad_"//RTOI(j))) &                         
    function = (eval("ABS(VARVAL(axi_force_normal_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW)) - ABS(VARVAL(axi_force_normal_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW))")) 
   !
   ! FRICTION FORCE
   !
   data_element create variable &                                                           ! [N]
    variable_name = (eval("axi_force_tang_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW")) &                         
    function = (eval("VARVAL(axi_K_conf_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW) * axi_pad_width_"//RTOI(id)//" * VARVAL(axi_U_"//RTOI(id)//") * VARVAL(vis_axi_"//RTOI(id)//"_pad_"//RTOI(j)//") * axi_pad_length_"//RTOI(id)//" / (axi_h0_"//RTOI(i)//" + VARVAL(ecc_asy_axi_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW))")) 
   !
   data_element create variable &                                                           ! [N]
    variable_name = (eval("axi_force_tang_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW")) &                         
    function = (eval("VARVAL(axi_K_conf_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW) * axi_pad_width_"//RTOI(id)//" * VARVAL(axi_U_"//RTOI(id)//") * VARVAL(vis_axi_"//RTOI(id)//"_pad_"//RTOI(j)//") * axi_pad_length_"//RTOI(id)//" / (axi_h0_"//RTOI(i)//" + VARVAL(ecc_asy_axi_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW))")) 
   !
   data_element create variable &                                               ! [N] 
    variable_name = (eval("axi_force_tang_"//RTOI(id)//"_pad_"//RTOI(j))) &                         
    function = (eval("VARVAL(axi_force_tang_"//RTOI(id)//"_pad_"//RTOI(j)//"_CW) + VARVAL(axi_force_tang_"//RTOI(id)//"_pad_"//RTOI(j)//"_TW)")) 
   !
end   





return














! CONVERGENCE RATIO
!
variable create  &
 variable_name = (eval("axi_K_"//RTOI(id))) &                                    ! [-]
 units = "no_units"  &
 real_value = (eval((STOO("axi_h1_"//RTOI(i)) - (eval(STOO("axi_h0_"//RTOI(i))))) / (eval(STOO("axi_h0_"//RTOI(i))))))
!









   

! 

! 
!
! HUSTOTA OLEJE ro_0
!
var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("kilogram")/UNITS_CONVERSION_FACTOR("meter")**3))
variable set  &                                                                 
 variable_name = ro_0  &                                                          ! [kg/meter**3]
 units = "no_units"  &
 real_value = (eval(tmp*(eval(STOO(model_name//".rad_bear_properties")).values[34,(eval(pair_id))]))) &
 comments = "kg/meter**3"  
!
! TEPLOTA S HUSTOUTOU ro_0
!
variable set  &
 variable_name = T_ro_0  &                                                      ! [C]
 units = "no_units"  &
 real_value = (eval(eval(STOO(model_name//".rad_bear_properties")).values[35,(eval(pair_id))])) & 
 comments = "degC"
!
! MERNA TEPELNA ROZTAZNOST OLEJA
!
variable set &
 variable_name = alpha_ro &                                                     ! [-]
 units = "no_units"  &
 real_value = (eval(eval(STOO(model_name//".rad_bear_properties")).values[36,(eval(pair_id))])) 
 

!


!

!

!

!

!
! OBJEMOVY TOK - ZALOZENIE PREMENNEJ
var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("meter")**3/UNITS_CONVERSION_FACTOR("second")))
data_element create variable  &
 variable_name = (eval("oil_vol_flow_rad_"//bear_name//"_rad_"//RTOI(pair_id)))  &                        ! [m3/s]
 function = (eval(tmp*(eval(STOO(model_name//".rad_bear_properties")).values[37,(eval(pair_id))])))
!
               
!
! HUSTOTA OLEJA - ZALOZENI PREMENNEJ
data_element create variable &
 variable_name = (eval("dens_rad_"//bear_name//"_rad_"//RTOI(pair_id)))  &                       ! [kg/m3]
 function = (eval("ro_0/(1+alpha_ro*(VARVAL(T_rad_"//bear_name//"_rad_"//RTOI(pair_id)//") - T_ro_0))"))
!
! HMOTNOSTNY TOK
!
data_element create variable  &
 variable_name = (eval("oil_mass_flow_rad_"//bear_name//"_rad_"//RTOI(pair_id)))  &                        ! [kg/s]
 function = (eval("VARVAL(oil_vol_flow_rad_"//bear_name//"_rad_"//RTOI(pair_id)//")*VARVAL(dens_rad_"//bear_name//"_rad_"//RTOI(pair_id)//")"))
!




! HUSTOTA OLEJA
data_element modify variable &
 variable_name = (eval("dens_rad_"//bear_name//"_rad_"//RTOI(pair_id)))  &                       ! [kg/m3]
 function = (eval("ro_0/(1+alpha_ro*(VARVAL(T_rad_"//bear_name//"_rad_"//RTOI(pair_id)//") - T_ro_0))"))  &
 comments = "kg/m3"
!




!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Geometrical Dimensions
!-------------------------------------------------------
!
var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("meter")))
!   
if condition = ((eval(.MODEL_1.id)) <= 6.0)                                     ! Inner Bearing 
   !
   ! VOLA LOZISKA
   !
   variable create  &
    variable_name = (eval("cl_"//bear_name//"_rad_"//RTOI(pair_id))) &          ! [meter]
    units = "no_units"  &
    real_value = (eval(tmp*(eval(STOO(model_name//".rad_bear_properties")).values[22,(eval(pair_id))]))) &
    comments = "meter"
   !
   ! RADIUS LOZISKA
   !
   variable create  &
    variable_name = (eval("R_"//bear_name//"_rad_"//RTOI(pair_id))) &           ! [meter]
    units = "no_units"  &
    real_value = (eval(tmp*(eval(STOO(model_name//".rad_bear_properties")).values[20,(eval(pair_id))]))) &
    comments = "meter"
   !
   ! DLZKA LOZISKA
   !
   variable create  &
    variable_name = (eval("L_"//bear_name//"_rad_"//RTOI(pair_id))) &           ! [meter]
    units = "no_units"  &                                                       
    real_value = (eval(tmp*(eval(STOO(model_name//".rad_bear_properties")).values[21,(eval(pair_id))]))) &
    comments = "meter"
   !
else                                                                            ! Outer Bearing
   !
   ! VOLA LOZISKA
   !
   variable create  &
    variable_name = (eval("cl_"//bear_name//"_rad_"//RTOI(pair_id))) &          ! [meter]
    units = "no_units"  &
    real_value = (eval(tmp*(eval(STOO(model_name//".rad_bear_properties")).values[25,(eval(pair_id))]))) &
    comments = "meter"
   !
   ! RADIUS LOZISKA
   !
   variable create  &                                                              
    variable_name = (eval("R_"//bear_name//"_rad_"//RTOI(pair_id))) &           ! [meter]
    units = "no_units"  &
    real_value = (eval(tmp*(eval(STOO(model_name//".rad_bear_properties")).values[23,(eval(pair_id))]))) &
    comments = "meter"
   !
   ! DLZKA LOZISKA
   !
   variable create  &
    variable_name = (eval("L_"//bear_name//"_rad_"//RTOI(pair_id))) &           ! [meter]
    units = "no_units"  &
    real_value = (eval(tmp*(eval(STOO(model_name//".rad_bear_properties")).values[24,(eval(pair_id))]))) &
    comments = "meter"
   !
end
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Kinematic Variables
!-------------------------------------------------------
!
if condition = ((eval(.MODEL_1.id)) <= 6.0)                                     ! Inner Bearing 
   !
   var set var = i_mrk int = (eval(eval(STOO(model_name//".rad_bear_properties")).values[9,(eval(pair_id))]))
   var set var = j_mrk int = (eval(eval(STOO(model_name//".rad_bear_properties")).values[11,(eval(pair_id))])) 
   !
else                                                                            ! Outer Bearing
   !
   var set var = i_mrk int = (eval(eval(STOO(model_name//".rad_bear_properties")).values[11,(eval(pair_id))]))
   var set var = j_mrk int = (eval(eval(STOO(model_name//".rad_bear_properties")).values[10,(eval(pair_id))])) 
   !
end
!
! EXCENTRICITA
!
data_element create variable  &
 variable_name = (eval("disx_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("DX("//i_mrk//", "//j_mrk//", "//j_mrk//")"))
!
data_element create variable  &
 variable_name = (eval("disy_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("DY("//i_mrk//", "//j_mrk//", "//j_mrk//")"))
!
data_element create variable  &
 variable_name = (eval("ecc_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("SQRT(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//")**2 + VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//")**2)"))
!
! EPSILON - RELATIVNI EXCENTRICITA
!
data_element create variable  &                                                 ! [-] 
 variable_name = (eval("eps_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("scale_meter*VARVAL(ecc_"//bear_name//"_rad_"//RTOI(pair_id)//")/cl_"//bear_name//"_rad_"//RTOI(pair_id)))  
!
data_element create variable  &
 variable_name = (eval("asy_z_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("(VARVAL(eps_"//bear_name//"_rad_"//RTOI(pair_id)//") - hstart_axi)/(hstart_axi-hend_axi)")) 
!
data_element create variable  &
 variable_name = (eval("asy_w_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("1.0/(1.0 - VARVAL(asy_z_"//bear_name//"_rad_"//RTOI(pair_id)//") + VARVAL(asy_z_"//bear_name//"_rad_"//RTOI(pair_id)//")**2)"))
!
data_element create variable  &
 variable_name = (eval("eps_asy_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("IF(VARVAL(eps_"//bear_name//"_rad_"//RTOI(pair_id)//") - hstart_axi: (VARVAL(eps_"//bear_name//"_rad_"//RTOI(pair_id)//")), (hstart_axi), (hend_axi + (hstart_axi - hend_axi)*VARVAL(asy_w_"//bear_name//"_rad_"//RTOI(pair_id)//")))"))
!
! EPSDOT - ZMENA RELATIVNEJ EXCENTRICITY
!
data_element create variable  &
 variable_name = (eval("scale_epsdot_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("IF(VARVAL(eps_"//bear_name//"_rad_"//RTOI(pair_id)//") - hstart_axi: (1.0), (1.0), ((1.0 - 2.0*VARVAL(asy_z_"//bear_name//"_rad_"//RTOI(pair_id)//"))*VARVAL(asy_w_"//bear_name//"_rad_"//RTOI(pair_id)//")**2))"))
!
data_element create variable  &
 variable_name = (eval("velx_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("VX("//i_mrk//", "//j_mrk//", "//j_mrk//")"))
!
data_element create variable  &
 variable_name = (eval("vely_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("VY("//i_mrk//", "//j_mrk//", "//j_mrk//")"))
!
data_element create variable  &
 variable_name = (eval("gamma_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 !function = (eval("ATAN2(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//"), -1.0*VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//"))"))
 !function = (eval("IF(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//"):0.0, 0.0, ATAN2(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//"), -1.0*VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//")))"))
 !function = (eval("IF(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//"): ATAN2(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//"), -1.0*VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//")), IF(VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//"):0.0, 0.0, PI), ATAN2(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//"), -1.0*VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//")))"))
 function = (eval("IF(time-0.001: 0.0, 0.0, (ATAN2(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//"), -1.0*VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//"))))"))
!
data_element create variable  &
 variable_name = (eval("epsdot_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("scale_meter*VARVAL(scale_epsdot_"//bear_name//"_rad_"//RTOI(pair_id)//") * (VARVAL(velx_"//bear_name//"_rad_"//RTOI(pair_id)//") * SIN(VARVAL(gamma_"//bear_name//"_rad_"//RTOI(pair_id)//")) - VARVAL(vely_"//bear_name//"_rad_"//RTOI(pair_id)//") * COS(VARVAL(gamma_"//bear_name//"_rad_"//RTOI(pair_id)//")))/cl_"//bear_name//"_rad_"//RTOI(pair_id)))                 
!
data_element create variable  &
 variable_name = (eval("gammadot_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("COS(VARVAL(gamma_"//bear_name//"_rad_"//RTOI(pair_id)//"))**2 * (-1.0*VARVAL(velx_"//bear_name//"_rad_"//RTOI(pair_id)//")*VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//") + VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//")*VARVAL(vely_"//bear_name//"_rad_"//RTOI(pair_id)//"))/VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//")**2"))           
!
! OMEGA
!
data_element create variable  &
 variable_name = (eval("omega_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("1.0*WZ("//i_mrk//", "//j_mrk//", "//j_mrk//")"))
!
! RADIAL FORCE
!
data_element create variable  &
 variable_name = (eval("Frad_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("(-0.5*VARVAL(vis_rad_"//bear_name//"_rad_"//RTOI(pair_id)//")*L_"//bear_name//"_rad_"//RTOI(pair_id)//"**3*R_"//bear_name//"_rad_"//RTOI(pair_id)//")/cl_"//bear_name//"_rad_"//RTOI(pair_id)//"**2.0 * ((2.0*VARVAL(eps_asy_"//bear_name//"_rad_"//RTOI(pair_id)//")**2*(VARVAL(omega_"//bear_name//"_rad_"//RTOI(pair_id)//") - 2.0*VARVAL(gammadot_"//bear_name//"_rad_"//RTOI(pair_id)//"))/(1.0 - VARVAL(eps_asy_"//bear_name//"_rad_"//RTOI(pair_id)//")**2.0)**2.0) + (PI*VARVAL(epsdot_"//bear_name//"_rad_"//RTOI(pair_id)//")*(1.0 + 2.0*VARVAL(eps_asy_"//bear_name//"_rad_"//RTOI(pair_id)//")**2.0)/(1.0 - VARVAL(eps_asy_"//bear_name//"_rad_"//RTOI(pair_id)//")**2.0)**2.5))"))  
!
data_element create variable  &
 variable_name = (eval("Ftan_"//bear_name//"_rad_"//RTOI(pair_id)))  &                                                                                                                          
 function = (eval("(0.5*VARVAL(vis_rad_"//bear_name//"_rad_"//RTOI(pair_id)//")*L_"//bear_name//"_rad_"//RTOI(pair_id)//"**3*R_"//bear_name//"_rad_"//RTOI(pair_id)//")/cl_"//bear_name//"_rad_"//RTOI(pair_id)//"**2.0 * ((0.5*PI*VARVAL(eps_asy_"//bear_name//"_rad_"//RTOI(pair_id)//")*(VARVAL(omega_"//bear_name//"_rad_"//RTOI(pair_id)//") - 2.0*VARVAL(gammadot_"//bear_name//"_rad_"//RTOI(pair_id)//"))/(1.0 - VARVAL(eps_asy_"//bear_name//"_rad_"//RTOI(pair_id)//")**2.0)**1.5) + (4.0*VARVAL(eps_asy_"//bear_name//"_rad_"//RTOI(pair_id)//")*VARVAL(epsdot_"//bear_name//"_rad_"//RTOI(pair_id)//")/(1.0 - VARVAL(eps_asy_"//bear_name//"_rad_"//RTOI(pair_id)//")**2.0)**2.0))"))
!
data_element create variable  &                                                 ! [Nm]
 variable_name = (eval("Mfric_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("-2.0*PI*VARVAL(vis_rad_"//bear_name//"_rad_"//RTOI(pair_id)//")*R_"//bear_name//"_rad_"//RTOI(pair_id)//"**3*L_"//bear_name//"_rad_"//RTOI(pair_id)//"*VARVAL(omega_"//bear_name//"_rad_"//RTOI(pair_id)//")/cl_"//bear_name//"_rad_"//RTOI(pair_id)))
!
!-------------------------------------------------------
!
!


if condition = ((eval(.MODEL_1.rad_bear_properties.values[33,(eval(pair_id))])) == 1.0)  ! Shear Heating Effects ON
   !
   ! OTEPLENI OLEJE V LOZISKU - ZALOZENI PROMENNE
   data_element modify variable  &
    variable_name = (eval("dT_rad_"//bear_name//"_rad_"//RTOI(pair_id)))  &                        ! [degC]
    function = (eval("ABS(VARVAL(omega_"//bear_name//"_rad_"//RTOI(pair_id)//")) * ABS(VARVAL(Mfric_"//bear_name//"_rad_"//RTOI(pair_id)//"))/(cap * VARVAL(oil_mass_flow_rad_"//bear_name//"_rad_"//RTOI(pair_id)//"))"))
   ! 
end 
 
 
!
return
 








