!-------------------------------------------------------
!------------------ Test Rig Build ---------------------
! Data stored in array called ".test_rig_properties"
!-------------------------------------------------------
!
!var set var = tmp real = (eval(ies.values[2]*2*PI*UNITS_CONVERSION_FACTOR("second")/60.0))
!
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.test_rig_properties.values[1]))
   !
   part create rigid_body name_and_position part_name = (eval(model_name//".dyno_"//RTOI(i)))   
   !
   var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("second")/(60*UNITS_CONVERSION_FACTOR("revolutions"))))
   !
   part create rigid_body initial_velocity  &
    part_name = (eval(model_name//".dyno_"//RTOI(i)))  &
    wz = (evaL(-1.0*.MODEL_1.test_rig_properties.values[2]*.MODEL_1.test_rig_properties.values[28]*tmp)) &
    wm = (eval(model_name//".ground.LBRF"))
   !   
   var del var = tmp
   !                                                                                
   marker create marker = (eval(model_name//".dyno_"//RTOI(i)//".marker_cm")) &
    location=(LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.dyno_"//RTOI(i))))) &
    orientation=(ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.dyno_"//RTOI(i))))) 
   !
   entity attributes &
    entity_name = (eval(model_name//".dyno_"//RTOI(i)//".marker_cm")) &
    visibility = off &
    name_visibility = off 
   ! 
   marker create marker = (eval(model_name//".dyno_"//RTOI(i)//".marker_geom")) &
    location=(LOC_RELATIVE_TO({0.0, 0.0, -1.0}, (eval(model_name//".dyno_"//RTOI(i)//".marker_cm")))) &
    orientation=(ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".dyno_"//RTOI(i)//".marker_cm"))))
   !
   entity attributes &
    entity_name = (eval(model_name//".dyno_"//RTOI(i)//".marker_geom")) &
    visibility = off &
    name_visibility = off 
   !    
   geometry create shape cylinder &
    cylinder_name = (eval(model_name//".dyno_"//RTOI(i)//".cylinder_major")) &
    length = (2.0mm) &
    radius = (5.0mm) &
    angle = 330.0d &
    center_marker = (eval(model_name//".dyno_"//RTOI(i)//".marker_geom")) 
   !
   entity attributes entity_name = (eval(model_name//".dyno_"//RTOI(i)//".cylinder_major")) &
   color = .colors.YELLOW
   !
   geometry create shape cylinder &
    cylinder_name = (eval(model_name//".dyno_"//RTOI(i)//".cylinder_minor")) &
    length = (2.0mm) &
    radius = (5.0mm) &
    angle = -30.0d &
    center_marker = (eval(model_name//".dyno_"//RTOI(i)//".marker_geom")) 
   !
   entity attributes entity_name = (eval(model_name//".dyno_"//RTOI(i)//".cylinder_minor")) &
   color = .colors.RED
   !
   ! Inertia
   if condition = (i == (eval(.MODEL_1.test_rig_properties.values[1])))
      part modify rigid mass_properties  &
       part_name = (eval(model_name//".dyno_"//RTOI(i))) &
       mass = 1.0 &
       center_of_mass_marker = (eval(model_name//".dyno_"//RTOI(i)//".marker_cm")) &
       inertia_marker = (eval(model_name//".dyno_"//RTOI(i)//".marker_cm")) &
       ixx = 1.0 &
       iyy = 1.0 &
       izz = 1.0
   else
      part modify rigid mass_properties  &
       part_name = (eval(model_name//".dyno_"//RTOI(i))) &
       mass = 1.0 &
       center_of_mass_marker = (eval(model_name//".dyno_"//RTOI(i)//".marker_cm")) &
       inertia_marker = (eval(model_name//".dyno_"//RTOI(i)//".marker_cm")) &
       ixx = (.MODEL_1.test_rig_properties.values[(eval(13+i-1))]) &
       iyy = (.MODEL_1.test_rig_properties.values[(eval(13+i-1))]) &
       izz = (.MODEL_1.test_rig_properties.values[(eval(13+i-1))])   
   end   
   !
   ! Connectors
   if condition = (i == 1.0)
      force create element_like rotational_spring_damper  &
       spring_damper_name = (eval(model_name//".flexible_dyno_"//RTOI(i))) &
       stiffness = (.MODEL_1.test_rig_properties.values[(eval(3+i-1))]) &
       damping = (.MODEL_1.test_rig_properties.values[(eval(8+i-1))]) &
       i_marker_name = (eval(model_name//".turb_wheel.marker_cm")) &
       j_marker_name = (eval(model_name//".dyno_"//RTOI(i)//".marker_cm"))
   else
      force create element_like rotational_spring_damper  &
       spring_damper_name = (eval(model_name//".flexible_dyno_"//RTOI(i))) &
       stiffness = (.MODEL_1.test_rig_properties.values[(eval(3+i-1))]) &
       damping = (.MODEL_1.test_rig_properties.values[(eval(8+i-1))]) &
       i_marker_name = (eval(model_name//".dyno_"//RTOI(i-1)//".marker_cm")) &
       j_marker_name = (eval(model_name//".dyno_"//RTOI(i)//".marker_cm"))
   end
   !
   entity attributes &
    entity_name = (eval(model_name//".flexible_dyno_"//RTOI(i))) &
    size = 2.5
   !
end
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Thrust Force
!-------------------------------------------------------
!
force create direct single_component_force &
 single_component_force_name = (eval(model_name//".thrust_force")) &
 action_only = on &
 i_marker_name = (eval(model_name//".comp_wheel.marker_thrust_force")) & 
 j_marker_name = (eval(model_name//".ground.thrust_force")) &
 function = "0.0"
!
mdi graphic_force object = (eval(model_name//".thrust_force")) type = 1
!
var set var = tmp real = (eval(.MODEL_1.test_rig_properties.values[30]))        ! Direction of Thrust Force

if condition = ((eval(.MODEL_1.test_rig_properties.values[29])) == 1.0)         ! Thrust Force is Active
   ! 
   if condition = ((eval(.MODEL_1.test_rig_properties.values[31])) == 1.0)         ! Constant Thrust Force
      !
      force modify direct single_component_force &
       single_component_force_name = (eval(model_name//".thrust_force")) &
       function = (eval((eval(tmp))*(.MODEL_1.test_rig_properties.values[32])))
      !
   elseif condition = ((eval(.MODEL_1.test_rig_properties.values[31])) == 2.0)     ! Thrust Force as Spline
      !
      force modify direct single_component_force &
       single_component_force_name = (eval(model_name//".thrust_force")) &
       function = (eval("CUBSPL(60*ABS(VARVAL(omega_axi_1))/(2*PI), 0, "//RTOI(.MODEL_1.test_rig_properties.values[33])//", 0)*"//tmp))
      ! 
   end    
   ! 
end

return                  