!-------------------------------------------------------
!-------------------- Shaft Build ----------------------
! Data stored in array called ".shaft_properties"
!-------------------------------------------------------
!
if condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 1.0)             ! Rigid Shaft 
   !
   if condition = ((eval(.MODEL_1.shaft_properties.values[2])) == 1.0)          ! Mass Method: User Input 
      !
      part create rigid_body name_and_position part_name=(eval(model_name//".shaft")) 
      !
      var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("second")/(60*UNITS_CONVERSION_FACTOR("revolutions"))))
      !
      part create rigid_body initial_velocity  &
       part_name = (eval(model_name//".shaft"))  &
       wz = (evaL(-1.0*.MODEL_1.test_rig_properties.values[2]*.MODEL_1.test_rig_properties.values[28]*tmp)) &
       wm = (eval(model_name//".ground.LBRF"))
      !
      var del var = tmp
      !      
      part attributes part_name=(eval(model_name//".shaft")) color=GREEN name_vis=off
      !
      marker create marker = (eval(model_name//".shaft.marker_shaft_cw")) &
       location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_cw")))) &
       orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_cw")))) 
      !
      entity attributes &
       entity_name = (eval(model_name//".shaft.marker_shaft_cw")) &
       visibility = off &
       name_visibility = off
      !
      marker create marker = (eval(model_name//".shaft.marker_shaft_tw")) &
       location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_tw")))) &
       orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_tw")))) 
      !
      entity attributes &
       entity_name = (eval(model_name//".shaft.marker_shaft_tw")) &
       visibility = off &
       name_visibility = off
      ! 
      marker create marker = (eval(model_name//".shaft.marker_cm")) &
       location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_cm")))) &
       orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_cm")))) 
      !
      entity attributes &
       entity_name = (eval(model_name//".shaft.marker_cm")) &
       visibility = off &
       name_visibility = off
      !     
      geometry create shape cylinder &
       cylinder_name = (eval(model_name//".shaft.cylinder")) &
       length = (-1.0*.MODEL_1.shaft_properties.values[3]) &
       radius = (0.5*.MODEL_1.shaft_properties.values[4]) &
       angle = 360.0d &
       center_marker = (eval(model_name//".shaft.marker_shaft_cw"))
      !
      part modify rigid_body mass_properties part_name = (eval(model_name//".shaft")) &
       mass = (.MODEL_1.shaft_properties.values[5]) & 
       center_of_mass_marker = (eval(model_name//".shaft.marker_cm")) &
       inertia_marker = (eval(model_name//".shaft.marker_cm")) &
       ixx = (.MODEL_1.shaft_properties.values[7]) & 
       iyy = (.MODEL_1.shaft_properties.values[8]) & 
       izz = (.MODEL_1.shaft_properties.values[9]) 
      !
      if condition = ((eval(.MODEL_1.shaft_properties.values[14])) == 1.0)         ! Off Diagonal Terms
         !
         part modify rigid_body mass_properties part_name=(eval(model_name//".shaft")) &
          ixy = (.MODEL_1.shaft_properties.values[10]) & 
          iyz = (.MODEL_1.shaft_properties.values[11]) &
          izx = (.MODEL_1.shaft_properties.values[12])
         !   
      end
      !
   end
   !
   ! Radial Bearings 
   !
   for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.rad_bear_properties.values[1,1]))
      !
      marker create marker = (eval(model_name//".shaft.marker_rad_bear_"//RTOI(i))) &
       location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i))))) &
       orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i))))) 
      ! 
      entity attributes &
       entity_name = (eval(model_name//".shaft.marker_rad_bear_"//RTOI(i))) &
       visibility = off &
       name_visibility = off 
      !
   end
   !
   ! Axial Bearings 
   !
   for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.axi_bear_properties.values[1,1]))
      !
      marker create marker = (eval(model_name//".shaft.marker_axi_bear_"//RTOI(i))) &
       location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_axi_bear_"//RTOI(i))))) &
       orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_axi_bear_"//RTOI(i))))) 
      !
      entity attributes &
       entity_name = (eval(model_name//".shaft.marker_axi_bear_"//RTOI(i))) &
       visibility = off &
       name_visibility = off 
      !
  end
  !
elseif condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 2.0)         ! Beam Shaft   
   !
   var set var = tmp_density real = (eval(.MODEL_1.shaft_properties.values[13]))
   var set var = rad_bear_seg real = 1.0
   var set var = axi_bear_seg real = 1.0
   !
   for variable_name = i start_value = 1 end_value = (eval(RTOI(.MODEL_1.shaft_properties.values[25])))
      !
      var set var = tmp_length real = (eval(.MODEL_1.shaft_div_length[eval(i)]))
      var set var = tmp_dia real = (eval(.MODEL_1.shaft_div_dia[eval(i)]))
      var set var = tmp_mass real = (eval(0.25*PI*tmp_dia*tmp_dia*tmp_length*tmp_density))
      !    
      part create rigid_body name_and_position  &
       part_name = (eval(model_name//".shaft_elem_"//RTOI(i)))
      ! 
      var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("second")/(60*UNITS_CONVERSION_FACTOR("revolutions"))))
      !
      part create rigid_body initial_velocity  &
       part_name = (eval(model_name//".shaft_elem_"//RTOI(i)))  &
       wz = (evaL(-1.0*.MODEL_1.test_rig_properties.values[2]*.MODEL_1.test_rig_properties.values[28]*tmp)) &
       wm = (eval(model_name//".ground.LBRF"))
      ! 
      var del var = tmp
      !
      if condition = ((eval(i)) == 1)
         !
!          part modify rigid_body name_and_position  &
!           part_name = (eval(model_name//".shaft_elem_"//RTOI(i))) &
!           location = (LOC_RELATIVE_TO({ 0.0, 0.0, (eval(-0.5*tmp_length))}, (eval(model_name//".ground.LBRF")))) &
!           orientation = (ORI_RELATIVE_TO({ 0.0, 0.0, 0.0}, (eval(model_name//".ground.LBRF"))))   
         !
         marker create marker_name = (eval(model_name//".shaft_elem_"//RTOI(i)//".cm")) &
          location = (LOC_RELATIVE_TO({ 0.0, 0.0, (eval(-0.5*tmp_length))}, (eval(model_name//".ground.LBRF")))) &
          orientation = (ORI_RELATIVE_TO({ 0.0, 0.0, 0.0}, (eval(model_name//".ground.LBRF"))))
         ! 
         marker create marker_name = (eval(model_name//".shaft_elem_"//RTOI(i)//".marker_start")) &
          location = (LOC_RELATIVE_TO({ 0.0, 0.0, 0.0}, (eval(model_name//".ground.LBRF")))) &
          orientation = (ORI_RELATIVE_TO({ 0.0, 0.0, 0.0}, (eval(model_name//".ground.LBRF"))))
         !
         marker create marker_name = (eval(model_name//".shaft_elem_"//RTOI(i)//".marker_end")) &
          location = (LOC_RELATIVE_TO({ 0.0, 0.0, (eval(-1.0*tmp_length))}, (eval(model_name//".ground.LBRF")))) &
          orientation = (ORI_RELATIVE_TO({ 0.0, 0.0, 0.0}, (eval(model_name//".ground.LBRF")))) 
         !
         marker create marker_name = (eval(model_name//".shaft_elem_"//RTOI(i)//".m_"//RTOI(i))) &
          location = (LOC_RELATIVE_TO({ 0.0, 0.0, (eval(-1.0*tmp_length))}, (eval(model_name//".ground.LBRF")))) &
          orientation = (ORI_RELATIVE_TO({ 90.0d, 90.0d, -90.0d}, (eval(model_name//".ground.LBRF")))) 
         !
      else
         !
!          part modify rigid_body name_and_position  &
!           part_name = (eval(model_name//".shaft_elem_"//RTOI(i))) &
!           location = (LOC_RELATIVE_TO({ 0.0, 0.0, (eval(-0.5*tmp_length))}, (eval(model_name//".shaft_elem_"//RTOI(i-1)//".marker_end")))) &
!           orientation = (ORI_RELATIVE_TO({ 0.0, 0.0, 0.0}, (eval(model_name//".ground.LBRF"))))
         ! 
         marker create marker_name = (eval(model_name//".shaft_elem_"//RTOI(i)//".cm")) &
          location = (LOC_RELATIVE_TO({ 0.0, 0.0, (eval(-0.5*tmp_length))}, (eval(model_name//".shaft_elem_"//RTOI(i-1)//".marker_end")))) &
          orientation = (ORI_RELATIVE_TO({ 0.0, 0.0, 0.0}, (eval(model_name//".ground.LBRF"))))
         ! 
         marker create marker_name = (eval(model_name//".shaft_elem_"//RTOI(i)//".marker_start")) &
          location = (LOC_RELATIVE_TO({ 0.0, 0.0, 0.0}, (eval(model_name//".shaft_elem_"//RTOI(i-1)//".marker_end")))) &
          orientation = (ORI_RELATIVE_TO({ 0.0, 0.0, 0.0}, (eval(model_name//".ground.LBRF")))) 
         !
         marker create marker_name = (eval(model_name//".shaft_elem_"//RTOI(i)//".marker_end")) &
          location = (LOC_RELATIVE_TO({ 0.0, 0.0, (eval(-1.0*tmp_length))}, (eval(model_name//".shaft_elem_"//RTOI(i-1)//".marker_end")))) &
          orientation = (ORI_RELATIVE_TO({ 0.0, 0.0, 0.0}, (eval(model_name//".ground.LBRF")))) 
         !
         marker create marker_name = (eval(model_name//".shaft_elem_"//RTOI(i)//".m_"//RTOI(i))) &
          location = (LOC_RELATIVE_TO({ 0.0, 0.0, (eval(-1.0*tmp_length))}, (eval(model_name//".shaft_elem_"//RTOI(i-1)//".marker_end")))) &
          orientation = (ORI_RELATIVE_TO({ 90.0d, 90.0d, -90.0d}, (eval(model_name//".ground.LBRF")))) 
         ! 
      end 
      !
      entity attributes &
       entity_name = (eval(model_name//".shaft_elem_"//RTOI(i)//".cm")) &
       visibility = off &
       name_visibility = off 
      !
      entity attributes &
       entity_name = (eval(model_name//".shaft_elem_"//RTOI(i)//".marker_start")) &
       visibility = off &
       name_visibility = off 
      !
      entity attributes &
       entity_name = (eval(model_name//".shaft_elem_"//RTOI(i)//".marker_end")) &
       visibility = off &
       name_visibility = off       
      ! 
      entity attributes &
       entity_name = (eval(model_name//".shaft_elem_"//RTOI(i)//".m_"//RTOI(i))) &
       visibility = off &
       name_visibility = off     
      !
      part create rigid_body mass_properties  &
       part_name = (eval(model_name//".shaft_elem_"//RTOI(i)))  & 
       mass = (eval(tmp_mass)) &      
       center_of_mass_marker = (eval(model_name//".shaft_elem_"//RTOI(i)//".cm")) &
       inertia_marker = (eval(model_name//".shaft_elem_"//RTOI(i)//".cm")) &
       ixx = (eval(0.25*tmp_mass*0.25*tmp_dia*tmp_dia + (1/12)*tmp_mass*tmp_length)) &
       iyy = (eval(0.25*tmp_mass*0.25*tmp_dia*tmp_dia + (1/12)*tmp_mass*tmp_length)) &
       izz = (eval(0.5*tmp_mass*0.25*tmp_dia*tmp_dia)) &
       ixy = 0  &
       izx = 0  &
       iyz = 0
      !
      geometry create shape cylinder  &
       cylinder_name = (eval(model_name//".shaft_elem_"//RTOI(i)//".cyl_"//RTOI(i))) & 
       center_marker = (eval(model_name//".shaft_elem_"//RTOI(i)//".marker_end")) &
       angle = 360.0d &
       length = (eval(tmp_length))  &
       radius = (eval(0.5*tmp_dia))  &
       side_count_for_body = 20  &
       segment_count_for_ends = 20 
      !
      entity attributes &
       entity_name = (eval(model_name//".shaft_elem_"//RTOI(i)//".cyl_"//RTOI(i))) & 
       color       = DARK_GRAY  
      !
      ! Detection of Bearings segments
      !
      ! Radial Bearings
      for variable_name = j start_value = 1 end_value = (eval(RTOI(.MODEL_1.rad_bear_properties.values[1,1]))) 
         !
         var set var = tmp_bear real = (eval(.MODEL_1.rad_bear_properties.values[3,j]))
         var set var = tmp_div real = (eval(.MODEL_1.shaft_div_cum_length[i] - tmp_length))
         !
         if condition = (tmp_bear > tmp_div)
            !
            rad_bear_seg[j] = (eval(i)) 
            !
         end
         !
      end
      !
      ! Axial Bearings
      for variable_name = j start_value = 1 end_value = (eval(RTOI(.MODEL_1.axi_bear_properties.values[1,1]))) 
         !
         var set var = tmp_bear real = (eval(.MODEL_1.axi_bear_properties.values[3,j]))
         var set var = tmp_div real = (eval(.MODEL_1.shaft_div_cum_length[i] - tmp_length))
         !
         if condition = (tmp_bear > tmp_div)
            !
            axi_bear_seg[j] = (eval(i)) 
            !
         end
         !
      end
      !
      ! Beam Forces
      !
      if condition = ((eval(i)) > 1)
         !
         force create element_like beam  &
          beam_name = (eval(model_name//".BEAM_"//RTOI(i))) &
          ixx = (eval(PI*tmp_dia*tmp_dia*tmp_dia*tmp_dia/32)) &
          iyy = (eval(PI*tmp_dia*tmp_dia*tmp_dia*tmp_dia/64)) & 
          izz = (eval(PI*tmp_dia*tmp_dia*tmp_dia*tmp_dia/64)) &
          y_shear_area_ratio = 1.1111  &
          z_shear_area_ratio = 1.1111  &
          youngs_modulus = (.MODEL_1.shaft_properties.values[26])  &
          shear_modulus = (0.5*.MODEL_1.shaft_properties.values[26]/(1+.MODEL_1.shaft_properties.values[27])) &          !7.92E+04  &
          length = (eval(tmp_length))  &
          area_of_cross_section = (eval(0.25*pi*tmp_dia*tmp_dia)) &
          damping_ratio = (.MODEL_1.shaft_properties.values[28])  &
          formulation = nonlinear  &
          i_marker_name = (eval(model_name//".shaft_elem_"//RTOI(i)//".m_"//RTOI(i))) &
          j_marker_name = (eval(model_name//".shaft_elem_"//RTOI(i-1)//".m_"//RTOI(i-1)))
         !
         entity attributes & 
          entity_name = (eval(model_name//".BEAM_"//RTOI(i))) &
          size = 1
         !          
      end
      !    
   end
   !
   var del var = tmp_density
   var del var = tmp_length
   var del var = tmp_dia
   var del var = tmp_mass
   var del var = tmp_bear
   var del var = tmp_div
   !
   marker create marker = (eval(model_name//".shaft_elem_1.marker_shaft_cw")) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_cw")))) &
    orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_cw")))) 
   !    
   entity attributes &
    entity_name = (eval(model_name//".shaft_elem_1.marker_shaft_cw")) &
    visibility = off &
    name_visibility = off 
   ! 
   marker create marker = (eval(model_name//".shaft_elem_"//RTOI(.MODEL_1.shaft_properties.values[25])//".marker_shaft_tw")) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_tw")))) &
    orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_tw")))) 
   !
   entity attributes &
    entity_name = (eval(model_name//".shaft_elem_"//RTOI(.MODEL_1.shaft_properties.values[25])//".marker_shaft_tw")) &
    visibility = off &
    name_visibility = off 
   !    
   ! Radial Bearings
   for variable_name = i start_value = 1 end_value = (eval(RTOI(.MODEL_1.rad_bear_properties.values[1,1]))) 
      !
      marker create marker = (eval(model_name//".shaft_elem_"//RTOI(rad_bear_seg[i])//".marker_rad_bear_"//RTOI(i))) & 
       location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i))))) &
       orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i))))) 
      ! 
      entity attributes &
       entity_name = (eval(model_name//".shaft_elem_"//RTOI(rad_bear_seg[i])//".marker_rad_bear_"//RTOI(i))) &
       visibility = off &
       name_visibility = off 
      !    
   end
   !
   ! Axial Bearings
   for variable_name = i start_value = 1 end_value = (eval(RTOI(.MODEL_1.axi_bear_properties.values[1,1]))) 
      !
      marker create marker = (eval(model_name//".shaft_elem_"//RTOI(axi_bear_seg[i])//".marker_axi_bear_"//RTOI(i))) & 
       location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_axi_bear_"//RTOI(i))))) &
       orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_axi_bear_"//RTOI(i))))) 
      ! 
      entity attributes &
       entity_name = (eval(model_name//".shaft_elem_"//RTOI(axi_bear_seg[i])//".marker_axi_bear_"//RTOI(i))) &
       visibility = off &
       name_visibility = off 
      !    
   end
   !
end
!
!-------------------------------------------------------
return