!-------------------------------------------------------
!---------------- Bearing Ring Build -------------------
!-------------------------------------------------------
!
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.rad_bear_properties.values[1,1]))
   !
   if condition = ((eval(.MODEL_1.rad_bear_properties.values[2,(eval(i))])) == 3.0)  ! Radial Bearing Solved by Ocvirk Solution
      !
      part create rigid_body name_and_position part_name = (eval(model_name//".bearing_ring_rad_"//RTOI(i)))
      !
      part create rigid_body initial_velocity  &
       part_name = (eval(model_name//".bearing_ring_rad_"//RTOI(i)))  
      !
      if condition = ((eval(.MODEL_1.rad_bear_properties.values[26,(eval(i))])) == 1.0)             ! Rotating Bearing Ring 
         !
         var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("second")/(60*UNITS_CONVERSION_FACTOR("revolutions"))))
         !
         part modify rigid_body initial_velocity  &
          part_name = (eval(model_name//".bearing_ring_rad_"//RTOI(i)))  &
          wz = (evaL(-0.28*.MODEL_1.test_rig_properties.values[2]*.MODEL_1.test_rig_properties.values[28]*tmp)) &
          wm = (eval(model_name//".ground.LBRF"))
         !
         var del var = tmp
         !
      end 
      ! 
      var set var = tmp_str string = (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i)))
      var set var = tmp_obj object = (eval(tmp_str))
      !
      marker create marker = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".marker_cm")) &
       location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) & 
       orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj))))
      !
      entity attributes entity_name = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".marker_cm")) visibility = off
      !
      marker create marker = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".marker_rad_bear_"//RTOI(i))) &
       location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) & 
       orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj))))
      !
      entity attributes entity_name = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".marker_rad_bear_"//RTOI(i))) visibility = off
      !
      marker create marker = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".marker_beg")) & 
       location = (LOC_RELATIVE_TO({0.0, 0.0, -0.5*(.MODEL_1.rad_bear_properties.values[24,(eval(i))])}, (eval(tmp_obj)))) &
       orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj))))
      !
      entity attributes entity_name = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".marker_beg")) visibility = off
      !
      geometry create shape cylinder &
       cylinder_name = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".cylinder_outer1")) &
       length = (.MODEL_1.rad_bear_properties.values[24,(eval(i))]) &
       radius = (.MODEL_1.rad_bear_properties.values[23,(eval(i))]) &
       angle = 330.0d &
       center_marker = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".marker_beg"))
      !
      geometry create shape cylinder &
       cylinder_name = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".cylinder_outer2")) &
       length = (.MODEL_1.rad_bear_properties.values[24,(eval(i))]) &
       radius = (.MODEL_1.rad_bear_properties.values[23,(eval(i))]) &
       angle = -30.0d &
       center_marker = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".marker_beg"))
      !
      geometry create shape cylinder &
       cylinder_name = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".cylinder_inner")) &
       length = (.MODEL_1.rad_bear_properties.values[24,(eval(i))]) &
       radius = (.MODEL_1.rad_bear_properties.values[20,(eval(i))]) &
       angle = 360.0d &
       center_marker = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".marker_beg"))
      !
      geometry create shape csg csg_name = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".cylinder_ring")) & 
       base_object = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".cylinder_outer1")) &
       object = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".cylinder_inner")) &
       type = difference           
      !
      entity attributes entity_name = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".cylinder_ring")) & 
       color = .colors.YELLOW
      ! 
      geometry create shape cylinder &
       cylinder_name = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".cylinder_inner")) &
       length = (.MODEL_1.rad_bear_properties.values[24,(eval(i))]) &
       radius = (.MODEL_1.rad_bear_properties.values[20,(eval(i))]) &
       angle = 360.0d &
       center_marker = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".marker_beg"))
      !
      geometry create shape csg csg_name = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".cylinder_ring_sec")) & 
       base_object = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".cylinder_outer2")) &
       object = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".cylinder_inner")) &
       type = difference  
      !
      entity attributes entity_name = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".cylinder_ring_sec")) & 
       color = .colors.RED
      !
      part modify rigid mass_properties  &
       part_name = (eval(model_name//".bearing_ring_rad_"//RTOI(i))) &
       mass = (.MODEL_1.rad_bear_properties.values[27,(eval(i))])  &
       center_of_mass_marker = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".marker_cm")) &
       inertia_marker = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".marker_cm")) &
       ixx = (.MODEL_1.rad_bear_properties.values[28,(eval(i))]) &
       iyy = (.MODEL_1.rad_bear_properties.values[29,(eval(i))]) &
       izz = (.MODEL_1.rad_bear_properties.values[30,(eval(i))])
      !
      if condition = ((eval(.MODEL_1.rad_bear_properties.values[26,(eval(i))])) == 0.0)    ! Antirotation Pin Present 
         !    
         var set var = tmp_str string = (eval(model_name//".ground.bear_ring_pin_rad_"//RTOI(i)))
         var set var = tmp_obj object = (eval(tmp_str))
         !
         marker create marker = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".marker_ring_pin_"//RTOI(i))) &
          location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) & 
          orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj))))
         !
         entity attributes entity_name = (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".marker_ring_pin_"//RTOI(i))) visibility = off
         !
      end
      !
      var del var = tmp_str
      var del var = tmp_obj 
      !
   end
   !
end

return