!-------------------------------------------------------
!-------- Analytical Solution of Radial Bearing --------
!-------------------------------------------------------
!
var set var = scale_meter real = (UNITS_CONVERSION_FACTOR('meter'))
var set var = scale_second real = (UNITS_CONVERSION_FACTOR('second'))

! Asymptotic Eccentricity Parameters
var set var = hstart real = 0.999
var set var = hend real = 0.9999
!
var set var = ecc_0 real = 1E-5
!
!var set var = id int = 8                                                        ! ID of the bearing
!
if condition = ((eval(.MODEL_1.id)) <= 6.0)                                     ! Inner Bearing 
   !
   var set var = pair_id int = (eval(id))                                       ! ID of the bearing pair
   var set var = bear_name string = "inner"
   !
else                                                                            ! Outer Bearing
   !
   var set var = pair_id int = (eval(id-6))                                       ! ID of the bearing pair
   var set var = bear_name string = "outer"
   ! 
end 
!

!
! data_element create variable  &
!  variable_name = (eval("SUB_gamma_"//bear_name//"_rad_"//RTOI(pair_id)))  &
!  user_function = (eval(.MODEL_1.id)), (.MODEL_1.rad_bear_properties.adams_id) &
!  routine = "myvar::varsub"







!-------------------------------------------------------
! Oil Properties
!-------------------------------------------------------
!
! VISKOSITA OLEJE -> (VOGEL coef. a,b,c)
!
var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("newton")*UNITS_CONVERSION_FACTOR("second")/UNITS_CONVERSION_FACTOR("meter")**2))
variable set  &                                                                 
 variable_name = vis_hths  &                                                    ! [Pa.s]
 units = "no_units"  &
 real_value = (eval(tmp*(eval(STOO(model_name//".rad_bear_properties")).values[17,(eval(pair_id))]))) &
 comments = "Pa.s" 
!
var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("newton")*UNITS_CONVERSION_FACTOR("second")/UNITS_CONVERSION_FACTOR("meter")**2))
variable set  &                                                                 
 variable_name = voga  &                                                        ! [Pa.s]
 units = "no_units"  &
 real_value = (eval(tmp*(eval(STOO(model_name//".rad_bear_properties")).values[12,(eval(pair_id))]))) &
 comments = "Pa.s"
! 
variable set  &                                                                 
 variable_name = vogb  &                                                        ! [degC]
 units = "no_units"  &
 real_value = (eval(eval(STOO(model_name//".rad_bear_properties")).values[13,(eval(pair_id))])) &
 comments = "degC"
! 
variable set  &                                                                 
 variable_name = vogc  &                                                        ! [degC]
 units = "no_units"  &
 real_value = (eval(eval(STOO(model_name//".rad_bear_properties")).values[14,(eval(pair_id))])) &
 comments = "degC" 
!
! HUSTOTA OLEJE ro_0
!
var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("kilogram")/UNITS_CONVERSION_FACTOR("meter")**3))
variable set  &                                                                 
 variable_name = ro_0  &                                                          ! [kg/meter**3]
 units = "no_units"  &
 real_value = (eval(tmp*(eval(STOO(model_name//".rad_bear_properties")).values[34,(eval(pair_id))]))) &
 comments = "kg/meter**3"  
!
! TEPLOTA S HUSTOUTOU ro_0
!
variable set  &
 variable_name = T_ro_0  &                                                      ! [C]
 units = "no_units"  &
 real_value = (eval(eval(STOO(model_name//".rad_bear_properties")).values[35,(eval(pair_id))])) & 
 comments = "degC"
!
! MERNA TEPELNA ROZTAZNOST OLEJA
!
variable set &
 variable_name = alpha_ro &                                                     ! [-]
 units = "no_units"  &
 real_value = (eval(eval(STOO(model_name//".rad_bear_properties")).values[36,(eval(pair_id))])) 
 

!

! MERNA TEPELNA KAPACITA  
!
variable set  &
 variable_name = cap  &                                                         ! [J/(kg*K)] 
 units = "no_units"  &
 real_value = (eval(eval(STOO(model_name//".rad_bear_properties")).values[16,(eval(pair_id))])) &
 comments = "J/(kg*K)"
!
! VSTUPNI TEPLOTA 
! 
variable set  &
 variable_name = T0  &                                                          ! [C]
 units = "no_units"  &
 real_value = (eval(eval(STOO(model_name//".rad_bear_properties")).values[15,(eval(pair_id))])) & 
 comments = "degC"
!
! Korekce shear velocity on viscositu
!
variable set  &
 variable_name = shvelcor  &                                                    ! [-]
 units = "no_units"  &
 real_value = (eval((vis_hths/voga)*EXP(vogb/(vogc-150.0))))
!
! OTEPLENI OLEJE V LOZISKU - ZALOZENI PROMENNE
data_element create variable  &
 variable_name = (eval("dT_rad_"//bear_name//"_rad_"//RTOI(pair_id)))  &                        ! [degC]
 function = "0.0" &
 initial_condition = 0.0 &
 comments = "degC"
!
data_element create variable  &
 variable_name = (eval("dTavg_rad_"//bear_name//"_rad_"//RTOI(pair_id)))  &                        ! [degC]
 function = "0.0" &
 initial_condition = 0.0 &
 comments = "degC" 
!
! VISKOSITA OLEJE - ZALOZENI PROMENNE
data_element create variable  &
 variable_name = (eval("vis_rad_"//bear_name//"_rad_"//RTOI(pair_id)))  &                       ! [Pa.s]
 function = "" &
 comments = "Pa.s"
!
! OBJEMOVY TOK - ZALOZENIE PREMENNEJ
var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("meter")**3/UNITS_CONVERSION_FACTOR("second")))
data_element create variable  &
 variable_name = (eval("oil_vol_flow_rad_"//bear_name//"_rad_"//RTOI(pair_id)))  &                        ! [m3/s]
 function = (eval(tmp*(eval(STOO(model_name//".rad_bear_properties")).values[37,(eval(pair_id))])))
!
! TEPLOTA OLEJA
data_element create variable &
 variable_name = (eval("T_rad_"//bear_name//"_rad_"//RTOI(pair_id)))  &                       ! [degC]
 function = (eval("T0 + VARVAL(dTavg_rad_"//bear_name//"_rad_"//RTOI(pair_id)//")")) &
 initial_condition = (T0)                 
!
! HUSTOTA OLEJA - ZALOZENI PREMENNEJ
data_element create variable &
 variable_name = (eval("dens_rad_"//bear_name//"_rad_"//RTOI(pair_id)))  &                       ! [kg/m3]
 function = (eval("ro_0/(1+alpha_ro*(VARVAL(T_rad_"//bear_name//"_rad_"//RTOI(pair_id)//") - T_ro_0))"))
!
! HMOTNOSTNY TOK
!
data_element create variable  &
 variable_name = (eval("oil_mass_flow_rad_"//bear_name//"_rad_"//RTOI(pair_id)))  &                        ! [kg/s]
! function = (eval("VARVAL(oil_vol_flow_rad_"//bear_name//"_rad_"//RTOI(pair_id)//")*VARVAL(dens_rad_"//bear_name//"_rad_"//RTOI(pair_id)//")"))
 function = (eval("VARVAL(oil_vol_flow_rad_"//bear_name//"_rad_"//RTOI(pair_id)//")*ro_0")) 
!                                               
!
! VISKOSITA OLEJE
data_element modify variable  &
 variable_name = (eval("vis_rad_"//bear_name//"_rad_"//RTOI(pair_id)))  &                       ! [Pa.s]
 function = (eval("shvelcor*voga*EXP(vogb/(VARVAL(T_rad_"//bear_name//"_rad_"//RTOI(pair_id)//") - vogc))")) &
 comments = "Pa.s"

! HUSTOTA OLEJA
data_element modify variable &
 variable_name = (eval("dens_rad_"//bear_name//"_rad_"//RTOI(pair_id)))  &                       ! [kg/m3]
 function = (eval("ro_0/(1+alpha_ro*(VARVAL(T_rad_"//bear_name//"_rad_"//RTOI(pair_id)//") - T_ro_0))"))  &
 comments = "kg/m3"
!




!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Geometrical Dimensions
!-------------------------------------------------------
!
var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("meter")))
!   
if condition = ((eval(.MODEL_1.id)) <= 6.0)                                     ! Inner Bearing 
   !
   ! VOLA LOZISKA
   !
   variable create  &
    variable_name = (eval("cl_"//bear_name//"_rad_"//RTOI(pair_id))) &          ! [meter]
    units = "no_units"  &
    real_value = (eval(tmp*(eval(STOO(model_name//".rad_bear_properties")).values[22,(eval(pair_id))]))) &
    comments = "meter"
   !
   ! RADIUS LOZISKA
   !
   variable create  &
    variable_name = (eval("R_"//bear_name//"_rad_"//RTOI(pair_id))) &           ! [meter]
    units = "no_units"  &
    real_value = (eval(tmp*(eval(STOO(model_name//".rad_bear_properties")).values[20,(eval(pair_id))]))) &
    comments = "meter"
   !
   ! DLZKA LOZISKA
   !
   variable create  &
    variable_name = (eval("L_"//bear_name//"_rad_"//RTOI(pair_id))) &           ! [meter]
    units = "no_units"  &                                                       
    real_value = (eval(tmp*(eval(STOO(model_name//".rad_bear_properties")).values[21,(eval(pair_id))]))) &
    comments = "meter"
   !
else                                                                            ! Outer Bearing
   !
   ! VOLA LOZISKA
   !
   variable create  &
    variable_name = (eval("cl_"//bear_name//"_rad_"//RTOI(pair_id))) &          ! [meter]
    units = "no_units"  &
    real_value = (eval(tmp*(eval(STOO(model_name//".rad_bear_properties")).values[25,(eval(pair_id))]))) &
    comments = "meter"
   !
   ! RADIUS LOZISKA
   !
   variable create  &                                                              
    variable_name = (eval("R_"//bear_name//"_rad_"//RTOI(pair_id))) &           ! [meter]
    units = "no_units"  &
    real_value = (eval(tmp*(eval(STOO(model_name//".rad_bear_properties")).values[23,(eval(pair_id))]))) &
    comments = "meter"
   !
   ! DLZKA LOZISKA
   !
   variable create  &
    variable_name = (eval("L_"//bear_name//"_rad_"//RTOI(pair_id))) &           ! [meter]
    units = "no_units"  &
    real_value = (eval(tmp*(eval(STOO(model_name//".rad_bear_properties")).values[24,(eval(pair_id))]))) &
    comments = "meter"
   !
end
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Kinematic Variables
!-------------------------------------------------------
!
if condition = ((eval(.MODEL_1.id)) <= 6.0)                                     ! Inner Bearing 
   !
   var set var = i_mrk int = (eval(eval(STOO(model_name//".rad_bear_properties")).values[9,(eval(pair_id))]))
   var set var = j_mrk int = (eval(eval(STOO(model_name//".rad_bear_properties")).values[11,(eval(pair_id))])) 
   !
else                                                                            ! Outer Bearing
   !
   var set var = i_mrk int = (eval(eval(STOO(model_name//".rad_bear_properties")).values[11,(eval(pair_id))]))
   var set var = j_mrk int = (eval(eval(STOO(model_name//".rad_bear_properties")).values[10,(eval(pair_id))])) 
   !
end
!
! EXCENTRICITA
!
data_element create variable  &
 variable_name = (eval("disx_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("DX("//i_mrk//", "//j_mrk//", "//j_mrk//")"))
!
data_element create variable  &
 variable_name = (eval("disy_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("DY("//i_mrk//", "//j_mrk//", "//j_mrk//")"))
!
data_element create variable  &
 variable_name = (eval("ecc_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("ecc_0 + SQRT(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//")**2 + VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//")**2)"))
!
! EPSILON - RELATIVNI EXCENTRICITA
!
data_element create variable  &                                                 ! [-] 
 variable_name = (eval("eps_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("scale_meter*VARVAL(ecc_"//bear_name//"_rad_"//RTOI(pair_id)//")/cl_"//bear_name//"_rad_"//RTOI(pair_id)))  
!
data_element create variable  &
 variable_name = (eval("asy_z_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("(VARVAL(eps_"//bear_name//"_rad_"//RTOI(pair_id)//") - hstart)/(hstart-hend)")) 
!
data_element create variable  &
 variable_name = (eval("asy_w_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("1.0/(1.0 - VARVAL(asy_z_"//bear_name//"_rad_"//RTOI(pair_id)//") + VARVAL(asy_z_"//bear_name//"_rad_"//RTOI(pair_id)//")**2)"))
!
data_element create variable  &
 variable_name = (eval("eps_asy_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("IF(VARVAL(eps_"//bear_name//"_rad_"//RTOI(pair_id)//") - hstart: (VARVAL(eps_"//bear_name//"_rad_"//RTOI(pair_id)//")), (hstart), (hend + (hstart - hend)*VARVAL(asy_w_"//bear_name//"_rad_"//RTOI(pair_id)//")))"))
!
! EPSDOT - ZMENA RELATIVNEJ EXCENTRICITY
!
data_element create variable  &
 variable_name = (eval("scale_epsdot_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 !function = (eval("IF(VARVAL(eps_"//bear_name//"_rad_"//RTOI(pair_id)//") - hstart: (1.0), (1.0), ((1.0 - 2.0*VARVAL(asy_z_"//bear_name//"_rad_"//RTOI(pair_id)//"))*VARVAL(asy_w_"//bear_name//"_rad_"//RTOI(pair_id)//")**2))"))
 function = "1.0"
!
data_element create variable  &
 variable_name = (eval("velx_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("VX("//i_mrk//", "//j_mrk//", "//j_mrk//")"))  &
 comments = "meter" 
!
data_element create variable  &
 variable_name = (eval("vely_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("VY("//i_mrk//", "//j_mrk//", "//j_mrk//")"))
!
data_element create variable  &
 variable_name = (eval("gamma_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 !function = (eval("ATAN2(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//"), -1.0*VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//"))"))       ! funguje, ked sa zacina z nenulovej rychlosti
 function = (eval("IF(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//"): ATAN2(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//"), -1.0*VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//")), (IF(VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//"):  ATAN2(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//"), -1.0*VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//")), 0.0,  ATAN2(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//"), -1.0*VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//")))), ATAN2(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//"), -1.0*VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//")))"))
 !function = (eval("IF(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//"):0.0, 0.0, ATAN2(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//"), -1.0*VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//")))"))
 !function = (eval("IF(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//"): ATAN2(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//"), -1.0*VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//")), IF(VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//"):0.0, 0.0, PI), ATAN2(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//"), -1.0*VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//")))"))
 !function = (eval("IF(time-0.001: 0.0, 0.0, (ATAN2(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//"), -1.0*VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//"))))"))              ! funguje ked sa startuje od nuly
!
data_element create variable  &
 variable_name = (eval("epsdot_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("IF(time-0.000001/scale_second: 0.0, 0.0, scale_meter*VARVAL(scale_epsdot_"//bear_name//"_rad_"//RTOI(pair_id)//") * (VARVAL(velx_"//bear_name//"_rad_"//RTOI(pair_id)//") * SIN(VARVAL(gamma_"//bear_name//"_rad_"//RTOI(pair_id)//")) - VARVAL(vely_"//bear_name//"_rad_"//RTOI(pair_id)//") * COS(VARVAL(gamma_"//bear_name//"_rad_"//RTOI(pair_id)//")))/cl_"//bear_name//"_rad_"//RTOI(pair_id)//")"))
 !function = (eval("IF(time-0.0001/scale_second: 0.0, 0.0, scale_meter* (VARVAL(velx_"//bear_name//"_rad_"//RTOI(pair_id)//") * SIN(VARVAL(gamma_"//bear_name//"_rad_"//RTOI(pair_id)//")) - VARVAL(vely_"//bear_name//"_rad_"//RTOI(pair_id)//") * COS(VARVAL(gamma_"//bear_name//"_rad_"//RTOI(pair_id)//")))/cl_"//bear_name//"_rad_"//RTOI(pair_id)//")"))
 !function = (eval("scale_meter*VARVAL(scale_epsdot_"//bear_name//"_rad_"//RTOI(pair_id)//") * (VARVAL(velx_"//bear_name//"_rad_"//RTOI(pair_id)//") * SIN(VARVAL(gamma_"//bear_name//"_rad_"//RTOI(pair_id)//")) - VARVAL(vely_"//bear_name//"_rad_"//RTOI(pair_id)//") * COS(VARVAL(gamma_"//bear_name//"_rad_"//RTOI(pair_id)//")))/cl_"//bear_name//"_rad_"//RTOI(pair_id)))                 
!
! data_element create variable  &
!  variable_name = (eval("gammadot2_"//bear_name//"_rad_"//RTOI(pair_id)))  &
!  !function = (eval("IF(time-0.000001/scale_second: 0.0, 0.0, COS(VARVAL(gamma_"//bear_name//"_rad_"//RTOI(pair_id)//"))**2 * (-1.0*VARVAL(velx_"//bear_name//"_rad_"//RTOI(pair_id)//")*VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//") + VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//")*VARVAL(vely_"//bear_name//"_rad_"//RTOI(pair_id)//"))/VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//")**2)"))
!  function = (eval("IF(time-0.000001/scale_second: 0.0, 0.0, COS(VARVAL(gamma_"//bear_name//"_rad_"//RTOI(pair_id)//"))**2 * (-1.0*VARVAL(velx_"//bear_name//"_rad_"//RTOI(pair_id)//")*VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//") + VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//")*VARVAL(vely_"//bear_name//"_rad_"//RTOI(pair_id)//"))/MAX(1.0E-10, VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//")**2))"))
!  !function = (eval("COS(VARVAL(gamma_"//bear_name//"_rad_"//RTOI(pair_id)//"))**2 * (-1.0*VARVAL(velx_"//bear_name//"_rad_"//RTOI(pair_id)//")*VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//") + VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//")*VARVAL(vely_"//bear_name//"_rad_"//RTOI(pair_id)//"))/VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//")**2"))           
! !
! data_element create variable  &
!  variable_name = (eval("gammadotX_"//bear_name//"_rad_"//RTOI(pair_id)))  &
!  function = (eval("IF(time-0.000001/scale_second: 0.0, 0.0, (COS(VARVAL(gamma_"//bear_name//"_rad_"//RTOI(pair_id)//")) * VARVAL(velx_"//bear_name//"_rad_"//RTOI(pair_id)//") + SIN(VARVAL(gamma_"//bear_name//"_rad_"//RTOI(pair_id)//")) * VARVAL(vely_"//bear_name//"_rad_"//RTOI(pair_id)//"))/(ecc_"//bear_name//"_rad_"//RTOI(pair_id)//" + 0.0))")) 
!
data_element create variable  &
 variable_name = (eval("gammadot_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("(-1.0*VARVAL(velx_"//bear_name//"_rad_"//RTOI(pair_id)//")*VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//") + VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//")*VARVAL(vely_"//bear_name//"_rad_"//RTOI(pair_id)//"))/(VARVAL(disx_"//bear_name//"_rad_"//RTOI(pair_id)//")**2 + VARVAL(disy_"//bear_name//"_rad_"//RTOI(pair_id)//")**2 + ecc_0**2)"))           
!

!
! OMEGA
!            
data_element create variable  &
 variable_name = (eval("omega_"//bear_name//"_rad_"//RTOI(pair_id)))  &  ! [rad/s]
 function = (eval("1.0*WZ("//i_mrk//", "//j_mrk//", "//j_mrk//")/scale_second"))
!
! DOBA JEDNEHO OTOCENIA
if condition = ((eval(DB_EXISTS("tcyc"))) == 0.0)
   !
   data_element create variable  &
    variable_name = tcyc  &  ! [sec]
    function = "0.0" &
    initial_condition = 0.0 &
    comments = "sec"
   !
end   
!
! RADIAL FORCE
!
data_element create variable  &
 variable_name = (eval("Frad_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 !function = (eval("(-0.5*VARVAL(vis_rad_"//bear_name//"_rad_"//RTOI(pair_id)//")*L_"//bear_name//"_rad_"//RTOI(pair_id)//"**3*R_"//bear_name//"_rad_"//RTOI(pair_id)//")/cl_"//bear_name//"_rad_"//RTOI(pair_id)//"**2.0 * ((2.0*VARVAL(eps_asy_"//bear_name//"_rad_"//RTOI(pair_id)//")**2*(VARVAL(omega_"//bear_name//"_rad_"//RTOI(pair_id)//") - 2.0*VARVAL(gammadot_"//bear_name//"_rad_"//RTOI(pair_id)//"))/(1.0 - VARVAL(eps_asy_"//bear_name//"_rad_"//RTOI(pair_id)//")**2.0)**2.0) + (PI*VARVAL(epsdot_"//bear_name//"_rad_"//RTOI(pair_id)//")*(1.0 + 2.0*VARVAL(eps_asy_"//bear_name//"_rad_"//RTOI(pair_id)//")**2.0)/(1.0 - VARVAL(eps_asy_"//bear_name//"_rad_"//RTOI(pair_id)//")**2.0)**2.5))"))  
 function = (eval("Ocvirk_Journal_Radial_Force(vis_rad_"//bear_name//"_rad_"//RTOI(pair_id)//", L_"//bear_name//"_rad_"//RTOI(pair_id)//", R_"//bear_name//"_rad_"//RTOI(pair_id)//", cl_"//bear_name//"_rad_"//RTOI(pair_id)//", eps_asy_"//bear_name//"_rad_"//RTOI(pair_id)//", omega_"//bear_name//"_rad_"//RTOI(pair_id)//", gammadot_"//bear_name//"_rad_"//RTOI(pair_id)//", epsdot_"//bear_name//"_rad_"//RTOI(pair_id)//")"))
 !function = (eval("Ocvirk_Journal_Radial_Force(vis_rad_"//bear_name//"_rad_"//RTOI(pair_id)//", L_"//bear_name//"_rad_"//RTOI(pair_id)//", R_"//bear_name//"_rad_"//RTOI(pair_id)//", cl_"//bear_name//"_rad_"//RTOI(pair_id)//", eps_"//bear_name//"_rad_"//RTOI(pair_id)//", omega_"//bear_name//"_rad_"//RTOI(pair_id)//", gammadot_"//bear_name//"_rad_"//RTOI(pair_id)//", epsdot_"//bear_name//"_rad_"//RTOI(pair_id)//")"))
!
data_element create variable  &
 variable_name = (eval("Ftan_"//bear_name//"_rad_"//RTOI(pair_id)))  &                                                                                                                          
 function = (eval("(0.5*VARVAL(vis_rad_"//bear_name//"_rad_"//RTOI(pair_id)//")*L_"//bear_name//"_rad_"//RTOI(pair_id)//"**3*R_"//bear_name//"_rad_"//RTOI(pair_id)//")/cl_"//bear_name//"_rad_"//RTOI(pair_id)//"**2.0 * ((0.5*PI*VARVAL(eps_asy_"//bear_name//"_rad_"//RTOI(pair_id)//")*(VARVAL(omega_"//bear_name//"_rad_"//RTOI(pair_id)//") - 2.0*VARVAL(gammadot_"//bear_name//"_rad_"//RTOI(pair_id)//"))/(1.0 - VARVAL(eps_asy_"//bear_name//"_rad_"//RTOI(pair_id)//")**2.0)**1.5) + (4.0*VARVAL(eps_asy_"//bear_name//"_rad_"//RTOI(pair_id)//")*VARVAL(epsdot_"//bear_name//"_rad_"//RTOI(pair_id)//")/(1.0 - VARVAL(eps_asy_"//bear_name//"_rad_"//RTOI(pair_id)//")**2.0)**2.0))"))
!
data_element create variable  &                                                 ! [Nm]
 variable_name = (eval("Mfric_"//bear_name//"_rad_"//RTOI(pair_id)))  &
 function = (eval("-2.0*PI*VARVAL(vis_rad_"//bear_name//"_rad_"//RTOI(pair_id)//")*R_"//bear_name//"_rad_"//RTOI(pair_id)//"**3*L_"//bear_name//"_rad_"//RTOI(pair_id)//"*VARVAL(omega_"//bear_name//"_rad_"//RTOI(pair_id)//")/cl_"//bear_name//"_rad_"//RTOI(pair_id)))
!
! Asperity





!-------------------------------------------------------
!
!


if condition = ((eval(.MODEL_1.rad_bear_properties.values[33,(eval(pair_id))])) == 1.0)  ! Shear Heating Effects ON
   !
   ! OTEPLENI OLEJE V LOZISKU OKAMZITE
   data_element modify variable  &
    variable_name = (eval("dT_rad_"//bear_name//"_rad_"//RTOI(pair_id)))  &  ! [degC]
    function = (eval("ABS(VARVAL(omega_"//bear_name//"_rad_"//RTOI(pair_id)//")) * ABS(VARVAL(Mfric_"//bear_name//"_rad_"//RTOI(pair_id)//"))/(cap * VARVAL(oil_mass_flow_rad_"//bear_name//"_rad_"//RTOI(pair_id)//"))"))
   !
   part create equation differential_equation &
    differential_equation_name = (eval("Tdif_rad_"//bear_name//"_rad_"//RTOI(pair_id)))  &  ! [degC] 
    function = (eval("VARVAL(dT_rad_"//bear_name//"_rad_"//RTOI(pair_id)//")")) &
    initial_condition = 0.0  
   !
   ! OTEPLENI OLEJE V LOZISKU - PRUMEROVANE
   data_element modify variable  &
    variable_name = (eval("dTavg_rad_"//bear_name//"_rad_"//RTOI(pair_id)))  &  ! [degC]
    function = (eval("(DIF(Tdif_rad_"//bear_name//"_rad_"//RTOI(pair_id)//") - DELAY(DIF(Tdif_rad_"//bear_name//"_rad_"//RTOI(pair_id)//"), VARVAL(tcyc), 0))/VARVAL(tcyc)"))
    !function = "(DIF(Tdif_A1)-DELAY(DIF(Tdif_A1),VARVAL(tcyc),0))/VARVAL(tcyc)"
    
end 
 
 
!
return
 








