!-------------------------------------------------------
!----- Creation of Arrays Containing Wizzard Data ------
!-------------------------------------------------------
!
!-------------------------------------------------------
! Array Initiation
!-------------------------------------------------------
!
! Shaft ------------------------------------------------
!
data create array general &
 array_name = shaft_properties &
 size = 30 &
 numbers = & 
  0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
  0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
  0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 
!
! ------------------------------------------------------
!
!
! Compressor Wheel -------------------------------------
!
data create array general &
 array_name = comp_wheel_properties &      
 size = 1 &
 numbers = 0.0 
!
! ------------------------------------------------------
!
!
! Turbine Wheel ----------------------------------------
!
data create array general &
 array_name = turb_wheel_properties &      
 size = 1 &
 numbers = 0.0 
!
! ------------------------------------------------------
!
!
! Centre Housing ---------------------------------------
!
data create array general &
 array_name = cent_hsg_properties &      
 size = 10 &
 numbers = &
  0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 
! 
! ------------------------------------------------------
!
!
! Radial Bearings --------------------------------------
!
data_element create matrix full &
 matrix_name = (eval("rad_bear_properties")) &      
 row_count = 40 &
 column_count = 6 &                                                             ! Maximum number of radial bearings 
 values = 0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0
! 
! ------------------------------------------------------
!
! 
! Axial Bearings ---------------------------------------
!
data_element create matrix full &
 matrix_name = (eval("axi_bear_properties")) &      
 row_count = 35 &
 column_count = 6 &                                                             ! Maximum number of axial bearings 
 values = 0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
          0.0 , 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0
! 
! ------------------------------------------------------
!
!
! Test Rig ---------------------------------------------
!
data create array general &
 array_name = test_rig_properties &      
 size = 1 &
 numbers = 0.0
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Arrays Fill-Up
!-------------------------------------------------------
!
! Shaft ------------------------------------------------
!
! #1
(.MODEL_1.shaft_properties.values[1]) = &                                       ! Method: 1.0 - Rigid, 2.0 - Beam, 3.0 - FE Part  
 (eval(.gui.tc_wizard.page_1.cont_met.o_method.value))
!    
if condition  = (.gui.tc_wizard.page_1.cont_met.o_method.value == 1.0)          ! Rigid Shaft
   !
   ! #2 
   (.MODEL_1.shaft_properties.values[2]) = &    
    (eval(.gui.tc_wizard.page_2.cont_rigid_mat.o_method.value))    
   !
   ! #3
   (.MODEL_1.shaft_properties.values[3]) = &
    (eval(.gui.tc_wizard.page_2.cont_rigid_spec.f_length.value))
   !
   ! #4
   (.MODEL_1.shaft_properties.values[4]) = &
    (eval(.gui.tc_wizard.page_2.cont_rigid_spec.f_dia.value))
   !
   ! #5
   (.MODEL_1.shaft_properties.values[5]) = &
    (eval(.gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_mass.value))
   !
   ! #6
   (.MODEL_1.shaft_properties.values[6]) = &
    (eval(.gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_cm.value))
   !
   ! #7
   (.MODEL_1.shaft_properties.values[7]) = &
    (eval(.gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_ixx.value))
   !
   ! #8
   (.MODEL_1.shaft_properties.values[8]) = &
    (eval(.gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_iyy.value))
   !
   ! #9
   (.MODEL_1.shaft_properties.values[9]) = &
    (eval(.gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_izz.value))
   !
   ! #10
   (.MODEL_1.shaft_properties.values[10]) = &
    (eval(.gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_ixy.value))
   !
   ! #11
   (.MODEL_1.shaft_properties.values[11]) = &
    (eval(.gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_iyz.value))
   !
   ! #12                                                           
   (.MODEL_1.shaft_properties.values[12]) = &
    (eval(.gui.tc_wizard.page_2.cont_rigid_mat.c_user.f_ixz.value))
   !
   ! #13
   (.MODEL_1.shaft_properties.values[13]) = &
    (eval(.gui.tc_wizard.page_2.cont_rigid_mat.c_density.f_density.value))
   !
   ! #14
   (.MODEL_1.shaft_properties.values[14]) = &
    (eval(.gui.tc_wizard.page_2.cont_rigid_mat.c_user.flag_off_diagonal.value))
   !
elseif condition = (.gui.tc_wizard.page_1.cont_met.o_method.value == 2.0)       ! Beam Shaft   
   !   
   var set var = tmp_int int = (eval(RTOI(.gui.tc_wizard.page_2.cont_beam.displayed_rows)))
   !
   variable set variable = shaft_seg_dia &
    real = (eval(TABLE_GET_CELLS(.gui.tc_wizard.page_2.cont_beam.table_specs, 1, (eval(tmp_int)), 1, 1, "zero", 0))) &
    units = mm
   !
   variable set variable = shaft_seg_length &
    real = (eval(TABLE_GET_CELLS(.gui.tc_wizard.page_2.cont_beam.table_specs, 1, (eval(tmp_int)), 2, 2, "zero", 0))) &
    units = mm
   !
   variable set variable = shaft_seg_count &
    real = (eval(TABLE_GET_CELLS(.gui.tc_wizard.page_2.cont_beam.table_specs, 1, (eval(tmp_int)), 3, 3, "zero", 0)))
   !
   var set var = tmp_real real = 0.0
   var set var = counter int = 1
   var set var = shaft_div_length real = 0.0 units = mm
   var set var = shaft_div_cum_length real = 0.0 units = mm
   var set var = shaft_div_dia real = 0.0 units = mm
   !
   for variable_name = i start_value = 1 end_value = (eval(tmp_int))
      !
      for variable_name = j start_value = 1 end_value = (eval(shaft_seg_count[i]))
         !
         shaft_div_length[eval(counter)] = (eval(shaft_seg_length[eval(i)]/shaft_seg_count[i]))
         shaft_div_dia[eval(counter)] = (eval(shaft_seg_dia[eval(i)]))
         !
         var set var = tmp_real real = (eval(tmp_real + shaft_div_length[eval(counter)]))
         shaft_div_cum_length[eval(counter)] = (eval(tmp_real))                  
         !
         var set var = counter int = (eval(counter + 1))     
         !
      end
   !
   end
   !   
   ! #3
   (.MODEL_1.shaft_properties.values[3]) = &
    (eval(tmp_real))
   !
   ! #13
   (.MODEL_1.shaft_properties.values[13]) = &
    (eval(.gui.tc_wizard.page_2.cont_beam.f_density.value))
   !
   ! #25
   (.MODEL_1.shaft_properties.values[25]) = &
    (eval(counter - 1))
   !
   ! #26
   (.MODEL_1.shaft_properties.values[26]) = &
    (eval(.gui.tc_wizard.page_2.cont_beam.f_young.value))
   ! 
   ! #27
   (.MODEL_1.shaft_properties.values[27]) = &
    (eval(.gui.tc_wizard.page_2.cont_beam.f_poisson.value))
   !
   ! #28
   (.MODEL_1.shaft_properties.values[28]) = &
    (eval(.gui.tc_wizard.page_2.cont_beam.f_damp.value))
   ! 
   var del var = tmp_int 
   var del var = tmp_real
   var del var = counter
   var del var = shaft_seg_dia
   var del var = shaft_seg_length
   var del var = shaft_seg_count   
   !
elseif condition = (.gui.tc_wizard.page_1.cont_met.o_method.value == 3.0)       ! FE Shaft 
   !
   ! #3
   (.MODEL_1.shaft_properties.values[3]) = &
    (eval(.gui.tc_wizard.page_2.cont_fe.f_length.value))   
   !
   ! #20
   (.MODEL_1.shaft_properties.values[20]) = &
    (eval(.gui.tc_wizard.page_2.cont_fe.f_cw_marker.value_real))  
   !
   ! #21
   (.MODEL_1.shaft_properties.values[21]) = &
    (eval(.gui.tc_wizard.page_2.cont_fe.f_tw_marker.value_real))  
   ! 
   variable set variable_name = STR_shaft_name & 
    string_value = (eval(.gui.tc_wizard.page_1.cont_met.f_fe_part.value_str))
   ! 
   variable set variable_name = STR_shaft_cw_marker_name & 
    string_value = (eval(.gui.tc_wizard.page_2.cont_fe.f_cw_marker.value_str))  
   !
   variable set variable_name = STR_shaft_tw_marker_name & 
    string_value = (eval(.gui.tc_wizard.page_2.cont_fe.f_tw_marker.value_str))  
   ! 
   ! Radial Bearings
   for variable_name=i start_value=1 end_value=(eval(.gui.tc_wizard.page_5.displayed_tabs))
      !
      var set var = tmp_str1 str = (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//RTOI(i)//".f_shaft_part.value_str"))
      var set var = tmp_str2 str = (eval(USER_STRING(eval(tmp_str1))))
      var set var = tmp_int int = (eval(STR_LENGTH(tmp_str2)))
      var set var = tmp_str1 str =  (eval(STR_SUBSTR((eval(tmp_str2)), 2, (eval(tmp_int-2)))))
      !
      variable create variable_name = (eval("STR_rad_bear_"//RTOI(i)//"_shaft_marker")) &
       string_value = (eval(tmp_str1))      
      !
      var del var = tmp_str1
      var del var = tmp_str2
      var del var = tmp_int
      ! 
   end         
   !
   ! Axial Bearings
   for variable_name=i start_value=1 end_value=(eval(.gui.tc_wizard.page_6.displayed_tabs))
      ! 
      var set var = tmp_str1 str = (eval(".gui.tc_wizard.page_6.tab_bear.cont_bear_prop_"//RTOI(i)//".f_shaft_part.value_str"))
      var set var = tmp_str2 str = (eval(USER_STRING(eval(tmp_str1))))
      var set var = tmp_int int = (eval(STR_LENGTH(tmp_str2)))
      var set var = tmp_str1 str =  (eval(STR_SUBSTR((eval(tmp_str2)), 2, (eval(tmp_int-2)))))
      !
      variable create variable_name = (eval("STR_axi_bear_"//RTOI(i)//"_shaft_marker")) &
       string_value = (eval(tmp_str1))      
      !
      var del var = tmp_str1
      var del var = tmp_str2
      var del var = tmp_int
      ! 
   end          
   ! 
end
!
! ------------------------------------------------------
!
!
! Compressor Wheel -------------------------------------
!
data modify array general &
   array_name = comp_wheel_properties &
   size = 20 &
   numbers   = &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.cont_mass.o_method.value)), & 
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.cont_mass.c_user.f_mass.value)), &     
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.cont_mass.c_user.f_cm.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.cont_mass.c_user.f_ixx.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.cont_mass.c_user.f_iyy.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.cont_mass.c_user.f_izz.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.cont_mass.c_user.f_ixy.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.cont_mass.c_user.f_iyz.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.cont_mass.c_user.f_ixz.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.cont_mass.c_density.f_density.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.cont_mass.c_user.flag_off_diagonal.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.c_unbalance.f_un1_pos.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.c_unbalance.f_un1_mass.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.c_unbalance.f_un2_pos.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.c_unbalance.f_un2_mass.value)), &
   0.0, & 
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.cont_mass.c_user.f_dia.value)), &
   0.0, & 
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_comp_wheel.c_unbalance.f_eddy_pos.value)), &
   0.0
!
! ------------------------------------------------------
!
!
! Turbine Wheel ----------------------------------------
data modify array general &
   array_name = turb_wheel_properties &
   size = 20 &
   numbers   = & 
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.cont_mass.o_method.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.cont_mass.c_user.f_mass.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.cont_mass.c_user.f_cm.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.cont_mass.c_user.f_ixx.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.cont_mass.c_user.f_iyy.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.cont_mass.c_user.f_izz.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.cont_mass.c_user.f_ixy.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.cont_mass.c_user.f_iyz.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.cont_mass.c_user.f_ixz.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.cont_mass.c_density.f_density.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.cont_mass.c_user.flag_off_diagonal.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.c_unbalance.f_un1_pos.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.c_unbalance.f_un1_mass.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.c_unbalance.f_un2_pos.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.c_unbalance.f_un2_mass.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.c_unbalance.f_un_phase.value)), &
   (eval(.gui.tc_wizard.page_3.tabs_wheels.tab_turb_wheel.cont_mass.c_user.f_dia.value)), & 
   0.0, 0.0, 0.0
! 
! ------------------------------------------------------
!
!
! Centre Housing ---------------------------------------
!
! #1
(.MODEL_1.cent_hsg_properties.values[1]) = &                                    ! Method: 1.0 - Ground, 2.0 - Part, 3.0 - FE Part          
 (eval(.gui.tc_wizard.page_4.cont_centr.o_method.value))     
!
if condition  = (.gui.tc_wizard.page_4.cont_centr.o_method.value == 1.0)        ! Rigid Centre Housing
   !
   variable set variable_name = STR_hsg_name & 
    string_value = (eval(model_name//".housing"))   
   !
elseif condition  = (.gui.tc_wizard.page_4.cont_centr.o_method.value == 2.0)          ! Part Centre Housing
   !
   variable set variable_name = STR_hsg_name & 
    string_value = (eval(.gui.tc_wizard.page_4.cont_centr.f_part.value_str))   
   !
elseif condition  = (.gui.tc_wizard.page_4.cont_centr.o_method.value == 3.0)          ! FE Part Centre Housing
   !
   variable set variable_name = STR_hsg_name & 
    string_value = (eval(.gui.tc_wizard.page_4.cont_centr.f_fe_part.value_str))   
   !
   ! Radial Bearings
   for variable_name=i start_value=1 end_value=(eval(.gui.tc_wizard.page_5.displayed_tabs))
      !
      var set var = tmp_str1 str = (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//RTOI(i)//".f_hsg_part.value_str"))
      var set var = tmp_str2 str = (eval(USER_STRING(eval(tmp_str1))))
      var set var = tmp_int int = (eval(STR_LENGTH(tmp_str2)))
      var set var = tmp_str1 str =  (eval(STR_SUBSTR((eval(tmp_str2)), 2, (eval(tmp_int-2)))))
      !
      ! ked dam totok ako "set", tak sa mi nevypina wizzard...
      variable create variable_name = (eval("STR_rad_bear_"//RTOI(i)//"_hsg_marker")) &
       string_value = (eval(tmp_str1))      
      !
      var del var = tmp_str1
      var del var = tmp_str2
      var del var = tmp_int
      ! 
   end    
   !
   ! Axial Bearings
   for variable_name=i start_value=1 end_value=(eval(.gui.tc_wizard.page_6.displayed_tabs))
      ! 
      var set var = tmp_str1 str = (eval(".gui.tc_wizard.page_6.tab_bear.cont_bear_prop_"//RTOI(i)//".f_hsg_part.value_str"))
      var set var = tmp_str2 str = (eval(USER_STRING(eval(tmp_str1))))
      var set var = tmp_int int = (eval(STR_LENGTH(tmp_str2)))
      var set var = tmp_str1 str =  (eval(STR_SUBSTR((eval(tmp_str2)), 2, (eval(tmp_int-2)))))
      !
      variable create variable_name = (eval("STR_axi_bear_"//RTOI(i)//"_hsg_marker")) &
       string_value = (eval(tmp_str1))      
      !
      var del var = tmp_str1
      var del var = tmp_str2
      var del var = tmp_int
      ! 
   end          
   !   
end
!
! ------------------------------------------------------
!
!return
!
! Radial Bearings --------------------------------------
!
for variable_name=i start_value=1 end_value=(eval(.gui.tc_wizard.page_5.displayed_tabs))
   !
   ! 40 - number of rows in "rad_bear_properties" matrix
   !
   ! !!! dosadzanie do matice .MODEL_1.rad_bear_properties.values je aj v makre _dummy_parts_build.cmd !!!
   !
   ! #1
   (.MODEL_1.rad_bear_properties.values[(eval(1+40*(i-1)))]) = &
    (eval(.gui.tc_wizard.page_5.displayed_tabs))
   !
   ! #2
   (.MODEL_1.rad_bear_properties.values[(eval(2+40*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//RTOI(i)//".o_method.value"))                             
   !
   ! #3
   (.MODEL_1.rad_bear_properties.values[(eval(3+40*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//RTOI(i)//".f_ground.value"))
   !
   ! #4
   (.MODEL_1.rad_bear_properties.values[(eval(4+40*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//RTOI(i)//".f_hsg_part.value_real"))
   !
   ! #5
   (.MODEL_1.rad_bear_properties.values[(eval(5+40*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//RTOI(i)//".c_stiff.l_stiff_1.value"))
   !
   ! #6
   (.MODEL_1.rad_bear_properties.values[(eval(6+40*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//RTOI(i)//".c_stiff.l_damp_1.value"))
   !
   ! #7
   (.MODEL_1.rad_bear_properties.values[(eval(7+40*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//RTOI(i)//".c_stiff.l_stiff_2.value"))
   !
   ! #8
   (.MODEL_1.rad_bear_properties.values[(eval(8+40*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//RTOI(i)//".c_stiff.l_damp_2.value"))
   !
   ! #12
   (.MODEL_1.rad_bear_properties.values[(eval(12+40*(i-1)))]) = &                 
    (eval(".gui.oil_properties.f_vogel_a.value"))
   ! 
   ! #13
   (.MODEL_1.rad_bear_properties.values[(eval(13+40*(i-1)))]) = &                 
    (eval(".gui.oil_properties.f_vogel_b.value"))
   !
   ! #14
   (.MODEL_1.rad_bear_properties.values[(eval(14+40*(i-1)))]) = &                 
    (eval(".gui.oil_properties.f_vogel_c.value"))
   !  
   ! #15
   (.MODEL_1.rad_bear_properties.values[(eval(15+40*(i-1)))]) = &                 
    (eval(".gui.oil_properties.f_temp.value"))
   !
   ! #16
   (.MODEL_1.rad_bear_properties.values[(eval(16+40*(i-1)))]) = &                 
    (eval(".gui.oil_properties.f_heat_cap.value"))
   !
   ! #17
   (.MODEL_1.rad_bear_properties.values[(eval(17+40*(i-1)))]) = &                 
    (eval(".gui.oil_properties.f_vis_hths.value"))
   !
   ! #20
   (.MODEL_1.rad_bear_properties.values[(eval(20+40*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//RTOI(i)//".c_ocvirk.f_radius_i.value"))
   ! 
   ! #21
   (.MODEL_1.rad_bear_properties.values[(eval(21+40*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//RTOI(i)//".c_ocvirk.f_width_i.value"))
   ! 
   ! #22
   (.MODEL_1.rad_bear_properties.values[(eval(22+40*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//RTOI(i)//".c_ocvirk.f_clear_i.value"))
   !
   ! #23
   (.MODEL_1.rad_bear_properties.values[(eval(23+40*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//RTOI(i)//".c_ocvirk.f_radius_o.value"))
   ! 
   ! #24
   (.MODEL_1.rad_bear_properties.values[(eval(24+40*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//RTOI(i)//".c_ocvirk.f_width_o.value"))
   ! 
   ! #25
   (.MODEL_1.rad_bear_properties.values[(eval(25+40*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//RTOI(i)//".c_ocvirk.f_clear_o.value"))
   !
   ! #26
   (.MODEL_1.rad_bear_properties.values[(eval(26+40*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//RTOI(i)//".c_ocvirk.flag_rotating_ring.value"))
   !
   ! #27
   (.MODEL_1.rad_bear_properties.values[(eval(27+40*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//RTOI(i)//".c_ocvirk.f_mass.value"))
   !
   ! #28
   (.MODEL_1.rad_bear_properties.values[(eval(28+40*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//RTOI(i)//".c_ocvirk.f_ixx.value"))
   !
   ! #29
   (.MODEL_1.rad_bear_properties.values[(eval(29+40*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//RTOI(i)//".c_ocvirk.f_iyy.value"))
   !
   ! #30
   (.MODEL_1.rad_bear_properties.values[(eval(30+40*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_5.tab_bear.cont_bear_prop_"//RTOI(i)//".c_ocvirk.f_izz.value"))
   !
   ! #33
   (.MODEL_1.rad_bear_properties.values[(eval(33+40*(i-1)))]) = &                 
    (eval(".gui.oil_properties.flag_shear_heat.value"))
   ! 
   ! #34
   (.MODEL_1.rad_bear_properties.values[(eval(34+40*(i-1)))]) = &                 
    (eval(".gui.oil_properties.f_dens_0.value"))
   ! 
   ! #35
   (.MODEL_1.rad_bear_properties.values[(eval(35+40*(i-1)))]) = &                 
    (eval(".gui.oil_properties.f_temp_0.value"))
   ! 
   ! #36
   (.MODEL_1.rad_bear_properties.values[(eval(36+40*(i-1)))]) = &                 
    (eval(".gui.oil_properties.f_alpha.value"))
   ! 
   ! #37
   (.MODEL_1.rad_bear_properties.values[(eval(37+40*(i-1)))]) = &                 
    (eval(".gui.oil_properties.f_vol_flow.value"))
   ! 
end 
!
! ------------------------------------------------------
!                    
!
! Axial Bearings --------------------------------------
!
for variable_name=i start_value=1 end_value=(eval(.gui.tc_wizard.page_6.displayed_tabs))
   !
   ! 35 - number of rows in "axi_bear_properties" matrix
   !
   ! #1                                          
   (.MODEL_1.axi_bear_properties.values[(eval(1+35*(i-1)))]) = &
    (eval(.gui.tc_wizard.page_6.displayed_tabs))
   !
   ! #2
   (.MODEL_1.axi_bear_properties.values[(eval(2+35*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_6.tab_bear.cont_bear_prop_"//RTOI(i)//".o_method.value"))                            
   !
   ! #3
   (.MODEL_1.axi_bear_properties.values[(eval(3+35*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_6.tab_bear.cont_bear_prop_"//RTOI(i)//".f_ground.value"))
   !
   ! #4
   (.MODEL_1.axi_bear_properties.values[(eval(4+35*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_6.tab_bear.cont_bear_prop_"//RTOI(i)//".f_hsg_part.value_real")) 
   !
   ! #11
   (.MODEL_1.axi_bear_properties.values[(eval(11+35*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_6.tab_bear.cont_bear_prop_"//RTOI(i)//".c_anal.f_num_pads.value"))
   !
   ! #12
   (.MODEL_1.axi_bear_properties.values[(eval(12+35*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_6.tab_bear.cont_bear_prop_"//RTOI(i)//".c_anal.f_dia_outer.value"))
   !
   ! #13
   (.MODEL_1.axi_bear_properties.values[(eval(13+35*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_6.tab_bear.cont_bear_prop_"//RTOI(i)//".c_anal.f_dia_inner.value"))
   !
   ! #14                                          
   (.MODEL_1.axi_bear_properties.values[(eval(14+35*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_6.tab_bear.cont_bear_prop_"//RTOI(i)//".c_anal.f_length.value"))
   !
   ! #15
   (.MODEL_1.axi_bear_properties.values[(eval(15+35*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_6.tab_bear.cont_bear_prop_"//RTOI(i)//".c_anal.f_h0.value"))
   !
   ! #16
   (.MODEL_1.axi_bear_properties.values[(eval(16+35*(i-1)))]) = &                 
    (eval(".gui.tc_wizard.page_6.tab_bear.cont_bear_prop_"//RTOI(i)//".c_anal.f_h1.value"))
   !
   ! #21
   (.MODEL_1.axi_bear_properties.values[(eval(21+35*(i-1)))]) = &                 
    (eval(".gui.oil_properties.f_vogel_a.value"))
   !
   ! #22
   (.MODEL_1.axi_bear_properties.values[(eval(22+35*(i-1)))]) = &                 
    (eval(".gui.oil_properties.f_vogel_b.value")) 
   !
   ! #23
   (.MODEL_1.axi_bear_properties.values[(eval(23+35*(i-1)))]) = &                 
    (eval(".gui.oil_properties.f_vogel_c.value"))
   !     
   ! #24
   (.MODEL_1.axi_bear_properties.values[(eval(24+35*(i-1)))]) = &                 
    (eval(".gui.oil_properties.f_temp.value"))  
   !
   ! #25
   (.MODEL_1.axi_bear_properties.values[(eval(25+35*(i-1)))]) = &                 
    (eval(".gui.oil_properties.f_heat_cap.value")) 
   !
   ! #26
   (.MODEL_1.axi_bear_properties.values[(eval(26+35*(i-1)))]) = &                 
    (eval(".gui.oil_properties.f_vis_hths.value")) 
   !
   ! #27
   (.MODEL_1.axi_bear_properties.values[(eval(27+35*(i-1)))]) = &                 
    (eval(".gui.oil_properties.flag_shear_heat.value")) 
   !
   ! #28
   (.MODEL_1.axi_bear_properties.values[(eval(28+35*(i-1)))]) = &                 
    (eval(".gui.oil_properties.f_dens_0.value")) 
   !
   ! #29
   (.MODEL_1.axi_bear_properties.values[(eval(29+35*(i-1)))]) = &                 
    (eval(".gui.oil_properties.f_temp_0.value")) 
   !
   ! #30
   (.MODEL_1.axi_bear_properties.values[(eval(30+35*(i-1)))]) = &                 
    (eval(".gui.oil_properties.f_alpha.value")) 
   !
   ! #31
   (.MODEL_1.axi_bear_properties.values[(eval(31+35*(i-1)))]) = &                 
    (eval(".gui.oil_properties.f_vol_flow.value")) 
   !
end 
!
! ------------------------------------------------------ 
!
!
! Test Rig ---------------------------------------------
data modify array general &
   array_name = test_rig_properties &
   size = 33 &
   numbers   = & 
   (eval(.gui.tc_wizard.page_7.cont_connect.f_num.value)), &
   (eval(.gui.tc_wizard.page_7.cont_spec.o_dir.value)), &
   (eval(.gui.tc_wizard.page_7.cont_connect.c_stiff.f_stiff_1.value)), &
   (eval(.gui.tc_wizard.page_7.cont_connect.c_stiff.f_stiff_2.value)), &
   (eval(.gui.tc_wizard.page_7.cont_connect.c_stiff.f_stiff_3.value)), &
   (eval(.gui.tc_wizard.page_7.cont_connect.c_stiff.f_stiff_4.value)), &
   (eval(.gui.tc_wizard.page_7.cont_connect.c_stiff.f_stiff_5.value)), &
   (eval(.gui.tc_wizard.page_7.cont_connect.c_damp.f_damp_1.value)), &
   (eval(.gui.tc_wizard.page_7.cont_connect.c_damp.f_damp_2.value)), &
   (eval(.gui.tc_wizard.page_7.cont_connect.c_damp.f_damp_3.value)), &
   (eval(.gui.tc_wizard.page_7.cont_connect.c_damp.f_damp_4.value)), &
   (eval(.gui.tc_wizard.page_7.cont_connect.c_damp.f_damp_5.value)), &
   (eval(.gui.tc_wizard.page_7.cont_connect.c_inertia.f_inertia_1.value)), &
   (eval(.gui.tc_wizard.page_7.cont_connect.c_inertia.f_inertia_2.value)), &
   (eval(.gui.tc_wizard.page_7.cont_connect.c_inertia.f_inertia_3.value)), &
   (eval(.gui.tc_wizard.page_7.cont_connect.c_inertia.f_inertia_4.value)), &
   (eval(.gui.tc_wizard.page_8.cont_speed.o_method.value)), &
   (eval(.gui.tc_wizard.page_8.cont_speed.c_const_speed.f_speed.value)), &
   (eval(.gui.tc_wizard.page_8.cont_speed.c_ramp.f_init_speed.value)), &
   (eval(.gui.tc_wizard.page_8.cont_speed.c_ramp.f_end_speed.value)), &
   (eval(.gui.tc_wizard.page_8.cont_speed.c_ramp.f_end_time.value)), &
   (eval(.gui.tc_wizard.page_8.cont_speed.c_step.f_speed_0.value)), &
   (eval(.gui.tc_wizard.page_8.cont_speed.c_step.f_speed_1.value)), &
   (eval(.gui.tc_wizard.page_8.cont_speed.c_step.f_time_0.value)), &
   (eval(.gui.tc_wizard.page_8.cont_speed.c_step.f_time_1.value)), &
   (eval(.gui.tc_wizard.page_8.cont_speed.c_spline.f_spline.value_real)), &
   (eval(.gui.tc_wizard.page_8.cont_speed.c_spline.f_init_speed.value)), &
   0.0, &
   (eval(.gui.tc_wizard.page_9.cont_spec.flag_thrust_force.value)), &
   (eval(.gui.tc_wizard.page_9.cont_spec.o_dir.value)), &
   (eval(.gui.tc_wizard.page_9.cont_spec.o_def.value)), &
   (eval(.gui.tc_wizard.page_9.cont_def.f_const.value)), &
   (eval(.gui.tc_wizard.page_9.cont_def.f_spline.value_real))
!
if condition = (test_rig_properties.values[17] == 1.0)                          ! Constant Speed
   !
   .MODEL_1.test_rig_properties.values[28] = (eval(.MODEL_1.test_rig_properties.values[18]))
   !
elseif condition = (test_rig_properties.values[17] == 2.0)                      ! Ramp
   !
   .MODEL_1.test_rig_properties.values[28] = (eval(.MODEL_1.test_rig_properties.values[19]))
   !
elseif condition = (test_rig_properties.values[17] == 3.0)                      ! Step
   !
   .MODEL_1.test_rig_properties.values[28] = (eval(.MODEL_1.test_rig_properties.values[22]))   
   !
elseif condition = (test_rig_properties.values[17] == 4.0)                        ! Spline
   !
   .MODEL_1.test_rig_properties.values[28] = (eval(.MODEL_1.test_rig_properties.values[27]))
   !
   variable set variable_name = STR_spline_speed &          
    string_value = (eval(eval(.gui.tc_wizard.page_8.cont_speed.c_spline.f_spline.value_str)))   
   ! 
end    
!
! ------------------------------------------------------
!
!
return
