!-------------------------------------------------------
!------------------- Measures Build --------------------
!-------------------------------------------------------
!          
! 
if condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 1.0)          ! Central Housing as Ground
   !
   variable create variable_name = hsg_name string_value = "housing"
   !
elseif condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 2.0)      ! Central Housing as Part
   !
   variable set variable_name = hsg_name string_value = (eval(.MODEL_1.STR_hsg_name))
   !
elseif condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 3.0)      ! Central Housing as FE Part
   !
   variable set variable_name = hsg_name string_value = (eval(.MODEL_1.STR_hsg_name))   
   !
end  



!.MODEL_1.dummy_hsg_axi_1.cm


! REQUEST DYNO REVS 
output_control create request  &
 request_name = (eval(model_name//".REQ_dyno_revs"))  &
 component_names = "","rev_rpm","rev_rads","","","","",""  &   
 component_units = "no_units","no_units","no_units","no_units","no_units","no_units","no_units","no_units"  & 
 results_name = dyno_revs  &
 f1 = "0.0" &
 f2 = (eval("60*WZ("//model_name//".dyno_1.marker_cm, "//model_name//".ground.marker_dyno_1, "//model_name//".ground.marker_dyno_1)/(2*pi)")) &
 f3 = (eval("WZ("//model_name//".dyno_1.marker_cm, "//model_name//".ground.marker_dyno_1, "//model_name//".ground.marker_dyno_1)")) &
 f4 = "0.0" & 
 f5 = "0.0" & 
 f6 = "0.0" &
 f7 = "0.0" &
 f8 = "0.0" 
!
! REQUEST DYNO POWER 
output_control create request  &
 request_name = (eval(model_name//".REQ_dyno_power"))  &
 component_names = "","Moment_Nm","Power_kW","","","","",""  &   
 component_units = "no_units","no_units","no_units","no_units","no_units","no_units","no_units","no_units"  & 
 results_name = dyno_power  &
 f1 = "0.0" &
 f2 = (eval("0.001*MOTION("//model_name//".dyno_motion, 0, 8, "//model_name//".ground.marker_dyno_1)")) & 
 f3 = (eval("0.000001*MOTION("//model_name//".dyno_motion, 0, 8, "//model_name//".ground.marker_dyno_1)*WZ("//model_name//".dyno_1.marker_cm, "//model_name//".ground.marker_dyno_1, "//model_name//".ground.marker_dyno_1)")) &
 f4 = "0.0" &
 f5 = "0.0" & 
 f6 = "0.0" &
 f7 = "0.0" &
 f8 = "0.0" 
!
! REQUEST DYNO angles 
output_control create request  &
 request_name = (eval(model_name//".REQ_dyno_angles"))  &
 component_names = "","angle_deg","angle_rev","","","","",""  &   
 component_units = "no_units","no_units","no_units","no_units","no_units","no_units","no_units","no_units"  & 
 results_name = dyno_angles  &
 f1 = "0.0" &
 f2 = (eval("360*AZ("//model_name//".dyno_1.marker_cm, "//model_name//".ground.marker_dyno_1)/(2*pi)")) & 
 f3 = (eval("AZ("//model_name//".dyno_1.marker_cm, "//model_name//".ground.marker_dyno_1)/(2*pi)")) &
 f4 = "0.0" &
 f5 = "0.0" & 
 f6 = "0.0" &
 f7 = "0.0" &
 f8 = "0.0"
!

!var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("second")))
var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("second")/UNITS_CONVERSION_FACTOR("meter")**2))
! REQUEST Oil Properties
output_control create request  &
 request_name = (eval(model_name//".REQ_oil_properties"))  &
 component_names = "","","Inlet_Temp_degC","Heat_Capacity_J_kg_degC","","Vis_HTHS_Pas","",""  &   
 component_units = "no_units","no_units","no_units","no_units","no_units","no_units","no_units","no_units"  & 
 results_name = oil_properties  &
 f1 = "0.0" &
 f2 = "0.0" & 
 f3 = (eval(.MODEL_1.rad_bear_properties.values[15,1])) &
 f4 = (eval(.MODEL_1.rad_bear_properties.values[16,1])) &
 f5 = "0.0" & 
 f6 = (eval(tmp*.MODEL_1.rad_bear_properties.values[17,1])) &
 f7 = "0.0" &
 f8 = "0.0"
!
var del var = tmp
!
! REQUEST Rotor Locus
output_control create request  &
 request_name = (eval(model_name//".REQ_rotor_locus"))  &
 component_names = "","DX","DY","","","","",""  &   
 component_units = "no_units","no_units","no_units","no_units","no_units","no_units","no_units","no_units"  & 
 results_name = rotor_locus &
 f1 = "0.0" &
 f2 = (eval("DX("//model_name//".comp_wheel.marker_eddy_sensor, "//model_name//"."//hsg_name//".LBRF, "//model_name//"."//hsg_name//".LBRF)")) &
 f3 = (eval("DY("//model_name//".comp_wheel.marker_eddy_sensor, "//model_name//"."//hsg_name//".LBRF, "//model_name//"."//hsg_name//".LBRF)")) &
 f4 = "0.0" &
 f5 = "0.0" & 
 f6 = "0.0" &
 f7 = "0.0" &
 f8 = "0.0"
!
! REQUEST Rotor Locus
output_control create request  &
 request_name = (eval(model_name//".REQ_unbalance_mass_forces"))  &
 component_names = "","Comp_Nose","Comp_Bckdsc","", "Turb_Nose","Turb_Bckdsc","",""  &   
 component_units = "no_units","no_units","no_units","no_units","no_units","no_units","no_units","no_units"  & 
 results_name = rotor_unbalance_mass_forces &
 f1 = "0.0" &
 f2 = (eval("SQRT(JPRIM("//model_name//".JOINT_CW_UM_nose, 0, 2, "//model_name//"."//hsg_name//".LBRF)**2+JPRIM("//model_name//".JOINT_CW_UM_nose, 0, 3, "//model_name//"."//hsg_name//".LBRF)**2)")) &
 f3 = (eval("SQRT(JPRIM("//model_name//".JOINT_CW_UM_back, 0, 2, "//model_name//"."//hsg_name//".LBRF)**2+JPRIM("//model_name//".JOINT_CW_UM_back, 0, 3, "//model_name//"."//hsg_name//".LBRF)**2)")) &
 f4 = "0.0" &
 f5 = (eval("SQRT(JPRIM("//model_name//".JOINT_TW_UM_nose, 0, 2, "//model_name//"."//hsg_name//".LBRF)**2+JPRIM("//model_name//".JOINT_TW_UM_nose, 0, 3, "//model_name//"."//hsg_name//".LBRF)**2)")) &
 f6 = (eval("SQRT(JPRIM("//model_name//".JOINT_TW_UM_back, 0, 2, "//model_name//"."//hsg_name//".LBRF)**2+JPRIM("//model_name//".JOINT_TW_UM_back, 0, 3, "//model_name//"."//hsg_name//".LBRF)**2)")) & 
 f7 = "0.0" &
 f8 = "0.0"







for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.rad_bear_properties.values[1,1]))
   !
   if condition = ((eval(.MODEL_1.rad_bear_properties.values[2,(eval(i))])) == 3.0)  ! Radial Bearing Solved by Ocvirk Solution
      !
      output_control create request  &
       request_name = (eval(model_name//".REQ_rad_bear_inner_"//RTOI(i)))  &
       !component_names = "Ecc", "Dot_Ecc", "Gamma_rad","Dot_Gamma_rad_s", "Fmag_N","Fric_Torque_Nm","Delta_Temp_degC","Vis_Out_Pas"  &   
       component_names = "VIS", "EPS","EPSDOT","GAMMA","GAMMADOT","OMEGA","M","FTAN"  &
       results_name = (eval("REQ_rad_bear_inner_"//RTOI(i)))  &       
       user_function = (eval(i)) &
       routine = "myforce::reqsub"
      !
      output_control create request  &
       request_name = (eval(model_name//".REQ_rad_bear_outer_"//RTOI(i)))  &
       !component_names = "Ecc", "Dot_Ecc", "Gamma_rad","Dot_Gamma_rad_s", "Fmag_N","Fric_Torque_Nm","Delta_Temp_degC","Vis_Out_Pas"  &
       component_names = "VIS", "EPS","EPSDOT","GAMMA","GAMMADOT","OMEGA","M","FTAN"  &
       results_name = (eval("REQ_rad_bear_outer_"//RTOI(i)))  &       
       user_function = (eval(i+6)) &
       routine = "myforce::reqsub"
      !
   end
   !
   
   
   
!    measure create function measure = (eval(model_name//".MEAS_DX_RAD_"//RTOI(i))) &
!     function = (eval("DX("//model_name//".dummy_shaft_rad_"//RTOI(i)//".marker_dummy_shaft, "//model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_dummy_hsg, "//model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_dummy_hsg)")) &
!     units = length &
!     create_measure_display = no
!    !    
!    measure create function measure = (eval(model_name//".MEAS_DY_RAD_"//RTOI(i))) &
!     function = (eval("DY("//model_name//".dummy_shaft_rad_"//RTOI(i)//".marker_dummy_shaft, "//model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_dummy_hsg, "//model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_dummy_hsg)")) &
!     units = length &
!     create_measure_display = no
!    !
!    measure create function measure = (eval(model_name//".MEAS_Gamma_RAD_"//RTOI(i))) &
!     function = (eval("ATAN2("//model_name//".MEAS_DX_RAD_"//RTOI(i)//", -1.0*"//model_name//".MEAS_DY_RAD_"//RTOI(i)//")")) &
!     units = angle &
!     create_measure_display = no
!    !
!    measure create function measure = (eval(model_name//".MEAS_Ecc_RAD_"//RTOI(i))) &
!     function = (eval("SQRT("//model_name//".MEAS_DX_RAD_"//RTOI(i)//"**2 + "//model_name//".MEAS_DY_RAD_"//RTOI(i)//"**2)")) &
!     units = length &
!     create_measure_display = no
!    !
!    measure create function measure = (eval(model_name//".MEAS_VX_RAD_"//RTOI(i))) &
!     function = (eval("VX("//model_name//".dummy_shaft_rad_"//RTOI(i)//".marker_dummy_shaft, "//model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_dummy_hsg, "//model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_dummy_hsg, "//model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_dummy_hsg)")) &
!     units = velocity &
!     create_measure_display = no
!    !
!    measure create function measure = (eval(model_name//".MEAS_VY_RAD_"//RTOI(i))) &
!     function = (eval("VY("//model_name//".dummy_shaft_rad_"//RTOI(i)//".marker_dummy_shaft, "//model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_dummy_hsg, "//model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_dummy_hsg, "//model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_dummy_hsg)")) &
!     units = velocity &
!     create_measure_display = no
!    !
!    measure create function measure = (eval(model_name//".MEAS_VT_RAD_"//RTOI(i))) &
!     function = (eval(model_name//".MEAS_VX_RAD_"//RTOI(i)//"*COS("//model_name//".MEAS_Gamma_RAD_"//RTOI(i)//") + "//model_name//".MEAS_VY_RAD_"//RTOI(i)//"*SIN("//model_name//".MEAS_Gamma_RAD_"//RTOI(i)//")")) &
!     units = velocity &
!     create_measure_display = no
!    !
!    measure create function measure = (eval(model_name//".MEAS_DOTGamma_RAD_"//RTOI(i))) &
!     function = (eval(model_name//".MEAS_VT_RAD_"//RTOI(i)//" / "//model_name//".MEAS_Ecc_RAD_"//RTOI(i))) &
!     units = angular_velocity &
!     create_measure_display = no
!    !
!    measure create function measure = (eval(model_name//".MEAS_Omega_RAD_"//RTOI(i))) &
!     function = (eval("WZ("//model_name//".dummy_shaft_rad_"//RTOI(i)//".marker_dummy_shaft, "//model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_dummy_hsg, "//model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_dummy_hsg)")) &
!     units = angular_velocity &
!     create_measure_display = no 
!    !
!    var set var = tmp_str string = (eval(model_name//".dummy_shaft_rad_"//RTOI(i)//".marker_dummy_shaft"))
!    var set var = tmp_obj object = (eval(USER_STRING(tmp_str)))
   !
end   
!   
return   
   
   
   
   