!-------------------------------------------------------
!-------------------- Joints Build ---------------------
!-------------------------------------------------------
!
!-------------------------------------------------------
! Shaft Dummy Parts
!-------------------------------------------------------
! 
if condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 1.0)             !  Shaft as Rigid
   !
   var set var = tmp_obj_cw object = (eval(model_name//".shaft.marker_shaft_cw"))
   var set var = tmp_obj_tw object = (eval(model_name//".shaft.marker_shaft_tw"))
   !
elseif condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 2.0)         !  Shaft as Beam
   !
   var set var = tmp_obj_cw object = (eval(model_name//".shaft_elem_1.marker_shaft_cw"))
   var set var = tmp_obj_tw object = (eval(model_name//".shaft_elem_"//RTOI(.MODEL_1.shaft_properties.values[25])//".marker_shaft_tw"))
   !
elseif condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 3.0)         !  Shaft as FE Part
   !
   var set var = tmp_obj_cw object = (eval(USER_STRING(model_name//".STR_shaft_cw_marker_name")))
   var set var = tmp_obj_tw object = (eval(USER_STRING(model_name//".STR_shaft_tw_marker_name")))
   !
end   
!
! Compressor Wheel Dummy
!   
constraint create joint Fixed &
 joint_name = (eval(model_name//".fixed_dummy_shaft_cw")) &
 i_marker_name = (eval(model_name//".dummy_shaft_cw.marker_dummy_shaft")) &
 j_marker_name = (eval(tmp_obj_cw))
!
constraint attributes &
 constraint_name = (eval(model_name//".fixed_dummy_shaft_cw")) &
 size_of_icons = 1.0
!
! Turbine Wheel Dummy
!
constraint create joint Fixed &
 joint_name = (eval(model_name//".fixed_dummy_shaft_tw")) &
 i_marker_name = (eval(model_name//".dummy_shaft_tw.marker_dummy_shaft")) &
 j_marker_name = (eval(tmp_obj_tw))
!
constraint attributes &
 constraint_name = (eval(model_name//".fixed_dummy_shaft_tw")) &
 size_of_icons = 1.0
!
var del var = tmp_obj_cw
var del var = tmp_obj_tw
!
! Radial Bearings Dummies
!
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.rad_bear_properties.values[1,1]))
   !
   if condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 1.0)          !  Shaft as Rigid
      !
      var set var = tmp_str string = "None"
      var set var = tmp_obj object = (eval(model_name//".shaft.marker_rad_bear_"//RTOI(i)))
      !
   elseif condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 2.0)      !  Shaft as Beam    
      !
      var set var = tmp_str string = "None"       
      var set var = tmp_obj object = (eval(model_name//".shaft_elem_"//RTOI(rad_bear_seg[i])//".marker_rad_bear_"//RTOI(i)))
      !
   elseif condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 3.0)      !  Shaft as a FE Part
      !
      var set var = tmp_str string = (eval("STR_rad_bear_"//RTOI(i)//"_shaft_marker"))
      var set var = tmp_obj object = (eval(USER_STRING(tmp_str)))
      !
   end
   !      
   constraint create joint Fixed &
    joint_name = (eval(model_name//".fixed_dummy_shaft_rad_"//RTOI(i))) &
    i_marker_name = (eval(model_name//".dummy_shaft_rad_"//RTOI(i)//".marker_dummy_shaft")) &
    j_marker_name = (eval(tmp_obj))
   !
   constraint attributes &
    constraint_name = (eval(model_name//".fixed_dummy_shaft_rad_"//RTOI(i))) &
    size_of_icons = 1.0
   !
   if condition = ((eval(.MODEL_1.rad_bear_properties.values[2,(eval(i))])) == 3.0)  ! Radial Bearing Solved by Ocvirk Solution
      !
      var set var = tmp_obj object =  (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".marker_rad_bear_"//RTOI(i)))
      !
      constraint create joint Fixed &
       joint_name = (eval(model_name//".fixed_dummy_ring_rad_"//RTOI(i))) &
       i_marker_name = (eval(model_name//".dummy_ring_rad_"//RTOI(i)//".marker_dummy_ring")) &
       j_marker_name = (eval(tmp_obj))
      !       
      constraint attributes &
       constraint_name = (eval(model_name//".fixed_dummy_ring_rad_"//RTOI(i))) &
       size_of_icons = 1.0
      !
      if condition = ((eval(.MODEL_1.rad_bear_properties.values[26,(eval(i))])) == 0.0)    ! Antirotation Pin Present 
         !
         var set var = tmp_obj object =  (eval(model_name//".bearing_ring_rad_"//RTOI(i)//".marker_ring_pin_"//RTOI(i)))
         !
         constraint create joint Fixed &
          joint_name = (eval(model_name//".fixed_dummy_ring_pin_rad_"//RTOI(i))) &
          i_marker_name = (eval(model_name//".dummy_ring_pin_rad_"//RTOI(i)//".marker_dummy_pin")) &
          j_marker_name = (eval(tmp_obj))
         ! 
         constraint attributes &
          constraint_name = (eval(model_name//".fixed_dummy_ring_pin_rad_"//RTOI(i))) &
          size_of_icons = 1.0
         ! 
      end
      !
   end
   !
end   
!
! Axial Bearings Dummies
!
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.axi_bear_properties.values[1,1]))
   !
   if condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 1.0)          !  Shaft as Rigid
      !
      var set var = tmp_str string = "None"
      var set var = tmp_obj object = (eval(model_name//".shaft.marker_axi_bear_"//RTOI(i)))
      !
   elseif condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 2.0)      !  Shaft as Beam    
      !
      var set var = tmp_str string = "None"       
      var set var = tmp_obj object = (eval(model_name//".shaft_elem_"//RTOI(axi_bear_seg[i])//".marker_axi_bear_"//RTOI(i)))      
      !
   elseif condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 3.0)      !  Shaft as a FE Part
      !
      var set var = tmp_str string = (eval("STR_axi_bear_"//RTOI(i)//"_shaft_marker"))
      var set var = tmp_obj object = (eval(USER_STRING(tmp_str)))
      !
   end   
   !      
   constraint create joint Fixed &
    joint_name = (eval(model_name//".fixed_dummy_shaft_axi_"//RTOI(i))) &
    i_marker_name = (eval(model_name//".dummy_shaft_axi_"//RTOI(i)//".marker_dummy_shaft")) &
    j_marker_name = (eval(tmp_obj))
   !
   constraint attributes &
    constraint_name = (eval(model_name//".fixed_dummy_shaft_axi_"//RTOI(i))) &
    size_of_icons = 1.0
   !
end   
!
var del var = tmp_str
var del var = tmp_obj
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Thrust Bearing Dummies
!-------------------------------------------------------
!
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.axi_bear_properties.values[1,1]))
   !
   if condition = ((eval(.MODEL_1.axi_bear_properties.values[2,(eval(i))])) == 2.0)    ! Bearing Solved Analytically
      !
      ! Thrust Bearing to Dummy
      var set var = tmp_obj object =  (eval(model_name//".thrust_bearing_"//RTOI(i)//".marker_axi_bear_"//RTOI(i)))
      !
      constraint create joint Fixed &
       joint_name = (eval(model_name//".fixed_dummy_thrust_axi_"//RTOI(i))) &
       i_marker_name = (eval(model_name//".dummy_thrust_axi_"//RTOI(i)//".marker_dummy_thrust")) &
       j_marker_name = (eval(tmp_obj))
      !       
      constraint attributes &
       constraint_name = (eval(model_name//".fixed_dummy_thrust_axi_"//RTOI(i))) &
       size_of_icons = 1.0
      !
      var del var = tmp_obj
      !
      ! Thrust Bearing Dummy to Housing Dummy
      constraint create joint Fixed &
       joint_name = (eval(model_name//".fixed_dummy_thrust_hsg_"//RTOI(i))) &
       i_marker_name = (eval(model_name//".dummy_thrust_axi_"//RTOI(i)//".marker_dummy_thrust")) &
       j_marker_name = (eval(model_name//".dummy_hsg_axi_"//RTOI(i)//".marker_dummy_hsg")) 
      !       
      constraint attributes &
       constraint_name = (eval(model_name//".fixed_dummy_thrust_hsg_"//RTOI(i))) &
       size_of_icons = 1.0
      !
   end
   !
end
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Housing Dummy Parts
!-------------------------------------------------------
!
! Radial Bearings Dummies
!
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.rad_bear_properties.values[1,1]))
   !
   if condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 1.0)       ! Centre Housing as Rigid
      !
      var set var = tmp_str string = "None"
      var set var = tmp_obj object = (eval(model_name//".housing.marker_rad_bear_"//RTOI(i)))
      !
   elseif condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 3.0)   ! Centre Housing as FE Part
      !
      var set var = tmp_str string = (eval("STR_rad_bear_"//RTOI(i)//"_hsg_marker"))
      var set var = tmp_obj object = (eval(USER_STRING(tmp_str)))
      !
   end
   !         
   constraint create joint Fixed &
    joint_name = (eval(model_name//".fixed_dummy_hsg_rad_"//RTOI(i))) &
    i_marker_name = (eval(model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_dummy_hsg")) &
    j_marker_name = (eval(tmp_obj))
   !
   constraint attributes &
    constraint_name = (eval(model_name//".fixed_dummy_hsg_rad_"//RTOI(i))) &
    size_of_icons = 1.0
   !
end   
!
! Axial Bearings Dummies
!
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.axi_bear_properties.values[1,1]))
   !
   if condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 1.0)       ! Centre Housing as Rigid
      !
      var set var = tmp_str string = "None"
      var set var = tmp_obj object = (eval(model_name//".housing.marker_axi_bear_"//RTOI(i)))
      !
   elseif condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 3.0)   ! Centre Housing as FE Part
      !  
      var set var = tmp_str string = (eval("STR_axi_bear_"//RTOI(i)//"_hsg_marker"))
      var set var = tmp_obj object = (eval(USER_STRING(tmp_str)))
      !
   end
   !         
   constraint create joint Fixed &
    joint_name = (eval(model_name//".fixed_dummy_hsg_axi_"//RTOI(i))) &
    i_marker_name = (eval(model_name//".dummy_hsg_axi_"//RTOI(i)//".marker_dummy_hsg")) &
    j_marker_name = (eval(tmp_obj))
   !
   constraint attributes &
    constraint_name = (eval(model_name//".fixed_dummy_hsg_axi_"//RTOI(i))) &
    size_of_icons = 1.0
   !
end 
!
var del var = tmp_str
var del var = tmp_obj
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Shaft/Compressor Wheel
!-------------------------------------------------------
!
if condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 1.0)             ! Shaft as Rigid
   !
   var set var = tmp_j_marker object = (eval(model_name//".shaft.marker_shaft_cw"))                
   !
elseif condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 2.0)         !  Shaft as Beam   
   !
   var set var = tmp_j_marker object = (eval(model_name//".dummy_shaft_cw.marker_shaft_cw")) 
   !
elseif condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 3.0)         !  Shaft as FE Part
   !
   var set var = tmp_j_marker object = (eval(model_name//".dummy_shaft_cw.marker_shaft_cw")) 
   !
end   
!
constraint create joint Fixed &
 joint_name = (eval(model_name//".fixed_dummy_to_cw")) &
 i_marker_name = (eval(model_name//".comp_wheel.marker_cw_shaft")) &
 j_marker_name = (eval(tmp_j_marker))
!    
constraint attributes &
 constraint_name = (eval(model_name//".fixed_dummy_to_cw")) &
 size_of_icons = 10.0
!
var del var = tmp_j_marker
!
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Shaft/Turbine Wheel
!-------------------------------------------------------
!
if condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 1.0)             ! Shaft as Rigid
   !
   var set var = tmp_j_marker object = (eval(model_name//".shaft.marker_shaft_tw")) 
   !
elseif condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 2.0)         !  Shaft as Beam
   !
   var set var = tmp_j_marker object = (eval(model_name//".dummy_shaft_tw.marker_shaft_tw"))
   !   
elseif condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 3.0)         !  Shaft as FE Part
   !
   var set var = tmp_j_marker object = (eval(model_name//".dummy_shaft_tw.marker_shaft_tw")) 
   !
end   
!
constraint create joint Fixed &
 joint_name = (eval(model_name//".fixed_dummy_to_tw")) &
 i_marker_name = (eval(model_name//".turb_wheel.marker_tw_shaft")) &
 j_marker_name = (eval(tmp_j_marker))
!    
constraint attributes &
 constraint_name = (eval(model_name//".fixed_dummy_to_tw")) &
 size_of_icons = 10.0
!
var del var = tmp_j_marker
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Compressor Wheel/Unbalance
!-------------------------------------------------------
!
! Nose
!
constraint create primitive_joint at_point  &
   jprim_name = (eval(model_name//".JOINT_CW_UM_nose"))  &
   i_part_name = (eval(model_name//".UN_CW_nose"))  &
   j_part_name = (eval(model_name//".comp_wheel"))  &
   location = (LOC_RELATIVE_TO({0.0, 0.0,0.0}, (eval(model_name//".ground.unbalance_CW_nose")))) &
   orientation = (ORI_RELATIVE_TO({0.0d, 0.0d, 0.0d}, (eval(model_name//".ground.unbalance_CW_nose"))))
!
constraint attributes &
 constraint_name = (eval(model_name//".JOINT_CW_UM_nose"))  &
 size_of_icons = 1.0
! 
! Back Plate
!
constraint create primitive_joint at_point  &
   jprim_name = (eval(model_name//".JOINT_CW_UM_back"))  &
   i_part_name = (eval(model_name//".UN_CW_back"))  &
   j_part_name = (eval(model_name//".comp_wheel"))  &
   location = (LOC_RELATIVE_TO({0.0, 0.0,0.0}, (eval(model_name//".ground.unbalance_CW_back")))) &
   orientation = (ORI_RELATIVE_TO({0.0d, 0.0d, 0.0d}, (eval(model_name//".ground.unbalance_CW_back"))))
!
constraint attributes &
 constraint_name = (eval(model_name//".JOINT_CW_UM_back"))  &
 size_of_icons = 1.0
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Turbine Wheel/Unbalance
!-------------------------------------------------------
!
! Nose
!
constraint create primitive_joint at_point  &
   jprim_name = (eval(model_name//".JOINT_TW_UM_nose"))  &
   i_part_name = (eval(model_name//".UN_TW_nose"))  &
   j_part_name = (eval(model_name//".turb_wheel"))  &
   location = (LOC_RELATIVE_TO({0.0, 0.0,0.0}, (eval(model_name//".ground.unbalance_TW_nose")))) &
   orientation = (ORI_RELATIVE_TO({0.0d, 0.0d, 0.0d}, (eval(model_name//".ground.unbalance_TW_nose"))))
!
constraint attributes &
 constraint_name = (eval(model_name//".JOINT_TW_UM_nose"))  &
 size_of_icons = 1.0
! 
! Back Plate
!
constraint create primitive_joint at_point  &
   jprim_name = (eval(model_name//".JOINT_TW_UM_back"))  &
   i_part_name = (eval(model_name//".UN_TW_back"))  &
   j_part_name = (eval(model_name//".turb_wheel"))  &
   location = (LOC_RELATIVE_TO({0.0, 0.0,0.0}, (eval(model_name//".ground.unbalance_TW_back")))) &
   orientation = (ORI_RELATIVE_TO({0.0d, 0.0d, 0.0d}, (eval(model_name//".ground.unbalance_TW_back"))))
!
constraint attributes &
 constraint_name = (eval(model_name//".JOINT_TW_UM_back"))  &
 size_of_icons = 1.0
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Shaft/Housing
!-------------------------------------------------------
!
! Radial Bearings
!
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.rad_bear_properties.values[1,1]))
   !
   if condition = ((eval(.MODEL_1.rad_bear_properties.values[2,(eval(i))])) == 1.0)  ! Radial Bearing as Ideal Joint
      !
      ! X-direction
      var set var = tmp_i_marker string = (eval(model_name//".dummy_shaft_rad_"//RTOI(i)//".marker_rad_bear_"//RTOI(i)//"_X"))
      var set var = tmp_j_marker string = (eval(model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_rad_bear_"//RTOI(i)//"_X"))
      !
      constraint create primitive_joint Inplane &
       jprim_name = (eval(model_name//".inplane_X_rad_bear_"//RTOI(i))) &
       i_marker_name = (eval(tmp_i_marker)) &
       j_marker_name = (eval(tmp_j_marker))
      !
      mdi graphic_force object = (eval(model_name//".inplane_X_rad_bear_"//RTOI(i))) type=1
      !
      constraint attributes &
       constraint_name = (eval(model_name//".inplane_X_rad_bear_"//RTOI(i))) &
       size_of_icons = 10.0
      !
      ! Y-direction
      var set var = tmp_i_marker string = (eval(model_name//".dummy_shaft_rad_"//RTOI(i)//".marker_rad_bear_"//RTOI(i)//"_Y"))
      var set var = tmp_j_marker string = (eval(model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_rad_bear_"//RTOI(i)//"_Y"))
      !
      constraint create primitive_joint Inplane &
       jprim_name = (eval(model_name//".inplane_Y_rad_bear_"//RTOI(i))) &
       i_marker_name = (eval(tmp_i_marker)) &
       j_marker_name = (eval(tmp_j_marker))
      !
      mdi graphic_force object = (eval(model_name//".inplane_Y_rad_bear_"//RTOI(i))) type=1
      !
      constraint attributes &
       constraint_name = (eval(model_name//".inplane_Y_rad_bear_"//RTOI(i))) &
       size_of_icons = 10.0
      !
      var del var = tmp_i_marker
      var del var = tmp_j_marker
      !
   elseif condition = ((eval(.MODEL_1.rad_bear_properties.values[2,(eval(i))])) == 2.0)  ! Radial Bearing defined by Stiffness & Damping
      !
      var set var = tmp_i_marker string = (eval(model_name//".dummy_shaft_rad_"//RTOI(i)//".marker_dummy_shaft"))
      var set var = tmp_j_marker string = (eval(model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_dummy_hsg"))
      !
      force create direct general_force &
       general_force_name = (eval(model_name//".RAD_BEAR_"//RTOI(i))) &
       i_marker_name = (eval(tmp_i_marker)) &
       j_part_name = (eval(model_name//".dummy_hsg_rad_"//RTOI(i))) &
       ref_marker_name = (eval(tmp_j_marker)) &
       x_force_function = (eval("-1.0*"//(.MODEL_1.rad_bear_properties.values[7,(eval(i))])//"*DX("//(tmp_i_marker)//", "//(tmp_j_marker)//", "//(tmp_j_marker)//") - "//(.MODEL_1.rad_bear_properties.values[8,(eval(i))])//"*VX("//(tmp_i_marker)//", "//(tmp_j_marker)//", "//(tmp_j_marker)//", "//(tmp_j_marker)//")")) &
       y_force_function = (eval("-1.0*"//(.MODEL_1.rad_bear_properties.values[5,(eval(i))])//"*DY("//(tmp_i_marker)//", "//(tmp_j_marker)//", "//(tmp_j_marker)//") - "//(.MODEL_1.rad_bear_properties.values[6,(eval(i))])//"*VY("//(tmp_i_marker)//", "//(tmp_j_marker)//", "//(tmp_j_marker)//", "//(tmp_j_marker)//")")) &
       z_force_function = "0.0" &
       x_torque_function = "0.0" &
       y_torque_function = "0.0" &
       z_torque_function = "0.0"      
      !
      entity attributes &
       entity_name = (eval(model_name//".RAD_BEAR_"//RTOI(i))) &
       size = 10
      ! 
      var del var = tmp_i_marker
      var del var = tmp_j_marker
      !
   elseif condition = ((eval(.MODEL_1.rad_bear_properties.values[2,(eval(i))])) == 3.0)  ! Radial Bearing Solved by Ocvirk Solution
      !
      var set var = tmp_i_marker string = (eval(model_name//".dummy_shaft_rad_"//RTOI(i)//".marker_dummy_shaft"))
      var set var = tmp_j_marker string = (eval(model_name//".dummy_ring_rad_"//RTOI(i)//".marker_dummy_ring"))
      !
      constraint create primitive_joint Inplane &
       jprim_name = (eval(model_name//".inplane_ring_rad_"//RTOI(i))) &
       i_marker_name = (eval(tmp_i_marker)) &
       j_marker_name = (eval(tmp_j_marker))
      !
      constraint attributes &
       constraint_name = (eval(model_name//".inplane_ring_rad_"//RTOI(i))) &
       size_of_icons = 10.0
      !
      constraint create primitive_joint Parallel_Axis &
       jprim_name = (eval(model_name//".parallel_ring_rad_"//RTOI(i))) &
       i_marker_name = (eval(tmp_i_marker)) &
       j_marker_name = (eval(tmp_j_marker)) 
      !
      constraint attributes &
       constraint_name = (eval(model_name//".parallel_ring_rad_"//RTOI(i))) &
       size_of_icons = 10.0
      ! 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!       !
!       !  SUBRUTINA
!       !       
!       ! Aj s rotujucim vonkajsim kruzkom
!       var set var = tmp_i_marker string = (eval(model_name//".dummy_shaft_rad_"//RTOI(i)//".marker_dummy_shaft"))
!       var set var = tmp_j_marker string = (eval(model_name//".dummy_ring_rad_"//RTOI(i)//".marker_dummy_ring"))
!       !
!       force create direct general_force &
!        general_force_name = (eval(model_name//".RAD_BEAR_INNER_"//RTOI(i))) &
!        i_marker_name = (eval(tmp_i_marker)) &
!        j_part_name = (eval(model_name//".dummy_ring_rad_"//RTOI(i))) &
!        ref_marker_name = (eval(tmp_j_marker)) &
!        user_function = (eval(i)), (.MODEL_1.rad_bear_properties.adams_id) &
!        routine = "myforce::gfosub"      
!       !
!       entity attributes &
!        entity_name = (eval(model_name//".RAD_BEAR_INNER_"//RTOI(i))) &
!        size = 10
!       !
!       mdi graphic_force object = (eval(model_name//".RAD_BEAR_INNER_"//RTOI(i))) type=1 
!       !
!       var set var = tmp_i_marker string = (eval(model_name//".dummy_ring_rad_"//RTOI(i)//".marker_dummy_ring"))
!       var set var = tmp_j_marker string = (eval(model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_dummy_hsg"))
!       !
!       force create direct general_force &
!        general_force_name = (eval(model_name//".RAD_BEAR_OUTER_"//RTOI(i))) &
!        i_marker_name = (eval(tmp_i_marker)) &
!        j_part_name = (eval(model_name//".dummy_hsg_rad_"//RTOI(i))) &
!        ref_marker_name = (eval(tmp_j_marker)) &
!        user_function = (eval(i+6)), (.MODEL_1.rad_bear_properties.adams_id) &
!        routine = "myforce::gfosub"      
!       !
!       entity attributes &
!        entity_name = (eval(model_name//".RAD_BEAR_OUTER_"//RTOI(i))) &
!        size = 10
!       ! 
!       mdi graphic_force object = (eval(model_name//".RAD_BEAR_OUTER_"//RTOI(i))) type=1
!       !
!       !  KONIEC SUBRUTINA
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!      
      !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      ! A/VIEW VYPOCET
      !
      ! Inner Bearing
      var set var = id int = (eval(i))                                          ! ID of the bearing
      !
      if condition = ((eval(DB_EXISTS("Ocvirk_Journal_Radial_Force"))) == 0.0)
         !
         runtime_function create &
         arg = vis, width, radius, clearance, epsilon, omega, gamma_dot, eps_dot &
         runtime_func = Ocvirk_Journal_Radial_Force  &
          !text_of_expression = "-0.5*VARVAL(vis)*width**3.0*radius/clearance**2.0*", &
          !                     "(2.0*VARVAL(epsilon)**2.0*(VARVAL(omega)-2*VARVAL(gamma_dot))/(1.0-VARVAL(epsilon)**2.0)**2.0 +", &
          !                     " PI*VARVAL(eps_dot)*(1.0+2.0*VARVAL(epsilon)**2)/(1.0-VARVAL(epsilon)**2.0)**2.5)"
          text_of_expression = "-0.5*VARVAL(vis)*width**3.0*radius/clearance**2.0*", &
                               "(2.0*VARVAL(epsilon)**2.0*(ABS(VARVAL(omega)-2*VARVAL(gamma_dot)))/(1.0-VARVAL(epsilon)**2.0)**2.0 +", &
                               " PI*VARVAL(eps_dot)*(1.0+2.0*VARVAL(epsilon)**2)/(1.0-VARVAL(epsilon)**2.0)**2.5)"

         !
      end                                 
      !
      file command read file='./_model/_rad_bear_anal.cmd'
      !
      var set var = tmp_i_marker string = (eval(model_name//".dummy_shaft_rad_"//RTOI(i)//".marker_dummy_shaft"))
      var set var = tmp_j_marker string = (eval(model_name//".dummy_ring_rad_"//RTOI(i)//".marker_dummy_ring"))
      !
      force create direct general_force &
       general_force_name = (eval(model_name//".RAD_BEAR_INNER_"//RTOI(i))) &
       i_marker_name = (eval(tmp_i_marker)) &
       j_part_name = (eval(model_name//".dummy_ring_rad_"//RTOI(i))) &
       ref_marker_name = (eval(tmp_j_marker)) &
       x_force_function = (eval("VARVAL(Frad_inner_rad_"//RTOI(pair_id)//")*SIN(VARVAL(gamma_inner_rad_"//RTOI(pair_id)//")) + VARVAL(Ftan_inner_rad_"//RTOI(pair_id)//")*COS(VARVAL(gamma_inner_rad_"//RTOI(pair_id)//"))")) &
       y_force_function = (eval("-1.0*VARVAL(Frad_inner_rad_"//RTOI(pair_id)//")*COS(VARVAL(gamma_inner_rad_"//RTOI(pair_id)//")) + VARVAL(Ftan_inner_rad_"//RTOI(pair_id)//")*SIN(VARVAL(gamma_inner_rad_"//RTOI(pair_id)//"))")) &
       z_force_function = "0.0"  &
       x_torque_function = "0.0"  &
       y_torque_function = "0.0"  &
       z_torque_function = (eval("VARVAL(Mfric_inner_rad_"//RTOI(pair_id)//")/scale_meter"))
      !
      entity attributes &
       entity_name = (eval(model_name//".RAD_BEAR_INNER_"//RTOI(i))) &
       size = 10
      !
      mdi graphic_force object = (eval(model_name//".RAD_BEAR_INNER_"//RTOI(i))) type=1 
      !
      ! Outer Bearing
      var set var = id int = (eval(i+6))                                          ! ID of the bearing
      !
      file command read file='./_model/_rad_bear_anal.cmd'
      !
      var set var = tmp_i_marker string = (eval(model_name//".dummy_ring_rad_"//RTOI(i)//".marker_dummy_ring"))
      var set var = tmp_j_marker string = (eval(model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_dummy_hsg"))
      !
      force create direct general_force &
       general_force_name = (eval(model_name//".RAD_BEAR_OUTER_"//RTOI(i))) &
       i_marker_name = (eval(tmp_i_marker)) &
       j_part_name = (eval(model_name//".dummy_hsg_rad_"//RTOI(i))) &
       ref_marker_name = (eval(tmp_j_marker)) &
       x_force_function = (eval("VARVAL(Frad_outer_rad_"//RTOI(pair_id)//")*SIN(VARVAL(gamma_outer_rad_"//RTOI(pair_id)//")) + VARVAL(Ftan_outer_rad_"//RTOI(pair_id)//")*COS(VARVAL(gamma_outer_rad_"//RTOI(pair_id)//"))")) &
       y_force_function = (eval("-1.0*VARVAL(Frad_outer_rad_"//RTOI(pair_id)//")*COS(VARVAL(gamma_outer_rad_"//RTOI(pair_id)//")) + VARVAL(Ftan_outer_rad_"//RTOI(pair_id)//")*SIN(VARVAL(gamma_outer_rad_"//RTOI(pair_id)//"))")) &
       z_force_function = "0.0"  &
       x_torque_function = "0.0"  &
       y_torque_function = "0.0"  &
       z_torque_function = (eval("VARVAL(Mfric_outer_rad_"//RTOI(pair_id)//")/scale_meter"))
      !
      entity attributes &
       entity_name = (eval(model_name//".RAD_BEAR_OUTER_"//RTOI(i))) &
       size = 10
      !
      mdi graphic_force object = (eval(model_name//".RAD_BEAR_OUTER_"//RTOI(i))) type=1
      !                  
      ! Konies A/VIEW VYPOCET
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!      
      
      
      
      
      
      !
      if condition = ((eval(.MODEL_1.rad_bear_properties.values[26,(eval(i))])) == 0.0)    ! Antirotation Pin Present
         !      
         var set var = tmp_i_marker string = (eval(model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_rad_bear_"//RTOI(i)//"_X"))
         var set var = tmp_j_marker string = (eval(model_name//".dummy_ring_pin_rad_"//RTOI(i)//".marker_rad_bear_"//RTOI(i)//"_X"))
         !
         constraint create primitive_joint Inplane &
          jprim_name = (eval(model_name//".inplane_anti_rotation_rad_"//RTOI(i))) &
          i_marker_name = (eval(tmp_i_marker)) &
          j_marker_name = (eval(tmp_j_marker))
         !
         mdi graphic_force object = (eval(model_name//".inplane_anti_rotation_rad_"//RTOI(i))) type=1
         !
         constraint attributes &
          constraint_name = (eval(model_name//".inplane_anti_rotation_rad_"//RTOI(i))) &
          size_of_icons = 10.0
         !   
      end
      ! 
      var del var = tmp_i_marker
      var del var = tmp_j_marker    
      !
   end   
   !
end   
!
! Axial Bearings
!
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.axi_bear_properties.values[1,1]))
   !
   if condition = ((eval(.MODEL_1.axi_bear_properties.values[2,(eval(i))])) == 1.0)  ! Axial Bearing as Ideal Joint
      !
      ! Z-direction 
      var set var = tmp_i_marker string = (eval(model_name//".dummy_shaft_axi_"//RTOI(i)//".marker_axi_bear_"//RTOI(i)//"_Z"))
      var set var = tmp_j_marker string = (eval(model_name//".dummy_hsg_axi_"//RTOI(i)//".marker_axi_bear_"//RTOI(i)//"_Z"))
      !
      constraint create primitive_joint Inplane &
       jprim_name = (eval(model_name//".inplane_Z_axi_bear_"//RTOI(i))) &
       i_marker_name = (eval(tmp_i_marker)) &
       j_marker_name = (eval(tmp_j_marker))
      !
      mdi graphic_force object = (eval(model_name//".inplane_Z_axi_bear_"//RTOI(i))) type=1
      !
      constraint attributes &
       constraint_name = (eval(model_name//".inplane_Z_axi_bear_"//RTOI(i))) &
       size_of_icons = 10.0
      !
      constraint create primitive_joint parallel_axis &
       jprim_name = (eval(model_name//".parallel_axi_bear_"//RTOI(i))) &
       i_marker_name = (eval(tmp_i_marker)) &
       j_marker_name = (eval(tmp_j_marker))
      !
      mdi graphic_force object = (eval(model_name//".parallel_axi_bear_"//RTOI(i))) type=1
      !
      constraint attributes &
       constraint_name = (eval(model_name//".parallel_axi_bear_"//RTOI(i))) &
       size_of_icons = 10.0
      !
      var set var = tmp_i_marker str = (eval(model_name//".dummy_shaft_axi_"//RTOI(i)//".marker_dummy_shaft"))
      var set var = tmp_j_marker str = (eval(model_name//".dummy_hsg_axi_"//RTOI(i)//".marker_dummy_hsg"))
      !
      ! OMEGA
      !
      data_element create variable  &
       variable_name = (eval("omega_axi_"//RTOI(i)))  &
       function = (eval("WZ("//tmp_i_marker//", "//tmp_j_marker//", "//tmp_j_marker//")"))
      !
   elseif condition = ((eval(.MODEL_1.axi_bear_properties.values[2,(eval(i))])) == 2.0)  ! Axial Bearing solved Analycitically
      !
      var set var = tmp_i_marker str = (eval(model_name//".dummy_shaft_axi_"//RTOI(i)//".marker_dummy_shaft"))
      var set var = tmp_j_marker str = (eval(model_name//".dummy_thrust_axi_"//RTOI(i)//".marker_dummy_thrust")) 
      !
      ! OMEGA
      !
      data_element create variable  &
       variable_name = (eval("omega_axi_"//RTOI(i)))  &
       function = (eval("WZ("//tmp_i_marker//", "//tmp_j_marker//", "//tmp_j_marker//")"))
      !
      var set var = id int = (eval(i)) 
      !   
      file command read file='./_model/_thrust_bear_anal.cmd'
      !  
      for variable_name = j start_value = 1 end_value = (eval(.MODEL_1.axi_bear_properties.values[11,(eval(i))])) 
         !
         var set var = tmp_i_marker string = (eval(model_name//".thrust_bearing_"//RTOI(i)//".marker_gforce_"//RTOI(j)))
         !
         force create direct general_force &
          general_force_name = (eval(model_name//".THRUST_BEAR_"//RTOI(i)//"_PAD_"//RTOI(j))) &
          i_marker_name = (eval(tmp_i_marker)) &
          j_part_name = (eval(model_name//".dummy_shaft_axi_"//RTOI(i))) &
          ref_marker_name = (eval(tmp_i_marker)) &
          x_force_function = "0.0"  &
          y_force_function = (eval("1.0*VARVAL(axi_force_tang_"//RTOI(i)//"_pad_"//RTOI(j)//")")) &
          z_force_function = (eval("-1.0*VARVAL(axi_force_normal_"//RTOI(i)//"_pad_"//RTOI(j)//")")) &
          x_torque_function = "0.0"  &
          y_torque_function = "0.0"  &
          z_torque_function = "0.0"
         !
         entity attributes &
          entity_name = (eval(model_name//".THRUST_BEAR_"//RTOI(i)//"_PAD_"//RTOI(j))) &
          size = 3
         !
         mdi graphic_force object = (eval(model_name//".THRUST_BEAR_"//RTOI(i)//"_PAD_"//RTOI(j))) type=3 
         !
      end
      !           
   end   
   !
   var del var = tmp_i_marker
   var del var = tmp_j_marker
   !
end
!
! DOBA JEDNEHO OTOCENIA HRIADELA
!
if condition = ((eval(DB_EXISTS("tcyc"))) == 0.0)
   !
   data_element create variable  &
    variable_name = tcyc  &  ! [sec]
    function = (eval("ABS(2*PI/VARVAL(omega_axi_1))"))
   !
else
   !
   data_element modify variable  &
    variable_name = tcyc  &  ! [sec]
    function = (eval("ABS(2*PI/VARVAL(omega_axi_1))"))
   !
end    
!
!-------------------------------------------------------
!
!-------------------------------------------------------
! Housing/Ground
!-------------------------------------------------------
!
if condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 1.0)          ! Rigid Housing 
   !
   constraint create joint Fixed &
    joint_name = (eval(model_name//".fixed_housing_to_ground")) &
    i_marker_name = (eval(model_name//".housing.marker_cm")) &
    j_marker_name = (eval(model_name//".ground.LBRF"))
   !
   entity attributes &
    entity_name = (eval(model_name//".fixed_housing_to_ground")) &
    visibility = off &
    name_visibility = off 
   !
end   
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Test Rig
!-------------------------------------------------------
! 
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.test_rig_properties.values[1]))
   !
   marker create marker = (eval(model_name//".ground.marker_dyno_"//RTOI(i))) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.dyno_"//RTOI(i))))) & 
    orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.dyno_"//RTOI(i))))) 
   ! 
   entity attributes &
    entity_name = (eval(model_name//".ground.marker_dyno_"//RTOI(i))) &
    visibility = off &
    name_visibility = off   
   !
   constraint create joint Revolute &
    joint_name = (eval(model_name//".revolute_dyno_"//RTOI(i))) &
    i_marker_name = (eval(model_name//".dyno_"//RTOI(i)//".marker_cm")) &
    j_marker_name = (eval(model_name//".ground.marker_dyno_"//RTOI(i))) 
   !
   constraint attributes &
    constraint_name = (eval(model_name//".revolute_dyno_"//RTOI(i))) &
    size_of_icons = 5.0
   !          
end
!
constraint create motion motion_name = (eval(model_name//".dyno_motion")) &
 joint = (eval(model_name//".revolute_dyno_"//RTOI(.MODEL_1.test_rig_properties.values[1]))) &
 type = rotational &
 time_derivative = velocity &
 function = "0.0"                                                               ! rad/time
!
var set var = tmp real = (eval(-1.0*.MODEL_1.test_rig_properties.values[2]*2*PI*UNITS_CONVERSION_FACTOR("second")/60.0))
!
if condition = (.MODEL_1.test_rig_properties.values[17] == 1.0)                 ! Constant Speed
   !
   constraint modify motion motion_name = (eval(model_name//".dyno_motion")) &
    function = (eval(.MODEL_1.test_rig_properties.values[18]*tmp))
   ! 
elseif condition = (.MODEL_1.test_rig_properties.values[17] == 2.0)             ! Ramp
   !
   constraint modify motion motion_name = (eval(model_name//".dyno_motion")) &
    function = (eval(tmp*.MODEL_1.test_rig_properties.values[19]//"+time*"//tmp*(.MODEL_1.test_rig_properties.values[20]-.MODEL_1.test_rig_properties.values[19])/.MODEL_1.test_rig_properties.values[21]))
   !
elseif condition = (.MODEL_1.test_rig_properties.values[17] == 3.0)             ! Step  
   !
   constraint modify motion motion_name = (eval(model_name//".dyno_motion")) &
    function = (eval(tmp//"*step(time, "//.MODEL_1.test_rig_properties.values[24]//", "//.MODEL_1.test_rig_properties.values[22]//", "//.MODEL_1.test_rig_properties.values[25]//", "//.MODEL_1.test_rig_properties.values[23]//")"))      
   !
elseif condition = (.MODEL_1.test_rig_properties.values[17] == 4.0)             ! Spline 
   !
   constraint modify motion motion_name = (eval(model_name//".dyno_motion")) &
    function = (eval("CUBSPL(time, 0, "//RTOI(.MODEL_1.test_rig_properties.values[26])//", 0)*"//tmp)) 
   ! 
end 
!
var del var = tmp
!
constraint attributes &
 constraint_name = (eval(model_name//".dyno_motion")) &
 size_of_icons = 5.0

!
!-------------------------------------------------------
!
!
return

























































return
!
!-------------------------------------------------------
! Shaft/Housing
!-------------------------------------------------------
!
if condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 1.0)             ! Shaft as Rigid
   !
   ! Not Available yet
   !
elseif condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 2.0)         ! Shaft as Beam
   !
   ! Not Available yet
   !
elseif condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 3.0)         ! Shaft as FE Part
   !
   ! Not Available yet
   !
end      
!
if condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 1.0)          ! Centre Housing as Ground
   !
   var set var = tmp_j_part object = (eval(model_name//".ground"))
   !
elseif condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 2.0)      ! Centre Housing as Part
   !
   ! Not Available yet
   !
elseif condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 3.0)      ! Centre Housing as FE Part
   !
   ! Dummy parts constrained to Housing
   !
    
   !     
   var set var = tmp_j_part object = (eval(STR_hsg_name))
   !
end
!
! Radial Bearings
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.rad_bear_properties.values[1,1]))
   !
   if condition = ((eval(.MODEL_1.rad_bear_properties.values[2,(eval(i))])) == 1.0)  ! Radial Bearing as Ideal Joint
      !
      if condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 1.0)       ! Shaft as Rigid
         !
         var set var = tmp_i_part object = (eval(model_name//".shaft"))
         var set var = tmp_i_marker_X string = (eval(tmp_i_part//".marker_rad_bear_"//RTOI(i)//"_X"))
         var set var = tmp_i_marker_Y string = (eval(tmp_i_part//".marker_rad_bear_"//RTOI(i)//"_Y"))
         !
      elseif condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 2.0)   ! Shaft as Beam
         !
         ! Not Available yet
         !
      elseif condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 3.0)   ! Shaft as FE Part
         !
         ! Not Available yet
         !
      end      
      ! 
      if condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 1.0)    ! Housing as Ground
         !
         var set var = tmp_j_part object = (eval(model_name//".ground"))
         var set var = tmp_j_marker_X string = (eval(tmp_j_part//".marker_rad_bear_"//RTOI(i)//"_X")) 
         var set var = tmp_j_marker_Y string = (eval(tmp_j_part//".marker_rad_bear_"//RTOI(i)//"_Y")) 
         !
      elseif condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 2.0)      ! Centre Housing as Part
         !
         ! Not Available yet
         !
      elseif condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 3.0)      ! Centre Housing as FE Part
         !
         var set var = tmp_j_part object = (eval(model_name))
         var set var = tmp_j_marker_X string = (eval(model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_rad_bear_"//RTOI(i)//"_X"))
         var set var = tmp_j_marker_Y string = (eval(model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_rad_bear_"//RTOI(i)//"_Y")) 
         !         
      end   
      !
      marker create marker = (eval(tmp_i_marker_X)) &
       location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i))))) &
       orientation = (ORI_RELATIVE_TO({90.0d, 90.0d, 0.0d}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i)))))
      !
      entity attributes &
       entity_name = (eval(tmp_i_marker_X)) &
       visibility = off &
       name_visibility = off  
      !    
      marker create marker = (eval(tmp_i_marker_Y)) &
       location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i))))) &
       orientation = (ORI_RELATIVE_TO({0.0d, -90.0d, 0.0d}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i)))))
      !
      entity attributes &
       entity_name = (eval(tmp_i_marker_Y)) &
       visibility = off &
       name_visibility = off  
      ! 
      marker create marker = (eval(tmp_j_marker_X)) &
       location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i))))) &
       orientation = (ORI_RELATIVE_TO({90.0d, 90.0d, 0.0d}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i))))) 
      !
      entity attributes &
       entity_name = (eval(tmp_j_marker_X)) &
       visibility = off &
       name_visibility = off  
      !
      marker create marker = (eval(tmp_j_marker_Y)) &
       location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i))))) &
       orientation = (ORI_RELATIVE_TO({0.0d, -90.0d, 0.0d}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i))))) 
      !
      entity attributes &
       entity_name = (eval(tmp_j_marker_Y)) &
       visibility = off &
       name_visibility = off  
      !
      ! X-direction
      constraint create primitive_joint Inplane &
       jprim_name = (eval(model_name//".inplane_X_rad_bear_"//RTOI(i))) &
       i_marker_name = (eval(tmp_i_marker_X)) &
       j_marker_name = (eval(tmp_j_marker_X))
      !
      constraint attributes &
       constraint_name = (eval(model_name//".inplane_X_rad_bear_"//RTOI(i))) &
       size_of_icons = 10.0
      ! 
      ! Y-direction
      constraint create primitive_joint Inplane &
       jprim_name = (eval(model_name//".inplane_Y_rad_bear_"//RTOI(i))) &
       i_marker_name = (eval(tmp_i_marker_Y)) &
       j_marker_name = (eval(tmp_j_marker_Y))
      !
      constraint attributes &
       constraint_name = (eval(model_name//".inplane_Y_rad_bear_"//RTOI(i))) &
       size_of_icons = 10.0
      ! 
      var del var = tmp_i_part
      var del var = tmp_j_part
      var del var = tmp_i_marker_X
      var del var = tmp_j_marker_X
      var del var = tmp_i_marker_Y
      var del var = tmp_j_marker_Y
      !
   end
   !
end
!
! Axial Bearings
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.axi_bear_properties.values[1,1]))
   !
   if condition = ((eval(.MODEL_1.axi_bear_properties.values[2,(eval(i))])) == 1.0)  ! Axial Bearing as Ideal Joint
      !
      if condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 1.0)       ! Shaft as Rigid
         !
         var set var = tmp_i_part object = (eval(model_name//".shaft"))
         var set var = tmp_i_marker_Z string = (eval(tmp_i_part//".marker_axi_bear_"//RTOI(i)//"_Z"))
         !
      elseif condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 2.0)   ! Shaft as Beam
         !
         ! Not Available yet
         !
      elseif condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 3.0)   ! Shaft as FE Part
         !
         ! Not Available yet
         !
      end 
      !     
      if condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 1.0)    ! Housing as Ground
         !
         var set var = tmp_j_part object = (eval(model_name//".ground"))
         var set var = tmp_j_marker_Z string = (eval(tmp_j_part//".marker_axi_bear_"//RTOI(i)//"_Z"))
         !
      elseif condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 2.0)      ! Centre Housing as Part
         !
         ! Not Available yet
         !
      elseif condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 3.0)      ! Centre Housing as FE Part
         !
         var set var = tmp_j_part string = "None"
         var set var = tmp_j_marker_Z string = (eval(model_name//".dummy_hsg_axi_"//RTOI(i)//".marker_axi_bear_"//RTOI(i)//"_Z"))
         !         
      end   
      !
      marker create marker = (eval(tmp_i_marker_Z)) &
       location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_axi_bear_"//RTOI(i))))) &
       orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_axi_bear_"//RTOI(i)))))
      !
      entity attributes &
       entity_name = (eval(tmp_i_marker_Z)) &
       visibility = off &
       name_visibility = off  
      !
      marker create marker = (eval(tmp_j_marker_Z)) &
       location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_axi_bear_"//RTOI(i))))) &
       orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_axi_bear_"//RTOI(i)))))
      !
      entity attributes &
       entity_name = (eval(tmp_j_marker_Z)) &
       visibility = off &
       name_visibility = off
      !
      constraint create primitive_joint Inplane &
       jprim_name = (eval(model_name//".inplane_axi_bear_"//RTOI(i))) &
       i_marker_name = (eval(tmp_i_marker_Z)) &
       j_marker_name = (eval(tmp_j_marker_Z))
      !
      constraint attributes &
       constraint_name = (eval(model_name//".inplane_axi_bear_"//RTOI(i))) &
       size_of_icons = 10.0
      !
      var del var = tmp_i_part
      var del var = tmp_j_part
      var del var = tmp_i_marker_Z
      var del var = tmp_j_marker_Z
      !
   end   
   !      
end      
!
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Test Rig
!-------------------------------------------------------
! 
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.test_rig_properties.values[1]))
   !
   marker create marker = (eval(model_name//".ground.marker_dyno_"//RTOI(i))) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.dyno_"//RTOI(i))))) & 
    orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.dyno_"//RTOI(i))))) 
   ! 
   entity attributes &
    entity_name = (eval(model_name//".ground.marker_dyno_"//RTOI(i))) &
    visibility = off &
    name_visibility = off   
   !
   constraint create joint Revolute &
    joint_name = (eval(model_name//".revolute_dyno_"//RTOI(i))) &
    i_marker_name = (eval(model_name//".dyno_"//RTOI(i)//".marker_cm")) &
    j_marker_name = (eval(model_name//".ground.marker_dyno_"//RTOI(i))) 
   !
   constraint attributes &
    constraint_name = (eval(model_name//".revolute_dyno_"//RTOI(i))) &
    size_of_icons = 5.0
   !          
end
!
constraint create motion motion_name = (eval(model_name//".dyno_motion")) &
 joint = (eval(model_name//".revolute_dyno_"//RTOI(.MODEL_1.test_rig_properties.values[1]))) &
 type = rotational &
 time_derivative = velocity &
 function = "0.0"                                                               ! rad/time
!
var set var = tmp real = (eval(-1.0*.MODEL_1.test_rig_properties.values[2]*2*PI*UNITS_CONVERSION_FACTOR("second")/60.0))
!
if condition = (.MODEL_1.test_rig_properties.values[17] == 1.0)                 ! Constant Speed
   !
   constraint modify motion motion_name = (eval(model_name//".dyno_motion")) &
    function = (eval(.MODEL_1.test_rig_properties.values[18]*tmp))
   ! 
elseif condition = (.MODEL_1.test_rig_properties.values[17] == 2.0)             ! Ramp
   !
   constraint modify motion motion_name = (eval(model_name//".dyno_motion")) &
    function = (eval(tmp*.MODEL_1.test_rig_properties.values[19]//"+time*"//tmp*(.MODEL_1.test_rig_properties.values[20]-.MODEL_1.test_rig_properties.values[19])/.MODEL_1.test_rig_properties.values[21]))
   !
elseif condition = (.MODEL_1.test_rig_properties.values[17] == 3.0)             ! Step  
   !
   constraint modify motion motion_name = (eval(model_name//".dyno_motion")) &
    function = (eval(tmp//"*step(time, "//.MODEL_1.test_rig_properties.values[24]//", "//.MODEL_1.test_rig_properties.values[22]//", "//.MODEL_1.test_rig_properties.values[25]//", "//.MODEL_1.test_rig_properties.values[23]//")"))      
   !
elseif condition = (.MODEL_1.test_rig_properties.values[17] == 4.0)             ! Spline 
   !
   constraint modify motion motion_name = (eval(model_name//".dyno_motion")) &
    function = (eval("CUBSPL(time, 0, "//RTOI(.MODEL_1.test_rig_properties.values[26])//", 0)*"//tmp)) 
   ! 
end 
!
var del var = tmp
!
constraint attributes &
 constraint_name = (eval(model_name//".dyno_motion")) &
 size_of_icons = 5.0

!
!-------------------------------------------------------
!
!
return
