!-------------------------------------------------------
!-------------------- Housing Build --------------------
!-------------------------------------------------------
!
if condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 1.0)          ! Rigid Housing 
   !
   part create rigid_body name_and_position part_name = (eval(.MODEL_1.STR_hsg_name)) 
   part attributes part_name = (eval(.MODEL_1.STR_hsg_name)) color = CYAN name_vis = off
   !
   marker create marker = (eval(.MODEL_1.STR_hsg_name//".marker_cm")) &
    location = 0.0, 0.0, 0.0 &
    orientation = 0.0, 0.0, 0.0
   !
   entity attributes entity_name = (eval(.MODEL_1.STR_hsg_name//".marker_cm")) visibility = off
   !
   marker create marker = (eval(.MODEL_1.STR_hsg_name//".LBRF")) &
    location = 0.0, 0.0, 0.0 &
    orientation = 0.0, 0.0, 0.0
   !
   entity attributes entity_name = (eval(.MODEL_1.STR_hsg_name//".LBRF")) visibility = off
   !
   part modify rigid mass_properties  &
    part_name = (eval(.MODEL_1.STR_hsg_name)) &
    mass = 1.0E-11  &
    center_of_mass_marker = (eval(.MODEL_1.STR_hsg_name//".marker_cm")) &
    inertia_marker =  (eval(.MODEL_1.STR_hsg_name//".marker_cm")) &
    ixx = 1.0E-11  &
    iyy = 1.0E-11  &
    izz = 1.0E-11
   !
   ! Radial Bearings 
   !
   for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.rad_bear_properties.values[1,1]))
      !
      marker create marker = (eval(.MODEL_1.STR_hsg_name//".marker_rad_bear_"//RTOI(i))) &
       location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i))))) &
       orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i))))) 
      ! 
      entity attributes &
       entity_name = (eval(.MODEL_1.STR_hsg_name//".marker_rad_bear_"//RTOI(i))) &
       visibility = off &
       name_visibility = off 
      !
   end
   !
   ! Axial Bearings 
   !
   for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.axi_bear_properties.values[1,1]))
      !
      marker create marker = (eval(.MODEL_1.STR_hsg_name//".marker_axi_bear_"//RTOI(i))) &
       location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_axi_bear_"//RTOI(i))))) &
       orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_axi_bear_"//RTOI(i))))) 
      !
      entity attributes &
       entity_name = (eval(.MODEL_1.STR_hsg_name//".marker_axi_bear_"//RTOI(i))) &
       visibility = off &
       name_visibility = off 
      !
   end
   !
elseif condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 2.0)      ! Housing as Part
   !
   marker create marker = (eval(.MODEL_1.STR_hsg_name//".LBRF")) &
    location = 0.0, 0.0, 0.0 &
    orientation = 0.0, 0.0, 0.0
   !
elseif condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 3.0)      ! Housing as FE Part       
   !
   marker create marker = (eval(.MODEL_1.STR_hsg_name//".LBRF")) &
    location = (loc_relative_to({0.0, 0.0, 0.0}, (eval(.MODEL_1.STR_hsg_name)))) &
    orientation = (ori_relative_to({0.0, 0.0, 0.0}, (eval(.MODEL_1.STR_hsg_name)))) &
    preserve_location = true
   ! 
   entity attributes entity_name = (eval(.MODEL_1.STR_hsg_name//".LBRF")) visibility = off
   !
end
!
!-------------------------------------------------------
return