!-------------------------------------------------------
!-------------------- Marker Build ---------------------
!-------------------------------------------------------
!
marker create marker = (eval(model_name//".ground.LBRF")) &
 location=0.0, 0.0, 0.0 &
 orientation=0.0, 0.0, 0.0
! 
entity attributes &
 entity_name = (eval(model_name//".ground.LBRF")) &
 visibility = off &
 name_visibility = off  
!
!-------------------------------------------------------
! Shaft
!-------------------------------------------------------
!
marker create marker = (eval(model_name//".ground.shaft_cw")) &
 location=0.0, 0.0, 0.0 &
 orientation=0.0, 0.0, 0.0
!
entity attributes &
 entity_name = (eval(model_name//".ground.shaft_cw")) &
 visibility = off &
 name_visibility = off  
!
marker create marker = (eval(model_name//".ground.shaft_tw")) &
 location=0.0, 0.0, (-1.0*.MODEL_1.shaft_properties.values[3]) &
 orientation=0.0, 0.0, 0.0
!
entity attributes &
 entity_name = (eval(model_name//".ground.shaft_tw")) &
 visibility = off &
 name_visibility = off  
!
! Totok treba presunut do nejakej "shaft_build.cmd"
if condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 1.0)             ! Rigid Shaft (funguje, ale nie je to obecne) 
   !    
   if condition = ((eval(.MODEL_1.shaft_properties.values[2])) == 1.0)          ! Mass Method: User Input 
      !
      marker create marker = (eval(model_name//".ground.shaft_cm")) &
       location = 0.0, 0.0, (-1.0*.MODEL_1.shaft_properties.values[6]) &
       orientation = 0.0, 0.0, 0.0
      !
      entity attributes &
       entity_name = (eval(model_name//".ground.shaft_cm")) &
       visibility = off &
       name_visibility = off   
      ! 
   end
   !
end  
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Compressor Wheel
!-------------------------------------------------------
!
! Totok treba presunut do nejakej "cw_build.cmd"
if condition = ((eval(.MODEL_1.comp_wheel_properties.values[1])) == 1.0)        ! Mass Method: User Input
   !
   marker create marker = (eval(model_name//".ground.comp_wheel_cm")) &
    location = 0.0, 0.0, (.MODEL_1.comp_wheel_properties.values[3]) &
    orientation = 0.0, 0.0, 0.0
   !
   entity attributes &
    entity_name = (eval(model_name//".ground.comp_wheel_cm")) &
    visibility = off &
    name_visibility = off  
   !
   marker create marker = (eval(model_name//".ground.thrust_force")) &
    location = 0.0, 0.0, (.MODEL_1.comp_wheel_properties.values[3]) &
    orientation = 0.0, 0.0, 0.0
   !
   entity attributes &
    entity_name = (eval(model_name//".ground.thrust_force")) &
    visibility = off &
    name_visibility = off
   !  
   marker create marker = (eval(model_name//".ground.eddy_sensor")) &
    location = 0.0, 0.0, (.MODEL_1.comp_wheel_properties.values[19]) &
    orientation = 0.0, 0.0, 0.0
   !
   entity attributes &
    entity_name = (eval(model_name//".ground.eddy_sensor")) &
    visibility = off &
    name_visibility = off
   !
end
!
marker create marker = (eval(model_name//".ground.unbalance_CW_nose")) &
 location = 0.0, (-1.0 mm), (.MODEL_1.comp_wheel_properties.values[12]) &
 orientation = 0.0, 0.0, 0.0
!
entity attributes &
 entity_name = (eval(model_name//".ground.unbalance_CW_nose")) &
 visibility = off &
 name_visibility = off
!    
marker create marker = (eval(model_name//".ground.unbalance_CW_back")) &
 location = 0.0, (-1.0 mm), (.MODEL_1.comp_wheel_properties.values[14]) &
 orientation = 0.0, 0.0, 0.0
!
entity attributes &
 entity_name = (eval(model_name//".ground.unbalance_CW_back")) &
 visibility = off &
 name_visibility = off
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Turbine Wheel
!-------------------------------------------------------
!
! Totok treba presunut do nejakej "cw_build.cmd"
if condition = ((eval(.MODEL_1.turb_wheel_properties.values[1])) == 1.0)        ! Mass Method: User Input
   !
   marker create marker = (eval(model_name//".ground.turb_wheel_cm")) &
    location=0.0, 0.0, (-1.0*.MODEL_1.turb_wheel_properties.values[3] - .MODEL_1.shaft_properties.values[3]) &
    orientation=0.0, 0.0, 0.0
   !
   entity attributes &
    entity_name = (eval(model_name//".ground.turb_wheel_cm")) &
    visibility = off &
    name_visibility = off 
   !
end
!
marker create marker = (eval(model_name//".ground.unbalance_TW_nose")) &
 location = (sin(.MODEL_1.turb_wheel_properties.values[16])*(1.0 mm)), (cos(.MODEL_1.turb_wheel_properties.values[16])*(-1.0 mm)), (-.MODEL_1.shaft_properties.values[3]-.MODEL_1.turb_wheel_properties.values[12]) &
 orientation = 0.0, 0.0, 0.0
!
entity attributes entity_name = (eval(model_name//".ground.unbalance_TW_nose")) visibility = off
!
marker create marker = (eval(model_name//".ground.unbalance_TW_back")) &
 location = (sin(.MODEL_1.turb_wheel_properties.values[16])*(1.0 mm)), (cos(.MODEL_1.turb_wheel_properties.values[16])*(-1.0 mm)), (-.MODEL_1.shaft_properties.values[3]-.MODEL_1.turb_wheel_properties.values[14]) &
 orientation = 0.0, 0.0, 0.0
!
entity attributes entity_name = (eval(model_name//".ground.unbalance_TW_back")) visibility = off
! 
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Radial Bearings
!-------------------------------------------------------
!
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.rad_bear_properties.values[1,1]))
   !
   marker create marker = (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i))) &
    location = 0.0, 0.0, (-1.0*.MODEL_1.rad_bear_properties.values[3, (eval(i))]) &
    orientation = 0.0, 0.0, 0.0
   !
   entity attributes &
    entity_name = (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i))) &
    visibility = off &
    name_visibility = off 
   !
   if condition = ((eval(.MODEL_1.rad_bear_properties.values[2,(eval(i))])) == 3.0)  ! Radial Bearing Solved by Ocvirk Solution
      !
      if condition = ((eval(.MODEL_1.rad_bear_properties.values[26,(eval(i))])) == 0.0)    ! Antirotation Pin Present 
         !
         marker create marker = (eval(model_name//".ground.bear_ring_pin_rad_"//RTOI(i))) &
          location = 0.0, (.MODEL_1.rad_bear_properties.values[23, (eval(i))]), (-1.0*.MODEL_1.rad_bear_properties.values[3, (eval(i))]) &
          orientation = 0.0, 0.0, 0.0
         !
         entity attributes entity_name = (eval(model_name//".ground.bear_ring_pin_rad_"//RTOI(i))) visibility = off
         !
      end 
      !
   end   
   !  
end
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Axial Bearings
!-------------------------------------------------------
!
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.axi_bear_properties.values[1,1]))
   !
   marker create marker = (eval(model_name//".ground.shaft_axi_bear_"//RTOI(i))) &
    location = 0.0, 0.0, (-1.0*.MODEL_1.axi_bear_properties.values[3, (eval(i))]) &
    orientation = 0.0, 0.0, 0.0
   ! 
   entity attributes &
    entity_name = (eval(model_name//".ground.shaft_axi_bear_"//RTOI(i))) &
    visibility = off &
    name_visibility = off 
   !
   if condition = ((eval(.MODEL_1.axi_bear_properties.values[2,(eval(i))])) == 2.0)  ! Axial Bearing Solved Analytically
      !
      var set var = rad_m real = (eval(0.25*((.MODEL_1.axi_bear_properties.values[12,(eval(i))]) + (.MODEL_1.axi_bear_properties.values[13,(eval(i))]))))
      var set var = tmp_angle real = (UNITS_CONVERSION_FACTOR('degree'))        ! 1.0 - degree, 180/PI - radian
      !
      
      for variable_name = j start_value = 1 end_value = (eval(.MODEL_1.axi_bear_properties.values[11,(eval(i))]))
         !
         var set var = angle_m real = (eval((j-1)*360/(eval(.MODEL_1.axi_bear_properties.values[11,(eval(i))])) + 180/(eval(.MODEL_1.axi_bear_properties.values[11,(eval(i))]))))      ! degree
         !
         marker create marker = (eval(model_name//".ground.pad_"//RTOI(j)//"_axi_bear_"//RTOI(i))) &
          location = (LOC_RELATIVE_TO({(eval(rad_m*COS(angle_m/tmp_angle))), (eval(rad_m*SIN(angle_m/tmp_angle))), 0.0}, (eval(model_name//".ground.shaft_axi_bear_"//RTOI(i))))) &
          orientation = (ORI_RELATIVE_TO({0.0, 0.0, (eval(angle_m/tmp_angle))}, (eval(model_name//".ground.shaft_axi_bear_"//RTOI(i)))))
         !
         entity attributes entity_name = (eval(model_name//".ground.pad_"//RTOI(j)//"_axi_bear_"//RTOI(i))) visibility = off
         !
      end      
      !
      var del var = rad_m
      var del var = tmp_angle
      var del var = angle_m
      !
   end
   !
end
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Test Rig
!-------------------------------------------------------
!
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.test_rig_properties.values[1]))
   !
   marker create marker = (eval(model_name//".ground.dyno_"//RTOI(i))) & 
    location = (LOC_RELATIVE_TO({0.0, 0.0, (eval(-1.0*.MODEL_1.shaft_properties.values[3]-1.0*.MODEL_1.shaft_properties.values[3]*i/.MODEL_1.test_rig_properties.values[1]))}, (eval(model_name//".ground.shaft_tw")))) &
    orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_tw"))))                                                                                
   ! 
   entity attributes &
    entity_name = (eval(model_name//".ground.dyno_"//RTOI(i))) & 
    visibility = off &
    name_visibility = off 
   !
end
!
!-------------------------------------------------------
return