!-------------------------------------------------------
!----------------- Dummy Parts Build -------------------
!-------------------------------------------------------
!
!-------------------------------------------------------
! Shaft
!-------------------------------------------------------
!
! Compressor Wheel Interaction
!
part create rigid_body name_and_position part_name = (eval(model_name//".dummy_shaft_cw"))
!
var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("second")/(60*UNITS_CONVERSION_FACTOR("revolutions"))))
!
part create rigid_body initial_velocity  &
 part_name =  (eval(model_name//".dummy_shaft_cw")) & 
 wz = (evaL(-1.0*.MODEL_1.test_rig_properties.values[2]*.MODEL_1.test_rig_properties.values[28]*tmp)) &   
 wm = (eval(model_name//".ground.LBRF"))
!          
var del var = tmp
!
part attributes part_name = (eval(model_name//".dummy_shaft_cw")) &
 color = RED name_vis = off
!
!var set var = tmp_obj object = (eval(USER_STRING(model_name//".STR_shaft_cw_marker_name")))    ! Dummy part centered to INT_NODE
var set var = tmp_obj object = (eval(model_name//".ground.shaft_cw"))                          ! Dummy part centered to Ground Marker
!
marker create marker = (eval(model_name//".dummy_shaft_cw.cm")) &
 location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) &            
 orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj))))
!
entity attributes entity_name = (eval(model_name//".dummy_shaft_cw.cm")) visibility = off
!
if condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 1.0)             ! Shaft as Rigid
   !
   var set var = tmp_obj object = (eval(model_name//".shaft.marker_shaft_cw"))
   !
elseif condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 3.0)         ! Shaft as a FE Part
   !
   var set var = tmp_obj object = (eval(USER_STRING(model_name//".STR_shaft_cw_marker_name")))
   !
end    
!
marker create marker = (eval(model_name//".dummy_shaft_cw.marker_dummy_shaft")) &
 location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) &            
 orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj))))
!
entity attributes entity_name = (eval(model_name//".dummy_shaft_cw.marker_dummy_shaft")) visibility = off
!
var set var = tmp_obj object = (eval(model_name//".ground.shaft_cw"))
!
marker create marker = (eval(model_name//".dummy_shaft_cw.marker_shaft_cw")) &
 location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) &            
 orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj))))
!
entity attributes entity_name = (eval(model_name//".dummy_shaft_cw.marker_shaft_cw")) visibility = off
!
part modify rigid mass_properties  &
 part_name = (eval(model_name//".dummy_shaft_cw")) &
 mass = 1.0E-11  &
 center_of_mass_marker = (eval(model_name//".dummy_shaft_cw.cm")) &
 inertia_marker = (eval(model_name//".dummy_shaft_cw.cm")) &
 ixx = 1.0E-11  &
 iyy = 1.0E-11  &
 izz = 1.0E-11
!
geometry create shape ellipsoid &
 ellipsoid_name = (eval(model_name//".dummy_shaft_cw.shape")) &
 x_scale_factor = (1mm) &
 y_scale_factor = (1mm) &
 z_scale_factor = (1mm) &
 center_marker  = (eval(model_name//".dummy_shaft_cw.cm")) 
!
! Turbine Wheel Interaction
!
part create rigid_body name_and_position part_name = (eval(model_name//".dummy_shaft_tw"))
!
var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("second")/(60*UNITS_CONVERSION_FACTOR("revolutions"))))
!
part create rigid_body initial_velocity  &
 part_name = (eval(model_name//".dummy_shaft_tw"))  & 
 wz = (evaL(-1.0*.MODEL_1.test_rig_properties.values[2]*.MODEL_1.test_rig_properties.values[28]*tmp)) & 
 wm = (eval(model_name//".ground.LBRF"))
!
var del var = tmp
!    
part attributes part_name = (eval(model_name//".dummy_shaft_tw")) &
 color = RED name_vis = off
!
!var set var = tmp_obj object = (eval(USER_STRING(model_name//".STR_shaft_tw_marker_name")))
var set var = tmp_obj object = (eval(model_name//".ground.shaft_tw"))
!
marker create marker = (eval(model_name//".dummy_shaft_tw.cm")) &
 location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) & 
 orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj))))
!
entity attributes entity_name = (eval(model_name//".dummy_shaft_tw.cm")) visibility = off
!
if condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 1.0)             ! Shaft as Rigid
   !
   var set var = tmp_obj object = (eval(model_name//".shaft.marker_shaft_tw"))
   !
elseif condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 3.0)         ! Shaft as a FE Part
   !
   var set var = tmp_obj object = (eval(USER_STRING(model_name//".STR_shaft_tw_marker_name")))
   !
end    
!
marker create marker = (eval(model_name//".dummy_shaft_tw.marker_dummy_shaft")) &
 location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) &            
 orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj))))
!
entity attributes entity_name = (eval(model_name//".dummy_shaft_tw.marker_dummy_shaft"))  visibility = off
!
var set var = tmp_obj object = (eval(model_name//".ground.shaft_tw"))
!
marker create marker = (eval(model_name//".dummy_shaft_tw.marker_shaft_tw")) &
 location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) &            
 orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj))))
!
entity attributes entity_name = (eval(model_name//".dummy_shaft_tw.marker_shaft_tw")) visibility = off
!   
part modify rigid mass_properties  &
 part_name = (eval(model_name//".dummy_shaft_tw")) &
 mass = 1.0E-11  &
 center_of_mass_marker = (eval(model_name//".dummy_shaft_tw.cm")) &
 inertia_marker = (eval(model_name//".dummy_shaft_tw.cm")) &
 ixx = 1.0E-11  &
 iyy = 1.0E-11  &
 izz = 1.0E-11
!
geometry create shape ellipsoid &
 ellipsoid_name = (eval(model_name//".dummy_shaft_tw.shape")) &
 x_scale_factor = (1mm) &
 y_scale_factor = (1mm) &
 z_scale_factor = (1mm) &
 center_marker  = (eval(model_name//".dummy_shaft_tw.cm")) 
!
var del var = tmp_obj
!
! Radial Bearings
!
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.rad_bear_properties.values[1,1]))
   !
   part create rigid_body name_and_position part_name = (eval(model_name//".dummy_shaft_rad_"//RTOI(i)))
   !
   var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("second")/(60*UNITS_CONVERSION_FACTOR("revolutions"))))
   !
   part create rigid_body initial_velocity  &
    part_name = (eval(model_name//".dummy_shaft_rad_"//RTOI(i)))  & 
    wz = (evaL(-1.0*.MODEL_1.test_rig_properties.values[2]*.MODEL_1.test_rig_properties.values[28]*tmp)) &
    wm = (eval(model_name//".ground.LBRF"))
   !
   var del var = tmp
   !
   part attributes part_name = (eval(model_name//".dummy_shaft_rad_"//RTOI(i))) &
    color = RED name_vis = off
   !
   !var set var = tmp_str string = (eval("STR_rad_bear_"//RTOI(i)//"_shaft_marker"))
   !var set var = tmp_obj object = (eval(USER_STRING(tmp_str)))
   var set var = tmp_str string = (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i)))
   var set var = tmp_obj object = (eval(tmp_str))
   ! 
   marker create marker = (eval(model_name//".dummy_shaft_rad_"//RTOI(i)//".cm")) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) & 
    orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj))))
   !
   entity attributes entity_name = (eval(model_name//".dummy_shaft_rad_"//RTOI(i)//".cm")) visibility = off
   !
   if condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 1.0)          ! Shaft as Rigid
      !
      var set var = tmp_str string = "None"
      var set var = tmp_obj object = (eval(model_name//".shaft.marker_rad_bear_"//RTOI(i)))
      !
   elseif condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 3.0)      ! Shaft as a FE Part
      !
      var set var = tmp_str string = (eval("STR_rad_bear_"//RTOI(i)//"_shaft_marker"))
      var set var = tmp_obj object = (eval(USER_STRING(tmp_str)))
      !
   end   
   !
   var set var = tmp_int int = (eval(UNIQUE_ID("marker")))
   !
   marker create marker =  (eval(model_name//".dummy_shaft_rad_"//RTOI(i)//".marker_dummy_shaft")) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) &            
    orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) &
    adams_id = (eval(tmp_int))
   !
   entity attributes entity_name = (eval(model_name//".dummy_shaft_rad_"//RTOI(i)//".marker_dummy_shaft")) visibility = off
   !
   ! #9
   (.MODEL_1.rad_bear_properties.values[(eval(9+40*(i-1)))]) = (eval(tmp_int))
   !
   var del var = tmp_int
   !
   var set var = tmp_str string = (eval(model_name//".dummy_shaft_rad_"//RTOI(i)//".marker_rad_bear_"//RTOI(i)//"_X"))
   !
   marker create marker = (eval(tmp_str)) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i))))) &
    orientation = (ORI_RELATIVE_TO({90.0d, 90.0d, 0.0d}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i)))))
   !
   entity attributes entity_name = (eval(tmp_str)) visibility = off
   !
   var set var = tmp_str string = (eval(model_name//".dummy_shaft_rad_"//RTOI(i)//".marker_rad_bear_"//RTOI(i)//"_Y"))
   !
   marker create marker = (eval(tmp_str)) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i))))) &
    orientation = (ORI_RELATIVE_TO({0.0d, -90.0d, 0.0d}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i)))))
   !
   entity attributes entity_name = (eval(tmp_str)) visibility = off
   !
   part modify rigid mass_properties  &
    part_name = (eval(model_name//".dummy_shaft_rad_"//RTOI(i))) &
    mass = 1.0E-11  &
    center_of_mass_marker = (eval(model_name//".dummy_shaft_rad_"//RTOI(i)//".cm")) &
    inertia_marker =  (eval(model_name//".dummy_shaft_rad_"//RTOI(i)//".cm")) &
    ixx = 1.0E-11  &
    iyy = 1.0E-11  &
    izz = 1.0E-11
   !
   geometry create shape ellipsoid &
    ellipsoid_name = (eval(model_name//".dummy_shaft_rad_"//RTOI(i)//".shape")) &
    x_scale_factor = (1mm) &
    y_scale_factor = (1mm) &
    z_scale_factor = (1mm) &
    center_marker  = (eval(model_name//".dummy_shaft_rad_"//RTOI(i)//".cm"))
   !
end
!
! Axial Bearings
!
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.axi_bear_properties.values[1,1]))
   !
   part create rigid_body name_and_position part_name = (eval(model_name//".dummy_shaft_axi_"//RTOI(i)))
   !
   var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("second")/(60*UNITS_CONVERSION_FACTOR("revolutions"))))
   !
   part create rigid_body initial_velocity  &
    part_name = (eval(model_name//".dummy_shaft_axi_"//RTOI(i)))  & 
    wz = (evaL(-1.0*.MODEL_1.test_rig_properties.values[2]*.MODEL_1.test_rig_properties.values[28]*tmp)) &
    wm = (eval(model_name//".ground.LBRF"))    
   !
   var del var = tmp
   !
   part attributes part_name = (eval(model_name//".dummy_shaft_axi_"//RTOI(i))) &
    color = RED name_vis = off
   !
   !var set var = tmp_str string = (eval("STR_axi_bear_"//RTOI(i)//"_shaft_marker"))
   !var set var = tmp_obj object = (eval(USER_STRING(tmp_str)))
   var set var = tmp_str string = (eval(model_name//".ground.shaft_axi_bear_"//RTOI(i)))
   var set var = tmp_obj object = (eval(tmp_str))
   ! 
   marker create marker = (eval(model_name//".dummy_shaft_axi_"//RTOI(i)//".cm")) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) & 
    orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj))))
   !
   entity attributes entity_name = (eval(model_name//".dummy_shaft_axi_"//RTOI(i)//".cm")) visibility = off
   !
   if condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 1.0)          ! Shaft as Rigid
      !
      var set var = tmp_str string = "None"
      var set var = tmp_obj object = (eval(model_name//".shaft.marker_axi_bear_"//RTOI(i)))
      ! 
   elseif condition = ((eval(.MODEL_1.shaft_properties.values[1])) == 3.0)      ! Shaft as a FE Part      
      !
      var set var = tmp_str string = (eval("STR_axi_bear_"//RTOI(i)//"_shaft_marker"))
      var set var = tmp_obj object = (eval(USER_STRING(tmp_str)))
      !
   end   
   !
   marker create marker =  (eval(model_name//".dummy_shaft_axi_"//RTOI(i)//".marker_dummy_shaft")) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) &            
    orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj))))
   !
   entity attributes entity_name = (eval(model_name//".dummy_shaft_axi_"//RTOI(i)//".marker_dummy_shaft")) visibility = off
   !
   var set var = tmp_str string = (eval(model_name//".dummy_shaft_axi_"//RTOI(i)//".marker_axi_bear_"//RTOI(i)//"_Z"))
   !
   marker create marker = (eval(tmp_str)) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_axi_bear_"//RTOI(i))))) &
    orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_axi_bear_"//RTOI(i)))))
   !
   entity attributes entity_name = (eval(tmp_str))  visibility = off
   !
   part modify rigid mass_properties  &
    part_name = (eval(model_name//".dummy_shaft_axi_"//RTOI(i))) &
    mass = 1.0E-11  &
    center_of_mass_marker = (eval(model_name//".dummy_shaft_axi_"//RTOI(i)//".cm")) &
    inertia_marker =  (eval(model_name//".dummy_shaft_axi_"//RTOI(i)//".cm")) &
    ixx = 1.0E-11  &
    iyy = 1.0E-11  &
    izz = 1.0E-11
   !
   geometry create shape ellipsoid &
    ellipsoid_name = (eval(model_name//".dummy_shaft_axi_"//RTOI(i)//".shape")) &
    x_scale_factor = (1mm) &
    y_scale_factor = (1mm) &
    z_scale_factor = (1mm) &
    center_marker  = (eval(model_name//".dummy_shaft_axi_"//RTOI(i)//".cm"))
   !
end
!      
var del var = tmp_str
var del var = tmp_obj 

!
!-------------------------------------------------------
! Housing
!-------------------------------------------------------
!
! Radial Bearings
!
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.rad_bear_properties.values[1,1]))
   !
   part create rigid_body name_and_position part_name = (eval(model_name//".dummy_hsg_rad_"//RTOI(i)))
   !
   part create rigid_body initial_velocity  &
    part_name = (eval(model_name//".dummy_hsg_rad_"//RTOI(i)))  
   !
   part attributes part_name = (eval(model_name//".dummy_hsg_rad_"//RTOI(i))) &
    color = RED name_vis = off
   !
   !var set var = tmp_str string = (eval("STR_rad_bear_"//RTOI(i)//"_hsg_marker"))
   !var set var = tmp_obj object = (eval(USER_STRING(tmp_str)))
   var set var = tmp_str string = (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i)))
   var set var = tmp_obj object = (eval(tmp_str))
   !
   marker create marker = (eval(model_name//".dummy_hsg_rad_"//RTOI(i)//".cm")) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) & 
    orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj))))
   !
   entity attributes entity_name = (eval(model_name//".dummy_hsg_rad_"//RTOI(i)//".cm")) visibility = off
   !
   if condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 1.0)       ! Housing as Rigid
      !
      var set var = tmp_str string = "None"
      var set var = tmp_obj object = (eval(model_name//".housing.marker_rad_bear_"//RTOI(i)))
      !
   elseif condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 3.0)   ! Housing as a FE Part      
      !
      var set var = tmp_str string = (eval("STR_rad_bear_"//RTOI(i)//"_hsg_marker"))
      var set var = tmp_obj object = (eval(USER_STRING(tmp_str)))
      !
   end   
   !
   var set var = tmp_int int = (eval(UNIQUE_ID("marker")))
   !
   marker create marker =  (eval(model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_dummy_hsg")) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) &            
    orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) &
    adams_id = (eval(tmp_int))
   !
   entity attributes entity_name = (eval(model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_dummy_hsg")) visibility = off
   !
   ! #10
   (.MODEL_1.rad_bear_properties.values[(eval(10+40*(i-1)))]) = (eval(tmp_int))
   !
   var del var = tmp_int
   !
   var set var = tmp_str string = (eval(model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_rad_bear_"//RTOI(i)//"_X"))
   !
   marker create marker = (eval(tmp_str)) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i))))) &
    orientation = (ORI_RELATIVE_TO({90.0d, 90.0d, 0.0d}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i)))))
   !
   entity attributes entity_name = (eval(tmp_str))  visibility = off
   !
   var set var = tmp_str string = (eval(model_name//".dummy_hsg_rad_"//RTOI(i)//".marker_rad_bear_"//RTOI(i)//"_Y"))
   !
   marker create marker = (eval(tmp_str)) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i))))) &
    orientation = (ORI_RELATIVE_TO({0.0d, -90.0d, 0.0d}, (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i)))))
   !
   entity attributes entity_name = (eval(tmp_str))  visibility = off
   !
   part modify rigid mass_properties  &
    part_name = (eval(model_name//".dummy_hsg_rad_"//RTOI(i))) &
    mass = 1.0E-11  &
    center_of_mass_marker = (eval(model_name//".dummy_hsg_rad_"//RTOI(i)//".cm")) &
    inertia_marker = (eval(model_name//".dummy_hsg_rad_"//RTOI(i)//".cm")) &
    ixx = 1.0E-11  &
    iyy = 1.0E-11  &
    izz = 1.0E-11
   !
   geometry create shape ellipsoid &
    ellipsoid_name = (eval(model_name//".dummy_hsg_rad_"//RTOI(i)//".shape")) &
    x_scale_factor = (1mm) &
    y_scale_factor = (1mm) &
    z_scale_factor = (1mm) &
    center_marker  = (eval(model_name//".dummy_hsg_rad_"//RTOI(i)//".cm"))
   ! 
end  
!
! Axial Bearings
!
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.axi_bear_properties.values[1,1]))
   !
   part create rigid_body name_and_position part_name = (eval(model_name//".dummy_hsg_axi_"//RTOI(i)))
   !
   part create rigid_body initial_velocity  &
    part_name = (eval(model_name//".dummy_hsg_axi_"//RTOI(i)))  
   !
   part attributes part_name = (eval(model_name//".dummy_hsg_axi_"//RTOI(i))) &
    color = RED name_vis = off
   !
   !var set var = tmp_str string = (eval("STR_axi_bear_"//RTOI(i)//"_hsg_marker"))
   !var set var = tmp_obj object = (eval(USER_STRING(tmp_str)))
   var set var = tmp_str string = (eval(model_name//".ground.shaft_axi_bear_"//RTOI(i)))
   var set var = tmp_obj object = (eval(tmp_str))
   !
   marker create marker = (eval(model_name//".dummy_hsg_axi_"//RTOI(i)//".cm")) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) & 
    orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj))))
   !
   entity attributes entity_name = (eval(model_name//".dummy_hsg_axi_"//RTOI(i)//".cm")) visibility = off
   !
   if condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 1.0)       ! Housing as Rigid
      !
      var set var = tmp_str string = "None"
      var set var = tmp_obj object = (eval(model_name//".housing.marker_axi_bear_"//RTOI(i)))
      !
   elseif condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 3.0)   ! Housing as a FE Part      
      !
      var set var = tmp_str string = (eval("STR_axi_bear_"//RTOI(i)//"_hsg_marker"))
      var set var = tmp_obj object = (eval(USER_STRING(tmp_str)))
      !
   end
   !   
   marker create marker =  (eval(model_name//".dummy_hsg_axi_"//RTOI(i)//".marker_dummy_hsg")) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) &            
    orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj))))
   !
   entity attributes entity_name = (eval(model_name//".dummy_hsg_axi_"//RTOI(i)//".marker_dummy_hsg")) visibility = off
   !
   var set var = tmp_str string = (eval(model_name//".dummy_hsg_axi_"//RTOI(i)//".marker_axi_bear_"//RTOI(i)//"_Z"))
   !
   marker create marker = (eval(tmp_str)) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_axi_bear_"//RTOI(i))))) &
    orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_axi_bear_"//RTOI(i)))))
   !
   entity attributes entity_name = (eval(tmp_str)) visibility = off
   !
   part modify rigid mass_properties  &
    part_name = (eval(model_name//".dummy_hsg_axi_"//RTOI(i))) &
    mass = 1.0E-11  &
    center_of_mass_marker = (eval(model_name//".dummy_hsg_axi_"//RTOI(i)//".cm")) &
    inertia_marker = (eval(model_name//".dummy_hsg_axi_"//RTOI(i)//".cm")) &
    ixx = 1.0E-11  &
    iyy = 1.0E-11  &
    izz = 1.0E-11
   !
   geometry create shape ellipsoid &
    ellipsoid_name = (eval(model_name//".dummy_hsg_axi_"//RTOI(i)//".shape")) &
    x_scale_factor = (1mm) &
    y_scale_factor = (1mm) &
    z_scale_factor = (1mm) &
    center_marker  = (eval(model_name//".dummy_hsg_axi_"//RTOI(i)//".cm"))
   !
end
!
var del var = tmp_str
var del var = tmp_obj
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Bearing Rings
!-------------------------------------------------------
!
! Radial Bearings
!
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.rad_bear_properties.values[1,1]))
   !
   if condition = ((eval(.MODEL_1.rad_bear_properties.values[2,(eval(i))])) == 3.0)    ! Bearing Solved by Ocvirk
      !
      part create rigid_body name_and_position part_name = (eval(model_name//".dummy_ring_rad_"//RTOI(i)))
      !
      part create rigid_body initial_velocity  &
       part_name = (eval(model_name//".dummy_ring_rad_"//RTOI(i))) 
      !
      if condition = ((eval(.MODEL_1.rad_bear_properties.values[26,(eval(i))])) == 1.0)             ! Rotating Bearing Ring  
         !
         var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("second")/(60*UNITS_CONVERSION_FACTOR("revolutions"))))
         !
         part modify rigid_body initial_velocity  &
          part_name = (eval(model_name//".dummy_ring_rad_"//RTOI(i))) &
          wz = (evaL(-0.28*.MODEL_1.test_rig_properties.values[2]*.MODEL_1.test_rig_properties.values[28]*tmp)) &   
          wm = (eval(model_name//".ground.LBRF"))
         !
         var del var = tmp
         !
      end    
      !
      part attributes part_name = (eval(model_name//".dummy_ring_rad_"//RTOI(i))) &
      color = RED name_vis = off
      !
      var set var = tmp_str string = (eval(model_name//".ground.shaft_rad_bear_"//RTOI(i)))
      var set var = tmp_obj object = (eval(tmp_str))
      !
      marker create marker = (eval(model_name//".dummy_ring_rad_"//RTOI(i)//".cm")) &
       location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) & 
       orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj))))
      !
      entity attributes entity_name = (eval(model_name//".dummy_ring_rad_"//RTOI(i)//".cm")) visibility = off
      !
!      if condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 1.0)       ! Housing as Rigid
!         !
!         var set var = tmp_str string = "None"
!         var set var = tmp_obj object = (eval(model_name//".housing.marker_rad_bear_"//RTOI(i)))
!         !
!      elseif condition = ((eval(.MODEL_1.cent_hsg_properties.values[1])) == 3.0)   ! Housing as a FE Part      
!         !
!         var set var = tmp_str string = (eval("STR_rad_bear_"//RTOI(i)//"_hsg_marker"))
!         var set var = tmp_obj object = (eval(USER_STRING(tmp_str)))
!         !
!      end   
      !
      var set var = tmp_int int = (eval(UNIQUE_ID("marker")))
      !
      marker create marker =  (eval(model_name//".dummy_ring_rad_"//RTOI(i)//".marker_dummy_ring")) &
       location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) &            
       orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) &
       adams_id = (eval(tmp_int))
      !
      entity attributes entity_name = (eval(model_name//".dummy_ring_rad_"//RTOI(i)//".marker_dummy_ring")) visibility = off
      !
      ! #11
      (.MODEL_1.rad_bear_properties.values[(eval(11+40*(i-1)))]) = (eval(tmp_int))
      !
      var del var = tmp_int
      !
      part modify rigid mass_properties  &
       part_name = (eval(model_name//".dummy_ring_rad_"//RTOI(i))) &
       mass = 1.0E-11  &
       center_of_mass_marker = (eval(model_name//".dummy_ring_rad_"//RTOI(i)//".cm")) &
       inertia_marker = (eval(model_name//".dummy_ring_rad_"//RTOI(i)//".cm")) &
       ixx = 1.0E-11  &
       iyy = 1.0E-11  &
       izz = 1.0E-11
      !
      geometry create shape ellipsoid &
       ellipsoid_name = (eval(model_name//".dummy_ring_rad_"//RTOI(i)//".shape")) &
       x_scale_factor = (1mm) &
       y_scale_factor = (1mm) &
       z_scale_factor = (1mm) &
       center_marker  = (eval(model_name//".dummy_ring_rad_"//RTOI(i)//".cm"))
      !
      if condition = ((eval(.MODEL_1.rad_bear_properties.values[26,(eval(i))])) == 0.0)    ! Antirotation Pin Present 
         !
         part create rigid_body name_and_position part_name = (eval(model_name//".dummy_ring_pin_rad_"//RTOI(i)))
         !
         part create rigid_body initial_velocity  &
          part_name = (eval(model_name//".dummy_ring_pin_rad_"//RTOI(i))) 
         !
         part attributes part_name = (eval(model_name//".dummy_ring_pin_rad_"//RTOI(i))) &
         color = RED name_vis = off
         !
         var set var = tmp_str string = (eval(model_name//".ground.bear_ring_pin_rad_"//RTOI(i)))
         var set var = tmp_obj object = (eval(tmp_str))
         !
         marker create marker = (eval(model_name//".dummy_ring_pin_rad_"//RTOI(i)//".cm")) &
          location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) & 
          orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj))))
         !
         entity attributes entity_name = (eval(model_name//".dummy_ring_pin_rad_"//RTOI(i)//".cm")) visibility = off
         !
         marker create marker = (eval(model_name//".dummy_ring_pin_rad_"//RTOI(i)//".marker_dummy_pin")) &
          location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) &            
          orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj))))
         ! 
         entity attributes entity_name = (eval(model_name//".dummy_ring_pin_rad_"//RTOI(i)//".marker_dummy_pin")) visibility = off
         !
         marker create marker = (eval(model_name//".dummy_ring_pin_rad_"//RTOI(i)//".marker_rad_bear_"//RTOI(i)//"_X")) &  
          location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) & 
          orientation = (ORI_RELATIVE_TO({90.0d, 90.0d, 0.0d}, (eval(tmp_obj)))) 
         !
         entity attributes entity_name = (eval(model_name//".dummy_ring_pin_rad_"//RTOI(i)//".marker_rad_bear_"//RTOI(i)//"_X")) visibility = off
         !
         part modify rigid mass_properties  &
          part_name = (eval(model_name//".dummy_ring_pin_rad_"//RTOI(i))) &
          mass = 1.0E-11  &
          center_of_mass_marker = (eval(model_name//".dummy_ring_pin_rad_"//RTOI(i)//".cm")) &
          inertia_marker = (eval(model_name//".dummy_ring_pin_rad_"//RTOI(i)//".cm")) &
          ixx = 1.0E-11  &
          iyy = 1.0E-11  &
          izz = 1.0E-11
         !
         geometry create shape ellipsoid &
          ellipsoid_name = (eval(model_name//".dummy_ring_pin_rad_"//RTOI(i)//".shape")) &
          x_scale_factor = (1mm) &
          y_scale_factor = (1mm) &
          z_scale_factor = (1mm) &
          center_marker  = (eval(model_name//".dummy_ring_pin_rad_"//RTOI(i)//".cm")) 
         !
         var del var = tmp_str
         var del var = tmp_obj
         !
      end
      !
   end
   !    
end  
!
!-------------------------------------------------------
!
!
!-------------------------------------------------------
! Thrust Bearings
!-------------------------------------------------------
!
for variable_name = i start_value = 1 end_value = (eval(.MODEL_1.axi_bear_properties.values[1,1]))
   !
   if condition = ((eval(.MODEL_1.axi_bear_properties.values[2,(eval(i))])) == 2.0)    ! Bearing Solved Analytically
      !
      part create rigid_body name_and_position part_name = (eval(model_name//".dummy_thrust_axi_"//RTOI(i)))
      !
      part attributes part_name = (eval(model_name//".dummy_thrust_axi_"//RTOI(i))) &
       color = RED name_vis = off
      !
      var set var = tmp_str string = (eval(model_name//".ground.shaft_axi_bear_"//RTOI(i)))
      var set var = tmp_obj object = (eval(tmp_str))
      !
      marker create marker = (eval(model_name//".dummy_thrust_axi_"//RTOI(i)//".cm")) &
       location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) & 
       orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj))))
      !
      entity attributes entity_name = (eval(model_name//".dummy_thrust_axi_"//RTOI(i)//".cm")) visibility = off
      !
      var set var = tmp_int int = (eval(UNIQUE_ID("marker")))
      !
      marker create marker =  (eval(model_name//".dummy_thrust_axi_"//RTOI(i)//".marker_dummy_thrust")) &
       location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) &            
       orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(tmp_obj)))) &
       adams_id = (eval(tmp_int))
      !
      entity attributes entity_name = (eval(model_name//".dummy_thrust_axi_"//RTOI(i)//".marker_dummy_thrust")) visibility = off
      !
      ! #17
      (.MODEL_1.axi_bear_properties.values[(eval(17+35*(i-1)))]) = (eval(tmp_int))
      !
      var del var = tmp_int
      !
      part modify rigid mass_properties  &
       part_name = (eval(model_name//".dummy_thrust_axi_"//RTOI(i))) &
       mass = 1.0E-11  &
       center_of_mass_marker = (eval(model_name//".dummy_thrust_axi_"//RTOI(i)//".cm")) &
       inertia_marker = (eval(model_name//".dummy_thrust_axi_"//RTOI(i)//".cm")) &
       ixx = 1.0E-11  &
       iyy = 1.0E-11  &
       izz = 1.0E-11
      !
      geometry create shape ellipsoid &
       ellipsoid_name = (eval(model_name//".dummy_thrust_axi_"//RTOI(i)//".shape")) &
       x_scale_factor = (1mm) &
       y_scale_factor = (1mm) &
       z_scale_factor = (1mm) &
       center_marker  = (eval(model_name//".dummy_thrust_axi_"//RTOI(i)//".cm"))
      !
   end
   !
end
!
!-------------------------------------------------------