!-------------------------------------------------------
!--------------- Compressor Wheel Build ----------------
! Data stored in array called ".comp_wheel_properties"
!-------------------------------------------------------
!
if condition = ((eval(.MODEL_1.comp_wheel_properties.values[1])) == 1.0)             ! Mass Method: User Input
   !
   part create rigid_body name_and_position part_name = (eval(model_name//".comp_wheel")) 
   !
   var set var = tmp real = (eval(UNITS_CONVERSION_FACTOR("second")/(60*UNITS_CONVERSION_FACTOR("revolutions"))))
   !
   part create rigid_body initial_velocity  &
    part_name = (eval(model_name//".comp_wheel"))  &
    wz = (evaL(-1.0*.MODEL_1.test_rig_properties.values[2]*.MODEL_1.test_rig_properties.values[28]*tmp)) &                   ! UNITS(angle)/UNITS(time)
    wm = (eval(model_name//".ground.LBRF"))
   !
   part attributes part_name = (eval(model_name//".comp_wheel")) color = BLUE name_vis = off
   !
   marker create marker = (eval(model_name//".comp_wheel.marker_cw_shaft")) &
    location=(LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_cw")))) &
    orientation=(ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_cw"))))
   !
   entity attributes &
    entity_name = (eval(model_name//".comp_wheel.marker_cw_shaft")) &
    visibility = off &
    name_visibility = off 
   !  
   marker create marker = (eval(model_name//".comp_wheel.marker_cm")) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.comp_wheel_cm")))) &
    orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.comp_wheel_cm"))))  
   !
   entity attributes &
    entity_name = (eval(model_name//".comp_wheel.marker_cm")) &
    visibility = off &
    name_visibility = off 
   !
   marker create marker = (eval(model_name//".comp_wheel.marker_thrust_force")) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.thrust_force")))) &
    orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.thrust_force"))))  
   !
   entity attributes &
    entity_name = (eval(model_name//".comp_wheel.marker_thrust_force")) &
    visibility = off &
    name_visibility = off 
   ! 
   file stereo read  &
    file_name = "C:\MSC.Software\TC_wizzard\models\comp_wheel_model.stl"  &
    part_name = (eval(model_name//".comp_wheel")) &
    scale = (eval(.MODEL_1.comp_wheel_properties.values[17]/100.0)) &
    location=(LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_cw")))) &
    orientation=(ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.shaft_cw")))) 
   !
!   entity attributes &
!    entity_name     = (eval(model_name//".comp_wheel.default_pshell_property")) &
!    type_filter     = Shell &
!    color           = .colors.BLUE
   !
   part modify rigid_body mass_properties part_name=(eval(model_name//".comp_wheel")) &
    mass = (.MODEL_1.comp_wheel_properties.values[2]) & 
    center_of_mass_marker = (eval(model_name//".comp_wheel.marker_cm")) &
    inertia_marker = (eval(model_name//".comp_wheel.marker_cm")) &
    ixx = (.MODEL_1.comp_wheel_properties.values[4]) & 
    iyy = (.MODEL_1.comp_wheel_properties.values[5]) & 
    izz = (.MODEL_1.comp_wheel_properties.values[6]) 
   !
   if condition = ((eval(.MODEL_1.comp_wheel_properties.values[11])) == 1.0)         ! Off Diagonal Terms
      part modify rigid_body mass_properties part_name=(eval(model_name//".comp_wheel")) &
       ixy = (.MODEL_1.comp_wheel_properties.values[7]) & 
       iyz = (.MODEL_1.comp_wheel_properties.values[8]) &
       izx = (.MODEL_1.comp_wheel_properties.values[9])  
   end
   !
   var del var = tmp
   !
   marker create marker = (eval(model_name//".comp_wheel.marker_eddy_sensor")) &
    location = (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.eddy_sensor")))) &
    orientation = (ORI_RELATIVE_TO({0.0, 0.0, 0.0}, (eval(model_name//".ground.eddy_sensor"))))  
   !
   entity attributes &
    entity_name = (eval(model_name//".comp_wheel.marker_eddy_sensor")) &
    visibility = off &
    name_visibility = off 
   !
elseif condition = ((eval(.MODEL_1.comp_wheel_properties.values[1])) == 2.0)    ! Mass Method: Geometry and Density   
   ! N/A yet
elseif condition = ((eval(.MODEL_1.comp_wheel_properties.values[1])) == 3.0)    ! Mass Method: Geometry and Material Type     
   ! N/A yet
end
!
! Nose Unbalance
!
part create point_mass name_and_position  &
   point_mass_name = (eval(model_name//".UN_CW_nose"))  &
   location = (LOC_RELATIVE_TO({0.0, 0.0,0}, (eval(model_name//".ground.unbalance_CW_nose")))) &
   orientation = (ORI_RELATIVE_TO({0.0d, 0.0d, 0.0d}, (eval(model_name//".ground.unbalance_CW_nose"))))
!
marker create  &
   marker_name = (eval(model_name//".UN_CW_nose.cm")) &
   location = (LOC_RELATIVE_TO({0.0, 0.0,0}, (eval(model_name//".ground.unbalance_CW_nose")))) &
   orientation = (ORI_RELATIVE_TO({0.0d, 0.0d, 0.0d}, (eval(model_name//".ground.unbalance_CW_nose"))))
!
entity attributes entity_name = (eval(model_name//".UN_CW_nose.cm")) visibility = off
!
part create point_mass mass_properties  &
   point_mass_name = (eval(model_name//".UN_CW_nose"))  &
   mass = (.MODEL_1.comp_wheel_properties.values[13])  &
   center_of_mass_marker = (eval(model_name//".UN_CW_nose.cm"))
!
entity attributes &
 entity_name = (eval(model_name//".UN_CW_nose")) &
 size = 1
!
!
! Backplate Unbalance
!
part create point_mass name_and_position  &
   point_mass_name = (eval(model_name//".UN_CW_back"))  &
   location = (LOC_RELATIVE_TO({0.0, 0.0,0}, (eval(model_name//".ground.unbalance_CW_back")))) &
   orientation = (ORI_RELATIVE_TO({0.0d, 0.0d, 0.0d}, (eval(model_name//".ground.unbalance_CW_back"))))
!
marker create  &
   marker_name = (eval(model_name//".UN_CW_back.cm")) &
   location = (LOC_RELATIVE_TO({0.0, 0.0,0}, (eval(model_name//".ground.unbalance_CW_back")))) &
   orientation = (ORI_RELATIVE_TO({0.0d, 0.0d, 0.0d}, (eval(model_name//".ground.unbalance_CW_back"))))
! 
entity attributes entity_name = (eval(model_name//".UN_CW_back.cm")) visibility = off
!
part create point_mass mass_properties  &
   point_mass_name = (eval(model_name//".UN_CW_back"))  &
   mass = (.MODEL_1.comp_wheel_properties.values[15])  &
   center_of_mass_marker = (eval(model_name//".UN_CW_back.cm"))
!
entity attributes &
 entity_name = (eval(model_name//".UN_CW_back")) &
 size = 1
!
!-------------------------------------------------------
return